/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricRegistry;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogMetricsReporter {
    @Mock
    HoodieWriteConfig config;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;
    @Mock
    MetricRegistry registry;

    @AfterEach
    void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Test
    public void instantiationShouldFailWhenNoApiKey() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"table1");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"");
        Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> {
            this.hoodieMetrics = new HoodieMetrics(this.config);
            this.metrics = this.hoodieMetrics.getMetrics();
        });
        Assertions.assertEquals((Object)"Datadog cannot be initialized: API key is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldFailWhenNoMetricPrefix() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"table1");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogMetricPrefix()).thenReturn((Object)"");
        Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> {
            this.hoodieMetrics = new HoodieMetrics(this.config);
            this.metrics = this.hoodieMetrics.getMetrics();
        });
        Assertions.assertEquals((Object)"Datadog cannot be initialized: Metric prefix is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldSucceed() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getTableName()).thenReturn((Object)"table1");
        Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.config.getDatadogApiSite()).thenReturn((Object)DatadogHttpClient.ApiSite.EU);
        Mockito.when((Object)this.config.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogApiKeySkipValidation()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getDatadogMetricPrefix()).thenReturn((Object)"bar");
        Mockito.when((Object)this.config.getDatadogMetricHost()).thenReturn((Object)"foo");
        Mockito.when((Object)this.config.getDatadogMetricTags()).thenReturn(Arrays.asList("baz", "foo"));
        Mockito.when((Object)this.config.getDatadogReportPeriodSeconds()).thenReturn((Object)10);
        Mockito.when((Object)this.config.getMetricReporterMetricsNamePrefix()).thenReturn((Object)"");
        Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Assertions.assertDoesNotThrow(() -> {
            this.hoodieMetrics = new HoodieMetrics(this.config);
            this.metrics = this.hoodieMetrics.getMetrics();
        });
    }
}

