/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.MetricUtils;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.prometheus.PushGatewayMetricsReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestPushGateWayReporter {
    static final URL PROP_FILE_PROMETHEUS_URL = TestPushGateWayReporter.class.getClassLoader().getResource("prometheus.properties");
    static final URL PROP_FILE_DATADOG_URL = TestPushGateWayReporter.class.getClassLoader().getResource("datadog.properties");
    @Mock
    HoodieWriteConfig config;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;

    @AfterEach
    void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Test
    public void testRegisterGauge() {
        Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        Assertions.assertDoesNotThrow(() -> {
            this.hoodieMetrics = new HoodieMetrics(this.config);
            this.metrics = this.hoodieMetrics.getMetrics();
        });
        this.metrics.registerGauge("pushGateWayReporter_metric", 123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)this.metrics.getRegistry().getGauges().get("pushGateWayReporter_metric")).getValue().toString());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiReporter(boolean addDefaultReporter) throws IOException, InterruptedException, URISyntaxException {
        String propPrometheusPath = Objects.requireNonNull(PROP_FILE_PROMETHEUS_URL).toURI().getPath();
        String propDatadogPath = Objects.requireNonNull(PROP_FILE_DATADOG_URL).toURI().getPath();
        if (addDefaultReporter) {
            Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
            Mockito.when((Object)this.config.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.PROMETHEUS_PUSHGATEWAY);
            Mockito.when((Object)this.config.getPushGatewayReportPeriodSeconds()).thenReturn((Object)30);
        } else {
            Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
            Mockito.when((Object)this.config.getMetricReporterMetricsNamePrefix()).thenReturn((Object)TestPushGateWayReporter.class.getSimpleName());
            Mockito.when((Object)this.config.getMetricReporterFileBasedConfigs()).thenReturn((Object)(propPrometheusPath + "," + propDatadogPath));
            Mockito.when((Object)this.config.isMetricsOn()).thenReturn((Object)true);
        }
        this.hoodieMetrics = new HoodieMetrics(this.config);
        this.metrics = this.hoodieMetrics.getMetrics();
        HashMap<String, Long> metricsMap = new HashMap<String, Long>();
        HashMap<String, Long> labellessMetricMap = new HashMap<String, Long>();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", "a");
        labels.put("job", "0");
        metricsMap.put("with_label_metric;group:a,job:0", 1L);
        labellessMetricMap.put("without_label_metric", 1L);
        this.metrics.registerGauges(metricsMap, Option.empty());
        this.metrics.registerGauges(labellessMetricMap, Option.empty());
        ArrayList metricKeys = new ArrayList(this.metrics.getRegistry().getGauges().keySet());
        Assertions.assertEquals((int)0, (int)((Map)MetricUtils.getLabelsAndMetricMap((String)metricKeys.stream().filter(x -> x.contains("without_label_metric")).findFirst().get()).getValue()).size());
        Assertions.assertEquals(labels, (Object)MetricUtils.getLabelsAndMetricMap((String)metricKeys.stream().filter(x -> x.contains("with_label_metric")).findFirst().get()).getValue());
    }

    @Test
    public void testMetricLabels() {
        Mockito.when((Object)this.config.getPushGatewayLabels()).thenReturn((Object)"hudi:prometheus");
        PushGatewayMetricsReporter reporter = new PushGatewayMetricsReporter(this.config, null);
        Map labels = reporter.getLabels();
        Assertions.assertEquals((int)1, (int)labels.size());
        Assertions.assertTrue((boolean)labels.containsKey("hudi"));
        Assertions.assertTrue((boolean)labels.containsValue("prometheus"));
        Mockito.when((Object)this.config.getPushGatewayLabels()).thenReturn((Object)"hudi:prome:theus");
        reporter = new PushGatewayMetricsReporter(this.config, null);
        labels = reporter.getLabels();
        Assertions.assertEquals((int)1, (int)labels.size());
        Assertions.assertTrue((boolean)labels.containsKey("hudi"));
        Assertions.assertTrue((boolean)labels.containsValue("prome:theus"));
        Mockito.when((Object)this.config.getPushGatewayLabels()).thenReturn((Object)"hudiprometheus");
        reporter = new PushGatewayMetricsReporter(this.config, null);
        labels = reporter.getLabels();
        Assertions.assertEquals((int)1, (int)labels.size());
        Assertions.assertTrue((boolean)labels.containsKey("hudiprometheus"));
        Assertions.assertTrue((boolean)labels.containsValue(""));
        Mockito.when((Object)this.config.getPushGatewayLabels()).thenReturn((Object)"hudi1:prometheus,hudi2:prometheus");
        reporter = new PushGatewayMetricsReporter(this.config, null);
        labels = reporter.getLabels();
        Assertions.assertEquals((int)2, (int)labels.size());
        Assertions.assertTrue((boolean)labels.containsKey("hudi1"));
        Assertions.assertTrue((boolean)labels.containsKey("hudi2"));
        Assertions.assertTrue((boolean)labels.containsValue("prometheus"));
        try {
            Mockito.when((Object)this.config.getPushGatewayLabels()).thenReturn((Object)"hudi:prometheus,hudi:prom");
            reporter = new PushGatewayMetricsReporter(this.config, null);
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Multiple values {prometheus, prom} for same key"));
        }
    }
}

