/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestBulkInsertPartitioner {
    private static Stream<Arguments> argsForTryPrependPartitionColumns() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList("_hoodie_partition_path", "col1", "col2").toArray(), Arrays.asList("col1", "col2").toArray(), true, "pt"}), Arguments.of((Object[])new Object[]{Arrays.asList("_hoodie_partition_path", "col1", "col2").toArray(), Arrays.asList("col1", "_hoodie_partition_path", "col2").toArray(), true, "pt"}), Arguments.of((Object[])new Object[]{Arrays.asList("col1", "col2").toArray(), Arrays.asList("col1", "col2").toArray(), false, ""}), Arguments.of((Object[])new Object[]{Arrays.asList("pt1", "col1", "col2").toArray(), Arrays.asList("col1", "col2").toArray(), false, "pt1"}), Arguments.of((Object[])new Object[]{Arrays.asList("pt1", "pt2", "col1", "col2").toArray(), Arrays.asList("col1", "col2").toArray(), false, "pt1,pt2"}), Arguments.of((Object[])new Object[]{Arrays.asList("pt1", "pt2", "col1", "col2").toArray(), Arrays.asList("col1", "pt1", "col2").toArray(), false, "pt1,pt2"}));
    }

    @ParameterizedTest
    @MethodSource(value={"argsForTryPrependPartitionColumns"})
    public void testTryPrependPartitionColumns(String[] expectedSortColumns, String[] sortColumns, boolean populateMetaField, String partitionColumnName) {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), partitionColumnName);
        props.setProperty(HoodieTableConfig.POPULATE_META_FIELDS.key(), String.valueOf(populateMetaField));
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/").withProperties(props).build();
        Assertions.assertArrayEquals((Object[])expectedSortColumns, (Object[])BulkInsertPartitioner.tryPrependPartitionPathColumns((String[])sortColumns, (HoodieWriteConfig)writeConfig));
    }
}

