/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.client.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.hudi.callback.client.http.HoodieWriteCommitHttpCallbackClient;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestCallbackHttpClient {
    public static final String FAKE_API_KEY = "fake_api_key";
    public static final String FAKE_URL = "fake_url";
    public static final String CALLBACK_MSG = "{}";
    public static final String RESPONSE_UNAUTHORIZED = "unauthorized";
    @Mock
    Appender appender;
    @Captor
    ArgumentCaptor<LogEvent> logCaptor;
    @Mock
    CloseableHttpClient httpClient;
    @Mock
    CloseableHttpResponse httpResponse;
    @Mock
    StatusLine statusLine;
    private Level initialLogLevel;

    TestCallbackHttpClient() {
    }

    @BeforeEach
    void prepareAppender() {
        Mockito.when((Object)this.appender.getName()).thenReturn((Object)("MockAppender-" + UUID.randomUUID()));
        Mockito.when((Object)this.appender.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.appender.isStopped()).thenReturn((Object)false);
        Logger logger = (Logger)LogManager.getLogger(HoodieWriteCommitHttpCallbackClient.class);
        this.initialLogLevel = logger.getLevel();
        logger.setLevel(Level.DEBUG);
        logger.addAppender(this.appender);
    }

    @AfterEach
    void resetMocks() {
        Logger logger = (Logger)LogManager.getLogger(HoodieWriteCommitHttpCallbackClient.class);
        logger.setLevel(this.initialLogLevel);
        logger.removeAppender(this.appender);
        Mockito.reset((Object[])new Object[]{this.appender, this.httpClient, this.httpResponse, this.statusLine});
    }

    private void mockResponse(int statusCode) {
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)this.statusLine);
        try {
            Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)this.httpResponse);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    void sendPayloadShouldLogWhenRequestFailed() throws IOException {
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenThrow(IOException.class);
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient(FAKE_API_KEY, FAKE_URL, this.httpClient, null);
        hoodieWriteCommitCallBackHttpClient.send(CALLBACK_MSG);
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send callback.", (Object)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    void sendPayloadShouldLogUnsuccessfulSending() {
        this.mockResponse(401);
        Mockito.when((Object)this.httpResponse.toString()).thenReturn((Object)RESPONSE_UNAUTHORIZED);
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient(FAKE_API_KEY, FAKE_URL, this.httpClient, null);
        hoodieWriteCommitCallBackHttpClient.send(CALLBACK_MSG);
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertEquals((Object)"Failed to send callback message. Response was unauthorized", (Object)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage());
        Assertions.assertEquals((Object)Level.WARN, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    void sendPayloadShouldLogSuccessfulSending() {
        this.mockResponse(202);
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("key1", "val1");
        customHeaders.put("key2", "val2");
        HoodieWriteCommitHttpCallbackClient hoodieWriteCommitCallBackHttpClient = new HoodieWriteCommitHttpCallbackClient(FAKE_API_KEY, FAKE_URL, this.httpClient, customHeaders);
        hoodieWriteCommitCallBackHttpClient.send(CALLBACK_MSG);
        ((Appender)Mockito.verify((Object)this.appender)).append((LogEvent)this.logCaptor.capture());
        Assertions.assertTrue((boolean)((LogEvent)this.logCaptor.getValue()).getMessage().getFormattedMessage().startsWith("Sent Callback data with 2 custom headers"));
        Assertions.assertEquals((Object)Level.INFO, (Object)((LogEvent)this.logCaptor.getValue()).getLevel());
    }

    @Test
    void testParsingCustomHeaders() {
        String customHeaders = "Authorization :Basic 12345678";
        HoodieWriteCommitHttpCallbackClient client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)"{Authorization=Basic 12345678}", (Object)client.getCustomHeaders());
        customHeaders = "Authorization :Basic 12345678; another_header_key : another_header_value ";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)"{Authorization=Basic 12345678, another_header_key=another_header_value}", (Object)client.getCustomHeaders());
        customHeaders = "Authorization:Basic 12345678;";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)"{Authorization=Basic 12345678}", (Object)client.getCustomHeaders());
        customHeaders = "Authorization:Basic 12345678;uu";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)"{Authorization=Basic 12345678}", (Object)client.getCustomHeaders());
        customHeaders = "Authorization:";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = ":Authorization";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = "Authorization:Basic 12345678:Second header:val";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = null;
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = "";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = "  ";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
        customHeaders = "  : ";
        client = this.makeClient(customHeaders);
        Assertions.assertEquals((Object)CALLBACK_MSG, (Object)client.getCustomHeaders());
    }

    private HoodieWriteCommitHttpCallbackClient makeClient(String customHeaders) {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("path").withCallbackConfig(HoodieWriteCommitCallbackConfig.newBuilder().withCallbackHttpApiKey(FAKE_API_KEY).withCallbackHttpUrl(FAKE_URL).withCustomHeaders(customHeaders).build()).build();
        return new HoodieWriteCommitHttpCallbackClient(config);
    }
}

