/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestBaseHoodieWriteClient
extends HoodieCommonTestHarness {
    TestBaseHoodieWriteClient() {
    }

    @Test
    void startCommitWillRollbackFailedWritesInEagerMode() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        HoodieTimeline inflightRestoreTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().getRestoreTimeline().filterInflightsAndRequested()).thenReturn((Object)inflightRestoreTimeline);
        Mockito.when((Object)inflightRestoreTimeline.countInstants()).thenReturn((Object)0);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant()).thenReturn((Object)Option.empty());
        Mockito.when((Object)mockMetaClient.getTableConfig().getTableVersion()).thenReturn((Object)HoodieTableVersion.EIGHT);
        writeClient.startCommit("commit", mockMetaClient);
        ((BaseHoodieTableServiceClient)Mockito.verify((Object)tableServiceClient)).rollbackFailedWrites(mockMetaClient);
    }

    @Test
    void rollbackDelegatesToTableServiceClient() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        writeClient.rollbackFailedWrites(mockMetaClient);
        ((BaseHoodieTableServiceClient)Mockito.verify((Object)tableServiceClient)).rollbackFailedWrites(mockMetaClient);
    }

    @Test
    void testStartCommit() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.MEMORY).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).withLockWaitTimeInMillis(Long.valueOf(50L)).withNumRetries(2).withRetryWaitTimeInMillis(Long.valueOf(10L)).withClientNumRetries(2).withClientRetryWaitTimeInMillis(Long.valueOf(10L)).build()).build();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        writeClient.startCommitWithTime("001", "commit");
        HoodieTimeline writeTimeline = this.metaClient.getActiveTimeline().getWriteTimeline();
        Assertions.assertTrue((boolean)writeTimeline.lastInstant().isPresent());
        Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)writeTimeline.lastInstant().get()).getAction());
        Assertions.assertEquals((Object)"001", (Object)((HoodieInstant)writeTimeline.lastInstant().get()).requestedTime());
    }

    private static class TestWriteClient
    extends BaseHoodieWriteClient<String, String, String, String> {
        private final HoodieTable<String, String, String, String> table;

        public TestWriteClient(HoodieWriteConfig writeConfig, HoodieTable<String, String, String, String> table, Option<EmbeddedTimelineService> timelineService, BaseHoodieTableServiceClient<String, String, String> tableServiceClient) {
            super((HoodieEngineContext)new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf()), writeConfig, timelineService, null);
            this.table = table;
            this.tableServiceClient = tableServiceClient;
        }

        protected HoodieIndex<?, ?> createIndex(HoodieWriteConfig writeConfig) {
            return new HoodieSimpleIndex(this.config, Option.empty());
        }

        public boolean commit(String instantTime, String writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
            return false;
        }

        protected HoodieTable<String, String, String, String> createTable(HoodieWriteConfig config) {
            FileSystemViewStorageType storageType = config.getViewStorageConfig().getStorageType();
            Assertions.assertTrue((storageType == FileSystemViewStorageType.REMOTE_FIRST || storageType == FileSystemViewStorageType.REMOTE_ONLY ? 1 : 0) != 0);
            return this.table;
        }

        protected HoodieTable<String, String, String, String> createTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
            FileSystemViewStorageType storageType = config.getViewStorageConfig().getStorageType();
            Assertions.assertTrue((storageType == FileSystemViewStorageType.REMOTE_FIRST || storageType == FileSystemViewStorageType.REMOTE_ONLY ? 1 : 0) != 0);
            return this.table;
        }

        public String filterExists(String hoodieRecords) {
            return "";
        }

        public String upsert(String records, String instantTime) {
            return "";
        }

        public String upsertPreppedRecords(String preppedRecords, String instantTime) {
            return "";
        }

        public String insert(String records, String instantTime) {
            return "";
        }

        public String insertPreppedRecords(String preppedRecords, String instantTime) {
            return "";
        }

        public String bulkInsert(String records, String instantTime) {
            return "";
        }

        public String bulkInsert(String records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
            return "";
        }

        public String bulkInsertPreppedRecords(String preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
            return "";
        }

        public String delete(String keys, String instantTime) {
            return "";
        }

        public String deletePrepped(String preppedRecords, String instantTime) {
            return "";
        }

        protected void updateColumnsToIndexWithColStats(HoodieTableMetaClient metaClient, List<String> columnsToIndex) {
        }
    }
}

