/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.TestConflictResolutionStrategyUtil;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSimpleConcurrentFileWritesConflictResolutionStrategy
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testNoConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        TestConflictResolutionStrategyUtil.createInflightCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        TestConflictResolutionStrategyUtil.createInflightCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertTrue((candidateInstants.count() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCommit() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, writer 1 and writer 2 should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithReplaceInflightCommit() throws Exception {
        TestConflictResolutionStrategyUtil.createClusterInflight(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = Option.empty();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createClusterInflight(newInstantTime, this.metaClient);
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, writer 1 and writer 2 should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompactionRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWriteAndCompactionScheduledEarlier() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCompaction(newInstantTime, this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithInterleavingScheduledCluster() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createClusterRequested(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCluster() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createCluster(newInstantTime, WriteOperationType.CLUSTER, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulReplace() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createReplace(newInstantTime, WriteOperationType.INSERT_OVERWRITE, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 1 ? 1 : 0) != 0);
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void tstConcurrentWritesWithPendingInsertOverwriteReplace() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingInsertOverwrite(newInstantTime, WriteOperationType.INSERT_OVERWRITE, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertTrue((candidateInstants.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWritesWithPendingInstants() throws Exception {
        String newInstantTimeC1 = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCluster(newInstantTimeC1, WriteOperationType.CLUSTER, this.metaClient);
        String newCompactionInstantTimeC11 = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCompaction(newCompactionInstantTimeC11, this.metaClient);
        String newCommitInstantTimeC12 = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(newCommitInstantTimeC12, this.metaClient);
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String commitC4 = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createRequestedCommit(commitC4, this.metaClient);
        this.metaClient.reloadActiveTimeline();
        Set pendingInstant = TransactionUtils.getInflightAndRequestedInstants((HoodieTableMetaClient)this.metaClient);
        pendingInstant.remove(currentWriterInstant);
        TestConflictResolutionStrategyUtil.createCluster(newInstantTimeC1, WriteOperationType.CLUSTER, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCompaction(newCompactionInstantTimeC11, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCommit(newCommitInstantTimeC12, this.metaClient);
        TestConflictResolutionStrategyUtil.createCompleteCommit(commitC4, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant, "file-2");
        this.metaClient.reloadActiveTimeline();
        List completedInstantsDuringCurrentWriteOperation = TransactionUtils.getCompletedInstantsDuringCurrentWriteOperation((HoodieTableMetaClient)this.metaClient, (Set)pendingInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)completedInstantsDuringCurrentWriteOperation.size());
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        for (HoodieInstant instant : completedInstantsDuringCurrentWriteOperation) {
            ConcurrentOperation thatCommitOperation = new ConcurrentOperation(instant, this.metaClient);
            Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
            try {
                strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            }
            catch (HoodieWriteConflictException hoodieWriteConflictException) {}
        }
    }
}

