/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.TestConflictResolutionStrategyUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSimpleConcurrentFileWritesConflictResolutionStrategyWithMORTable
extends HoodieCommonTestHarness {
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testConcurrentWritesWithInterleavingInflightCompaction() throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(this.metaClient.createNewInstantTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = this.metaClient.createNewInstantTime();
        TestConflictResolutionStrategyUtil.createPendingCompaction(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", currentWriterInstant));
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant);
        this.metaClient.reloadActiveTimeline();
        SimpleConcurrentFileWritesConflictResolutionStrategy strategy = new SimpleConcurrentFileWritesConflictResolutionStrategy();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation));
    }
}

