/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class TestHoodieBackedTableMetadataWriter {
    TestHoodieBackedTableMetadataWriter() {
    }

    @ParameterizedTest
    @CsvSource(value={"true,true,false,true", "false,true,false,true", "true,false,false,true", "false,false,false,false", "false,false,true,false"})
    void runPendingTableServicesOperations(boolean hasPendingCompaction, boolean hasPendingLogCompaction, boolean requiresRefresh, boolean ranService) {
        HoodieActiveTimeline expectedResult;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieActiveTimeline initialTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseHoodieWriteClient writeClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        if (requiresRefresh) {
            Mockito.when((Object)metaClient.reloadActiveTimeline()).thenReturn((Object)initialTimeline);
        } else {
            Mockito.when((Object)metaClient.getActiveTimeline()).thenReturn((Object)initialTimeline);
        }
        if (hasPendingCompaction) {
            Mockito.when((Object)initialTimeline.filterPendingCompactionTimeline().countInstants()).thenReturn((Object)1);
        }
        if (hasPendingLogCompaction) {
            Mockito.when((Object)initialTimeline.filterPendingLogCompactionTimeline().countInstants()).thenReturn((Object)1);
        }
        if (ranService) {
            HoodieActiveTimeline timelineReloadedAfterServicesRun = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
            Mockito.when((Object)metaClient.reloadActiveTimeline()).thenReturn((Object)timelineReloadedAfterServicesRun);
            expectedResult = timelineReloadedAfterServicesRun;
        } else {
            expectedResult = initialTimeline;
        }
        Assertions.assertSame((Object)expectedResult, (Object)HoodieBackedTableMetadataWriter.runPendingTableServicesOperationsAndRefreshTimeline((HoodieTableMetaClient)metaClient, (BaseHoodieWriteClient)writeClient, (boolean)requiresRefresh));
        ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)(hasPendingCompaction ? 1 : 0)))).runAnyPendingCompactions();
        ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)(hasPendingLogCompaction ? 1 : 0)))).runAnyPendingLogCompactions();
        int expectedTimelineReloads = (requiresRefresh ? 1 : 0) + (ranService ? 1 : 0);
        ((HoodieTableMetaClient)Mockito.verify((Object)metaClient, (VerificationMode)Mockito.times((int)expectedTimelineReloads))).reloadActiveTimeline();
    }

    @Test
    void rollbackFailedWrites_reloadsTimelineOnWritesRolledBack() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        BaseHoodieWriteClient mockWriteClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockWriteClient.rollbackFailedWrites(mockMetaClient)).thenReturn((Object)true);
        try (MockedStatic mockedStatic = Mockito.mockStatic(HoodieTableMetaClient.class);){
            HoodieTableMetaClient reloadedClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
            mockedStatic.when(() -> HoodieTableMetaClient.reload((HoodieTableMetaClient)mockMetaClient)).thenReturn((Object)reloadedClient);
            Assertions.assertSame((Object)reloadedClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)writeConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
        }
    }

    @Test
    void rollbackFailedWrites_avoidsTimelineReload() {
        HoodieWriteConfig eagerWriteConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        BaseHoodieWriteClient mockWriteClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)mockWriteClient.rollbackFailedWrites(mockMetaClient)).thenReturn((Object)false);
        Assertions.assertSame((Object)mockMetaClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)eagerWriteConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
        HoodieWriteConfig lazyWriteConfig = HoodieWriteConfig.newBuilder().withPath("file://tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).build()).build();
        Assertions.assertSame((Object)mockMetaClient, (Object)HoodieBackedTableMetadataWriter.rollbackFailedWrites((HoodieWriteConfig)lazyWriteConfig, (BaseHoodieWriteClient)mockWriteClient, (HoodieTableMetaClient)mockMetaClient));
    }
}

