/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieMetadataWriteUtils {
    @Test
    public void testCreateMetadataWriteConfigForCleaner() {
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(5).build()).build();
        HoodieWriteConfig metadataWriteConfig1 = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig1, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER);
        Assertions.assertEquals((Object)HoodieFailedWritesCleaningPolicy.EAGER, (Object)metadataWriteConfig1.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)metadataWriteConfig1.getCleanerPolicy());
        Assertions.assertEquals((int)20, (int)metadataWriteConfig1.getCleanerCommitsRetained());
        Assertions.assertNotEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, (Object)metadataWriteConfig1.getCleanerPolicy());
        Assertions.assertNotEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS, (Object)metadataWriteConfig1.getCleanerPolicy());
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(20).build()).build();
        HoodieWriteConfig metadataWriteConfig2 = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig2, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER);
        Assertions.assertEquals((Object)HoodieFailedWritesCleaningPolicy.EAGER, (Object)metadataWriteConfig2.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)metadataWriteConfig2.getCleanerPolicy());
        Assertions.assertEquals((int)24, (int)metadataWriteConfig2.getCleanerCommitsRetained());
    }
}

