/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HoodieRollbackTestBase {
    @TempDir
    Path tmpDir;
    protected StoragePath basePath;
    protected HoodieStorage storage;
    @Mock
    protected HoodieTable table;
    @Mock
    protected HoodieTableConfig tableConfig;
    @Mock
    protected HoodieTableMetaClient metaClient;
    @Mock
    protected HoodieActiveTimeline timeline;
    @Mock
    protected HoodieWriteConfig config;

    @BeforeEach
    void setup() throws IOException {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        this.basePath = new StoragePath(this.tmpDir.toString(), UUID.randomUUID().toString());
        this.storage = HoodieTestUtils.getStorage((StoragePath)this.basePath);
        Mockito.when((Object)this.table.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)this.basePath);
        Mockito.when((Object)this.metaClient.getTempFolderPath()).thenReturn((Object)new StoragePath(this.basePath, ".hoodie/.temp").toString());
        Mockito.when((Object)this.metaClient.getMarkerFolderPath((String)ArgumentMatchers.any())).thenReturn((Object)(this.basePath + "/" + ".hoodie/.temp"));
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.metaClient.getActiveTimeline()).thenReturn((Object)this.timeline);
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
        Mockito.when((Object)this.config.getMarkersType()).thenReturn((Object)MarkerType.DIRECT);
        Properties props = new Properties();
        props.put("hoodie.table.name", "test_table");
        props.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        HoodieTableMetaClient.newTableBuilder().fromProperties(props).initTable(this.storage.getConf(), this.metaClient.getBasePath());
    }

    protected void prepareMetaClient(HoodieTableVersion tableVersion) {
        Mockito.when((Object)this.tableConfig.getTableVersion()).thenReturn((Object)tableVersion);
        Mockito.when((Object)this.table.version()).thenReturn((Object)tableVersion);
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            Mockito.when((Object)this.metaClient.getTimelinePath()).thenReturn((Object)new StoragePath(this.basePath, ".hoodie"));
        } else {
            Mockito.when((Object)this.metaClient.getTimelinePath()).thenReturn((Object)new StoragePath(new StoragePath(this.basePath, ".hoodie"), "timeline"));
        }
    }

    protected StoragePath createBaseFileToRollback(String partition, String fileId, String instantTime) throws IOException {
        StoragePath baseFilePath = new StoragePath(new StoragePath(this.basePath, partition), FileCreateUtils.baseFileName((String)instantTime, (String)fileId));
        if (!this.storage.exists(baseFilePath.getParent())) {
            this.storage.createDirectory(baseFilePath.getParent());
            this.storage.create(new StoragePath(baseFilePath.getParent(), ".hoodie_partition_metadata"));
        }
        this.storage.create(baseFilePath).close();
        return baseFilePath;
    }

    protected Map<String, Long> createLogFilesToRollback(String partition, String fileId, String instantTime, IntStream logVersions, long size) {
        return logVersions.boxed().map(version -> {
            String logFileName = FileCreateUtils.logFileName((String)instantTime, (String)fileId, (int)version);
            try {
                this.storage.create(new StoragePath(new StoragePath(this.basePath, partition), logFileName)).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return logFileName;
        }).collect(Collectors.toMap(Function.identity(), e -> size));
    }
}

