/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Map;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.table.upgrade.TwoToThreeUpgradeHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

class TestTwoToThreeUpgradeHandler {
    HoodieWriteConfig config;

    TestTwoToThreeUpgradeHandler() {
    }

    @BeforeEach
    void setUp() {
        this.config = HoodieWriteConfig.newBuilder().forTable("foo").withPath("/foo").withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
    }

    @ParameterizedTest
    @ValueSource(strings={"hoodie.table.keygenerator.class", "hoodie.datasource.write.keygenerator.class"})
    void upgradeHandlerShouldRetrieveKeyGeneratorConfig(String keyGenConfigKey) {
        this.config.setValue(keyGenConfigKey, KeyGenerator.class.getName());
        TwoToThreeUpgradeHandler handler = new TwoToThreeUpgradeHandler();
        Map kv = handler.upgrade(this.config, null, null, null);
        Assertions.assertEquals((Object)KeyGenerator.class.getName(), kv.get(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
    }

    @ParameterizedTest
    @EnumSource(value=EngineType.class)
    void upgradeHandlerWhenKeyGeneratorNotSet(EngineType engineType) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withEngineType(engineType).forTable("foo").withPath("/foo").withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        TwoToThreeUpgradeHandler handler = new TwoToThreeUpgradeHandler();
        if (engineType == EngineType.SPARK) {
            Map kv = handler.upgrade(this.config, null, null, null);
            Assertions.assertEquals((Object)"org.apache.hudi.keygen.SimpleKeyGenerator", kv.get(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
        } else {
            Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> handler.upgrade(writeConfig, null, null, null));
            Assertions.assertTrue((boolean)t.getMessage().startsWith("Missing config:"));
        }
    }
}

