/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;

public class HoodieKeyLocationFetchHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    private final Pair<String, HoodieBaseFile> partitionPathBaseFilePair;
    private final Option<BaseKeyGenerator> keyGeneratorOpt;

    public HoodieKeyLocationFetchHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, HoodieBaseFile> partitionPathBaseFilePair, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, hoodieTable, (Pair<String, String>)Pair.of((Object)partitionPathBaseFilePair.getLeft(), (Object)((HoodieBaseFile)partitionPathBaseFilePair.getRight()).getFileId()));
        this.partitionPathBaseFilePair = partitionPathBaseFilePair;
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    private ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieBaseFile baseFile) {
        FileFormatUtils fileFormatUtils = HoodieIOFactory.getIOFactory((HoodieStorage)this.hoodieTable.getStorage()).getFileFormatUtils(baseFile.getStoragePath());
        return fileFormatUtils.fetchRecordKeysWithPositions(this.hoodieTable.getStorage(), baseFile.getStoragePath(), this.keyGeneratorOpt, Option.of((Object)this.partitionPathBaseFilePair.getKey()));
    }

    public ClosableIterator<Pair<HoodieKey, HoodieRecordLocation>> locations() {
        HoodieBaseFile baseFile = (HoodieBaseFile)this.partitionPathBaseFilePair.getRight();
        String commitTime = baseFile.getCommitTime();
        String fileId = baseFile.getFileId();
        return new CloseableMappingIterator(this.fetchRecordKeysWithPositions(baseFile), entry -> Pair.of((Object)entry.getLeft(), (Object)new HoodieRecordLocation(commitTime, fileId, ((Long)entry.getRight()).longValue())));
    }

    public ClosableIterator<Pair<String, HoodieRecordGlobalLocation>> globalLocations() {
        HoodieBaseFile baseFile = (HoodieBaseFile)this.partitionPathBaseFilePair.getRight();
        return new CloseableMappingIterator(this.fetchRecordKeysWithPositions(baseFile), entry -> Pair.of((Object)((HoodieKey)entry.getLeft()).getRecordKey(), (Object)new HoodieRecordGlobalLocation(((HoodieKey)entry.getLeft()).getPartitionPath(), baseFile.getCommitTime(), baseFile.getFileId(), ((Long)entry.getRight()).longValue())));
    }
}

