/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BaseDeleteHelper;

public class HoodieDeleteHelper<T, R>
extends BaseDeleteHelper<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, R> {
    private HoodieDeleteHelper() {
        super(HoodieData::deduceNumPartitions);
    }

    public static HoodieDeleteHelper newInstance() {
        return DeleteHelperHolder.HOODIE_DELETE_HELPER;
    }

    @Override
    public HoodieData<HoodieKey> deduplicateKeys(HoodieData<HoodieKey> keys, HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table, int parallelism) {
        boolean isIndexingGlobal = table.getIndex().isGlobal();
        if (isIndexingGlobal) {
            return keys.distinctWithKey(HoodieKey::getRecordKey, parallelism);
        }
        return keys.distinct(parallelism);
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute(String instantTime, HoodieData<HoodieKey> keys, HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table, BaseCommitActionExecutor<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, R> deleteExecutor) {
        try {
            HoodieWriteMetadata<Object> result;
            HoodieTimer sourceReadAndIndexTimer = HoodieTimer.start();
            int targetParallelism = this.deduceShuffleParallelism(keys, config.getDeleteShuffleParallelism());
            HoodieData<HoodieKey> dedupedKeys = config.shouldCombineBeforeDelete() ? this.deduplicateKeys(keys, table, targetParallelism) : keys.repartition(targetParallelism);
            HoodieData dedupedRecords = HoodieDeleteHelper.createDeleteRecords(config, dedupedKeys);
            Instant beginTag = Instant.now();
            HoodieData taggedRecords = table.getIndex().tagLocation(dedupedRecords, context, table);
            Duration tagLocationDuration = Duration.between(beginTag, Instant.now());
            HoodieData taggedValidRecords = taggedRecords.filter(HoodieRecord::isCurrentLocationKnown);
            if (!taggedValidRecords.isEmpty()) {
                result = deleteExecutor.execute(taggedValidRecords, (Option<HoodieTimer>)Option.of((Object)sourceReadAndIndexTimer));
                result.setIndexLookupDuration(tagLocationDuration);
            } else {
                deleteExecutor.saveWorkloadProfileMetadataToInflight(new WorkloadProfile((Pair<HashMap<String, WorkloadStat>, WorkloadStat>)Pair.of(new HashMap(), (Object)new WorkloadStat())), instantTime);
                result = new HoodieWriteMetadata();
                result.setWriteStatuses((HoodieData<WriteStatus>)context.emptyHoodieData());
                deleteExecutor.commitOnAutoCommit(result);
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)((Object)e);
            }
            throw new HoodieUpsertException("Failed to delete for commit time " + instantTime, e);
        }
    }

    public static HoodieData createDeleteRecords(HoodieWriteConfig config, HoodieData<HoodieKey> keys) {
        HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
        if (recordType == HoodieRecord.HoodieRecordType.AVRO) {
            return keys.map((SerializableFunction & Serializable)key -> new HoodieAvroRecord(key, (HoodieRecordPayload)new EmptyHoodieRecordPayload()));
        }
        return keys.map((SerializableFunction & Serializable)key -> new HoodieEmptyRecord(key, recordType));
    }

    public static <T> HoodieRecord<T> createDeleteRecord(HoodieWriteConfig config, HoodieKey key) {
        HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
        if (recordType == HoodieRecord.HoodieRecordType.AVRO) {
            return new HoodieAvroRecord(key, (HoodieRecordPayload)new EmptyHoodieRecordPayload());
        }
        return new HoodieEmptyRecord(key, recordType);
    }

    private static class DeleteHelperHolder {
        private static final HoodieDeleteHelper HOODIE_DELETE_HELPER = new HoodieDeleteHelper();

        private DeleteHelperHolder() {
        }
    }
}

