/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;

public class CompositeCompactionStrategy
extends CompactionStrategy {
    private final List<CompactionStrategy> strategies;

    public CompositeCompactionStrategy(List<CompactionStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public Pair<List<HoodieCompactionOperation>, List<String>> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        List finalOperations = operations;
        ArrayList missingPartitions = new ArrayList();
        for (CompactionStrategy strategy : this.strategies) {
            Pair<List<HoodieCompactionOperation>, List<String>> resPair = strategy.orderAndFilter(writeConfig, finalOperations, pendingCompactionPlans);
            finalOperations = (List)resPair.getLeft();
            missingPartitions.addAll((Collection)resPair.getRight());
        }
        return Pair.of(finalOperations, missingPartitions);
    }

    @Override
    public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        List partitionsToProcess = allPartitionPaths;
        ArrayList missingPartitions = new ArrayList();
        for (CompactionStrategy strategy : this.strategies) {
            Pair<List<String>, List<String>> innerRes = strategy.filterPartitionPaths(writeConfig, partitionsToProcess);
            partitionsToProcess = (List)innerRes.getLeft();
            missingPartitions.addAll((Collection)innerRes.getRight());
        }
        return writeConfig.isIncrementalTableServiceEnabled() ? Pair.of(partitionsToProcess, missingPartitions) : Pair.of(partitionsToProcess, Collections.emptyList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CompactionStrategyChain [");
        for (CompactionStrategy strategy : this.strategies) {
            builder.append(strategy.getClass());
            builder.append(" ===> ");
        }
        builder.append("]");
        return builder.toString();
    }
}

