/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.index.IndexingCatchupTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexingCatchupTask
implements IndexingCatchupTask {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexingCatchupTask.class);
    protected final HoodieTableMetadataWriter metadataWriter;
    protected final List<HoodieInstant> instantsToIndex;
    protected final Set<String> metadataCompletedInstants;
    protected final HoodieTableMetaClient metaClient;
    protected final HoodieTableMetaClient metadataMetaClient;
    protected final TransactionManager transactionManager;
    protected final HoodieEngineContext engineContext;
    protected final HoodieTable table;
    protected final HoodieHeartbeatClient heartbeatClient;
    protected String currentCaughtupInstant;

    public AbstractIndexingCatchupTask(HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTableMetaClient metaClient, HoodieTableMetaClient metadataMetaClient, TransactionManager transactionManager, String currentCaughtupInstant, HoodieEngineContext engineContext, HoodieTable table, HoodieHeartbeatClient heartbeatClient) {
        this.metadataWriter = metadataWriter;
        this.instantsToIndex = instantsToIndex;
        this.metadataCompletedInstants = metadataCompletedInstants;
        this.metaClient = metaClient;
        this.metadataMetaClient = metadataMetaClient;
        this.transactionManager = transactionManager;
        this.currentCaughtupInstant = currentCaughtupInstant;
        this.engineContext = engineContext;
        this.table = table;
        this.heartbeatClient = heartbeatClient;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
lbl1:
        // 8 sources

        for (HoodieInstant instant : this.instantsToIndex) {
            if (this.awaitInstantCaughtUp(instant) || !HoodieInstant.State.COMPLETED.equals((Object)instant.getState())) continue;
            instantTime = instant.requestedTime();
            metadataInstant = this.metadataMetaClient.reloadActiveTimeline().filterCompletedInstants().filter((Predicate<HoodieInstant>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$0(java.lang.String org.apache.hudi.common.table.timeline.HoodieInstant ), (Lorg/apache/hudi/common/table/timeline/HoodieInstant;)Z)((String)instantTime)).firstInstant();
            if (metadataInstant.isPresent()) {
                this.currentCaughtupInstant = instantTime;
                continue;
            }
            try {
                this.transactionManager.beginTransaction((Option<HoodieInstant>)Option.of((Object)instant), (Option<HoodieInstant>)Option.empty());
                AbstractIndexingCatchupTask.LOG.info("Updating metadata table for instant: " + instant);
                var5_5 = instant.getAction();
                var6_7 = -1;
                switch (var5_5.hashCode()) {
                    case -1354815177: {
                        if (!var5_5.equals("commit")) break;
                        var6_7 = 0;
                        break;
                    }
                    case -474858769: {
                        if (!var5_5.equals("deltacommit")) break;
                        var6_7 = 1;
                        break;
                    }
                    case 1519387883: {
                        if (!var5_5.equals("replacecommit")) break;
                        var6_7 = 2;
                        break;
                    }
                    case 94746185: {
                        if (!var5_5.equals("clean")) break;
                        var6_7 = 3;
                        break;
                    }
                    case 1097519758: {
                        if (!var5_5.equals("restore")) break;
                        var6_7 = 4;
                        break;
                    }
                    case -259719452: {
                        if (!var5_5.equals("rollback")) break;
                        var6_7 = 5;
                    }
                }
                switch (var6_7) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.updateIndexForWriteAction(instant);
                        ** break;
                    }
                    case 3: {
                        cleanMetadata = CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)this.metaClient, (HoodieInstant)instant);
                        this.metadataWriter.update(cleanMetadata, instant.requestedTime());
                        ** break;
                    }
                    case 4: {
                        restoreMetadata = this.metaClient.getActiveTimeline().readRestoreMetadata(instant);
                        this.metadataWriter.update(restoreMetadata, instant.requestedTime());
                        ** break;
                    }
                    case 5: {
                        rollbackMetadata = this.metaClient.getActiveTimeline().readRollbackMetadata(instant);
                        this.metadataWriter.update(rollbackMetadata, instant.requestedTime());
                        ** break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + instant.getAction());
                    }
                }
            }
            catch (IOException e) {
                throw new HoodieIndexException(String.format("Could not update metadata partition for instant: %s", new Object[]{instant}), (Throwable)e);
            }
            finally {
                this.transactionManager.endTransaction((Option<HoodieInstant>)Option.of((Object)instant));
            }
        }
    }

    @Override
    public abstract void updateIndexForWriteAction(HoodieInstant var1) throws IOException;

    boolean awaitInstantCaughtUp(HoodieInstant instant) {
        if (!this.metadataCompletedInstants.isEmpty() && this.metadataCompletedInstants.contains(instant.requestedTime())) {
            this.currentCaughtupInstant = instant.requestedTime();
            return true;
        }
        if (!instant.isCompleted()) {
            try {
                if (!HoodieHeartbeatClient.heartbeatExists(this.metaClient.getStorage(), this.metaClient.getBasePath().toString(), instant.requestedTime()).booleanValue()) {
                    LOG.info("Ignoring instant " + instant + " as no heartbeat found");
                    return true;
                }
                if (this.table.getConfig().getFailedWritesCleanPolicy().isLazy() && this.heartbeatClient.isHeartbeatExpired(instant.requestedTime())) {
                    LOG.info("Ignoring instant " + instant + " as heartbeat expired");
                    return true;
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to check if heartbeat expired for instant " + instant, e);
            }
            try {
                LOG.warn("instant not completed, reloading timeline " + instant);
                this.reloadTimelineWithWait(instant);
            }
            catch (InterruptedException e) {
                throw new HoodieIndexException(String.format("Thread interrupted while running indexing check for instant: %s", instant), (Throwable)e);
            }
        }
        return false;
    }

    private void reloadTimelineWithWait(HoodieInstant instant) throws InterruptedException {
        Option currentInstant;
        String instantTime = instant.requestedTime();
        do {
            if ((currentInstant = this.metaClient.reloadActiveTimeline().filterCompletedInstants().filter(i -> i.requestedTime().equals(instantTime)).firstInstant()).isPresent() && ((HoodieInstant)currentInstant.get()).isCompleted()) continue;
            Thread.sleep(5000L);
        } while (!currentInstant.isPresent() || !((HoodieInstant)currentInstant.get()).isCompleted());
    }

    private static /* synthetic */ boolean lambda$run$0(String instantTime, HoodieInstant i) {
        return i.requestedTime().equals(instantTime);
    }
}

