/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackStrategy;
import org.apache.hudi.table.action.rollback.MarkerBasedRollbackStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRollbackPlanActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieRollbackPlan>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRollbackPlanActionExecutor.class);
    protected final HoodieInstant instantToRollback;
    private final boolean skipTimelinePublish;
    private final boolean shouldRollbackUsingMarkers;
    protected final Boolean isRestore;
    public static final Integer ROLLBACK_PLAN_VERSION_1;
    public static final Integer LATEST_ROLLBACK_PLAN_VERSION;

    public BaseRollbackPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers, boolean isRestore) {
        super(context, config, table, instantTime);
        this.instantToRollback = instantToRollback;
        this.skipTimelinePublish = skipTimelinePublish;
        this.shouldRollbackUsingMarkers = shouldRollbackUsingMarkers && !instantToRollback.isCompleted();
        this.isRestore = isRestore;
    }

    private RollbackStrategy getRollbackStrategy() {
        if (this.shouldRollbackUsingMarkers) {
            return new MarkerBasedRollbackStrategy(this.table, this.context, this.config, this.instantTime);
        }
        return new ListingBasedRollbackStrategy(this.table, this.context, this.config, this.instantTime, this.isRestore);
    }

    protected Option<HoodieRollbackPlan> requestRollback(String startRollbackTime) {
        HoodieInstant rollbackInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "rollback", startRollbackTime);
        try {
            ArrayList<HoodieRollbackRequest> rollbackRequests = new ArrayList<HoodieRollbackRequest>();
            if (!this.instantToRollback.isRequested()) {
                rollbackRequests.addAll(this.getRollbackStrategy().getRollbackRequests(this.instantToRollback));
            }
            HoodieRollbackPlan rollbackPlan = new HoodieRollbackPlan(new HoodieInstantInfo(this.instantToRollback.requestedTime(), this.instantToRollback.getAction()), rollbackRequests, LATEST_ROLLBACK_PLAN_VERSION);
            if (!this.skipTimelinePublish) {
                if (this.table.getRollbackTimeline().filterInflightsAndRequested().containsInstant(rollbackInstant.requestedTime())) {
                    LOG.warn("Request Rollback found with instant time " + rollbackInstant + ", hence skipping scheduling rollback");
                } else {
                    this.table.getActiveTimeline().saveToRollbackRequested(rollbackInstant, rollbackPlan);
                    this.table.getMetaClient().reloadActiveTimeline();
                    LOG.info("Requesting Rollback with instant time " + rollbackInstant);
                }
            }
            return Option.of((Object)rollbackPlan);
        }
        catch (HoodieIOException e) {
            LOG.error("Got exception when saving rollback requested file", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Option<HoodieRollbackPlan> execute() {
        return this.requestRollback(this.instantTime);
    }

    static {
        LATEST_ROLLBACK_PLAN_VERSION = ROLLBACK_PLAN_VERSION_1 = Integer.valueOf(1);
    }

    static interface RollbackStrategy
    extends Serializable {
        public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant var1);
    }
}

