/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.ttl.strategy;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepByTimeStrategy
extends PartitionTTLStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(KeepByTimeStrategy.class);
    protected final long ttlInMilis;

    public KeepByTimeStrategy(HoodieTable hoodieTable, String instantTime) {
        super(hoodieTable, instantTime);
        this.ttlInMilis = this.writeConfig.getPartitionTTLStrategyDaysRetain() * 1000 * 3600 * 24;
    }

    @Override
    public List<String> getExpiredPartitionPaths() {
        Option lastCompletedInstant = this.hoodieTable.getActiveTimeline().filterCompletedInstants().lastInstant();
        if (!lastCompletedInstant.isPresent() || this.ttlInMilis <= 0L || !this.hoodieTable.getMetaClient().getTableConfig().getPartitionFields().isPresent()) {
            return Collections.emptyList();
        }
        List<String> expiredPartitions = this.getExpiredPartitionsForTimeStrategy(this.getPartitionPathsForTTL());
        int limit = this.writeConfig.getPartitionTTLMaxPartitionsToDelete();
        LOG.info("Total expired partitions count {}, limit {}", (Object)expiredPartitions.size(), (Object)limit);
        return expiredPartitions.stream().limit(limit).collect(Collectors.toList());
    }

    protected List<String> getExpiredPartitionsForTimeStrategy(List<String> partitionsForTTLManagement) {
        HoodieTimer timer = HoodieTimer.start();
        Map<String, Option<String>> lastCommitTimeForPartitions = this.getLastCommitTimeForPartitions(partitionsForTTLManagement);
        LOG.info("Collect last commit time for partitions cost {} ms", (Object)timer.endTimer());
        return lastCommitTimeForPartitions.entrySet().stream().filter(entry -> ((Option)entry.getValue()).isPresent()).filter(entry -> this.isPartitionExpired((String)((Option)entry.getValue()).get())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Map<String, Option<String>> getLastCommitTimeForPartitions(List<String> partitionPaths) {
        int statsParallelism = Math.min(partitionPaths.size(), 200);
        return this.hoodieTable.getContext().map(partitionPaths, (SerializableFunction & Serializable)partitionPath -> {
            Option partitionLastModifiedTime = this.hoodieTable.getHoodieView().getLatestFileSlicesBeforeOrOn(partitionPath, this.instantTime, true).map(FileSlice::getBaseInstantTime).max(Comparator.naturalOrder()).map(Option::ofNullable).orElse(Option.empty());
            return Pair.of((Object)partitionPath, (Object)partitionLastModifiedTime);
        }, statsParallelism).stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    protected boolean isPartitionExpired(String referenceTime) {
        String expiredTime = HoodieInstantTimeGenerator.instantTimePlusMillis((String)referenceTime, (long)this.ttlInMilis);
        return HoodieInstantTimeGenerator.fixInstantTimeCompatibility((String)this.instantTime).compareTo(expiredTime) > 0;
    }
}

