/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.marker.MarkerOperation;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.AppendMarkerHandler;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.timeline.TimelineServiceClientBase;

public class TimelineServerBasedWriteMarkersV1
extends TimelineServerBasedWriteMarkers
implements AppendMarkerHandler {
    public TimelineServerBasedWriteMarkersV1(HoodieTable table, String instantTime) {
        super(table, instantTime);
    }

    @Override
    public Option<StoragePath> createLogMarkerIfNotExists(String partitionPath, String fileName, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        return this.createIfNotExists(partitionPath, fileName, IOType.APPEND, writeConfig, fileId, activeTimeline);
    }

    @Override
    public Set<String> getAppendedLogPaths(HoodieEngineContext context, int parallelism) throws IOException {
        Map<String, String> paramsMap = Collections.singletonMap("markerdirpath", this.markerDirPath.toString());
        try {
            Set markerPaths = (Set)this.executeRequestToTimelineServer(MarkerOperation.APPEND_MARKERS_URL, paramsMap, (TypeReference)new TypeReference<Set<String>>(){}, TimelineServiceClientBase.RequestMethod.GET);
            return markerPaths.stream().map(WriteMarkers::stripMarkerSuffix).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new HoodieRemoteException("Failed to get APPEND log file paths in " + this.markerDirPath.toString(), e);
        }
    }
}

