/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteMarkers
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WriteMarkers.class);
    protected final String basePath;
    protected final transient StoragePath markerDirPath;
    protected final String instantTime;

    public WriteMarkers(String basePath, String markerFolderPath, String instantTime) {
        this.basePath = basePath;
        this.markerDirPath = new StoragePath(markerFolderPath);
        this.instantTime = instantTime;
    }

    public Option<StoragePath> create(String partitionPath, String fileName, IOType type) {
        return this.create(partitionPath, fileName, type, false);
    }

    public Option<StoragePath> create(String partitionPath, String fileName, IOType type, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        if (writeConfig.getWriteConcurrencyMode().isOptimisticConcurrencyControl() && writeConfig.isEarlyConflictDetectionEnable()) {
            HoodieTimeline pendingCompactionTimeline = activeTimeline.filterPendingCompactionTimeline();
            HoodieTimeline pendingReplaceTimeline = activeTimeline.filterPendingReplaceOrClusteringTimeline();
            if (pendingCompactionTimeline.containsInstant(this.instantTime) || pendingReplaceTimeline.containsInstant(this.instantTime)) {
                return this.create(partitionPath, fileName, type, false);
            }
            return this.createWithEarlyConflictDetection(partitionPath, fileName, type, false, writeConfig, fileId, activeTimeline);
        }
        return this.create(partitionPath, fileName, type, false);
    }

    public Option<StoragePath> createIfNotExists(String partitionPath, String fileName, IOType type) {
        return this.create(partitionPath, fileName, type, true);
    }

    public Option<StoragePath> createLogMarkerIfNotExists(String partitionPath, String fileName, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        return this.createIfNotExists(partitionPath, fileName, IOType.CREATE, writeConfig, fileId, activeTimeline);
    }

    public Option<StoragePath> createIfNotExists(String partitionPath, String fileName, IOType type, HoodieWriteConfig writeConfig, String fileId, HoodieActiveTimeline activeTimeline) {
        if (writeConfig.isEarlyConflictDetectionEnable() && writeConfig.getWriteConcurrencyMode().isOptimisticConcurrencyControl()) {
            HoodieTimeline pendingCompactionTimeline = activeTimeline.filterPendingCompactionTimeline();
            HoodieTimeline pendingReplaceTimeline = activeTimeline.filterPendingReplaceOrClusteringTimeline();
            if (pendingCompactionTimeline.containsInstant(this.instantTime) || pendingReplaceTimeline.containsInstant(this.instantTime)) {
                return this.create(partitionPath, fileName, type, true);
            }
            return this.createWithEarlyConflictDetection(partitionPath, fileName, type, false, writeConfig, fileId, activeTimeline);
        }
        return this.create(partitionPath, fileName, type, true);
    }

    public void quietDeleteMarkerDir(HoodieEngineContext context, int parallelism) {
        try {
            context.setJobStatus(this.getClass().getSimpleName(), "Deleting marker directory: " + this.basePath);
            this.deleteMarkerDir(context, parallelism);
        }
        catch (Exception e) {
            LOG.warn("Error deleting marker directory for instant " + this.instantTime, (Throwable)e);
        }
    }

    public static String stripMarkerSuffix(String path) {
        return path.substring(0, path.indexOf(".marker"));
    }

    protected static String getMarkerFileName(String fileName, IOType type) {
        return String.format("%s%s.%s", fileName, ".marker", type.name());
    }

    protected StoragePath getMarkerPath(String partitionPath, String fileName, IOType type) {
        StoragePath path = FSUtils.constructAbsolutePath((StoragePath)this.markerDirPath, (String)partitionPath);
        String markerFileName = WriteMarkers.getMarkerFileName(fileName, type);
        return new StoragePath(path, markerFileName);
    }

    public abstract boolean deleteMarkerDir(HoodieEngineContext var1, int var2);

    public abstract boolean doesMarkerDirExist() throws IOException;

    public abstract Set<String> createdAndMergedDataPaths(HoodieEngineContext var1, int var2) throws IOException;

    public abstract Set<String> allMarkerFilePaths() throws IOException;

    abstract Option<StoragePath> create(String var1, String var2, IOType var3, boolean var4);

    public abstract Option<StoragePath> createWithEarlyConflictDetection(String var1, String var2, IOType var3, boolean var4, HoodieWriteConfig var5, String var6, HoodieActiveTimeline var7);
}

