/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestBloomFilter {
    public static List<Arguments> bloomFilterTypeCodes() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{BloomFilterTypeCode.SIMPLE.name()}), Arguments.of((Object[])new Object[]{BloomFilterTypeCode.DYNAMIC_V0.name()}));
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testAddKey(String typeCode) {
        int[] sizes;
        for (int size : sizes = new int[]{100, 1000, 10000}) {
            int i;
            ArrayList<String> inputs = new ArrayList<String>();
            BloomFilter filter = this.getBloomFilter(typeCode, size, 1.0E-6, size * 10);
            for (i = 0; i < size; ++i) {
                String key = UUID.randomUUID().toString();
                inputs.add(key);
                filter.add(key);
            }
            for (String key : inputs) {
                Assertions.assertTrue((boolean)filter.mightContain(key), (String)("Filter should have returned true for " + key));
            }
            for (i = 0; i < 100; ++i) {
                String randomKey = UUID.randomUUID().toString();
                if (!inputs.contains(randomKey)) continue;
                Assertions.assertTrue((boolean)filter.mightContain(randomKey), (String)("Filter should have returned true for " + randomKey));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testSerialize(String typeCode) {
        int[] sizes;
        for (int size : sizes = new int[]{100, 1000, 10000}) {
            ArrayList<String> inputs = new ArrayList<String>();
            BloomFilter filter = this.getBloomFilter(typeCode, size, 1.0E-6, size * 10);
            for (int i = 0; i < size; ++i) {
                String key = UUID.randomUUID().toString();
                inputs.add(key);
                filter.add(key);
            }
            String serString = filter.serializeToString();
            BloomFilter recreatedBloomFilter = BloomFilterFactory.fromString((String)serString, (String)typeCode);
            for (String key : inputs) {
                Assertions.assertTrue((boolean)recreatedBloomFilter.mightContain(key), (String)("Filter should have returned true for " + key));
            }
        }
    }

    BloomFilter getBloomFilter(String typeCode, int numEntries, double errorRate, int maxEntries) {
        if (typeCode.equalsIgnoreCase(BloomFilterTypeCode.SIMPLE.name())) {
            return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)-1, (String)typeCode);
        }
        return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)maxEntries, (String)typeCode);
    }
}

