/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigProperty
extends HoodieConfig {
    public static ConfigProperty<String> FAKE_STRING_CONFIG = ConfigProperty.key((String)"test.fake.string.config").defaultValue((Object)"1").withAlternatives(new String[]{"test.fake.string.alternative.config"}).withDocumentation("Fake config only for testing");
    public static ConfigProperty<String> FAKE_BOOLEAN_CONFIG = ConfigProperty.key((String)"test.fake.boolean.config").defaultValue((Object)"false").withDocumentation("Fake config only for testing");
    public static ConfigProperty<Integer> FAKE_INTEGER_CONFIG = ConfigProperty.key((String)"test.fake.integer.config").defaultValue((Object)0).withInferFunction(p -> {
        if (p.contains(FAKE_STRING_CONFIG) && p.getString(FAKE_STRING_CONFIG).equals("5")) {
            return Option.of((Object)100);
        }
        return Option.empty();
    }).withDocumentation("Fake config only for testing");

    @Test
    public void testGetTypedValue() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        Assertions.assertNull((Object)hoodieConfig.getInt(FAKE_STRING_CONFIG));
        hoodieConfig.setValue(FAKE_STRING_CONFIG, "5");
        Assertions.assertEquals((int)5, (Integer)hoodieConfig.getInt(FAKE_STRING_CONFIG));
        Assertions.assertNull((Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG));
        hoodieConfig.setValue(FAKE_BOOLEAN_CONFIG, "true");
        Assertions.assertEquals((Object)true, (Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG));
    }

    @Test
    public void testGetOrDefault() {
        Properties props = new Properties();
        props.put("test.unknown.config", "abc");
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        Assertions.assertEquals((Object)"1", (Object)hoodieConfig.getStringOrDefault(FAKE_STRING_CONFIG));
        Assertions.assertEquals((Object)"2", (Object)hoodieConfig.getStringOrDefault(FAKE_STRING_CONFIG, "2"));
    }

    @Test
    public void testAlternatives() {
        Properties props = new Properties();
        props.put("test.fake.string.alternative.config", "1");
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        Assertions.assertTrue((boolean)hoodieConfig.contains(FAKE_STRING_CONFIG));
        Assertions.assertEquals((Object)"1", (Object)hoodieConfig.getString(FAKE_STRING_CONFIG));
    }

    @Test
    public void testInference() {
        HoodieConfig hoodieConfig1 = new HoodieConfig();
        hoodieConfig1.setDefaultValue(FAKE_INTEGER_CONFIG);
        Assertions.assertEquals((int)0, (Integer)hoodieConfig1.getInt(FAKE_INTEGER_CONFIG));
        HoodieConfig hoodieConfig2 = new HoodieConfig();
        hoodieConfig2.setValue(FAKE_STRING_CONFIG, "5");
        hoodieConfig2.setDefaultValue(FAKE_INTEGER_CONFIG);
        Assertions.assertEquals((int)100, (Integer)hoodieConfig2.getInt(FAKE_INTEGER_CONFIG));
    }

    @Test
    public void testSetDefaults() {
        this.setDefaults(((Object)((Object)this)).getClass().getName());
        Assertions.assertEquals((int)3, (int)this.getProps().size());
    }
}

