/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieMapPair;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHoodieMapPair {
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private static final String KEY3 = "key3";
    private static final String KEY4 = "key4";
    private static final String KEY5 = "key5";
    private static final String STRING_VALUE1 = "value1";
    private static final String STRING_VALUE2 = "value2";
    private static final String STRING_VALUE3 = "value3";
    private static final String STRING_VALUE4 = "value4";
    private static final String STRING_VALUE5 = "value5";
    private static final String STRING_VALUE6 = "value6";
    private static final int INTEGER_VALUE1 = 1;
    private static final int INTEGER_VALUE2 = 2;
    private static final int INTEGER_VALUE3 = 3;
    private static final int INTEGER_VALUE4 = 4;
    private static final int INTEGER_VALUE5 = 5;
    private static List<Pair<String, String>> TEST_PAIRS;
    private static HoodiePairData<String, String> TEST_HOODIE_MAP_PAIR;

    @BeforeAll
    public static void setup() {
        TEST_PAIRS = TestHoodieMapPair.constructPairs();
        TEST_HOODIE_MAP_PAIR = TestHoodieMapPair.constructTestMapPairData(TEST_PAIRS);
    }

    @Test
    public void testKeys() {
        this.assertHoodieDataEquals(Arrays.asList(KEY1, KEY2, KEY3, KEY4), TEST_HOODIE_MAP_PAIR.keys());
    }

    @Test
    public void testValues() {
        this.assertHoodieDataEquals(Arrays.asList(STRING_VALUE1, STRING_VALUE2, STRING_VALUE3, STRING_VALUE4, STRING_VALUE5, STRING_VALUE6), TEST_HOODIE_MAP_PAIR.values());
    }

    @Test
    public void testCount() {
        Assertions.assertEquals((long)6L, (long)TEST_HOODIE_MAP_PAIR.count());
    }

    @Test
    public void testCountByKey() {
        HashMap<String, Long> expectedResultMap = new HashMap<String, Long>();
        expectedResultMap.put(KEY1, 2L);
        expectedResultMap.put(KEY2, 2L);
        expectedResultMap.put(KEY3, 1L);
        expectedResultMap.put(KEY4, 1L);
        Assertions.assertEquals(expectedResultMap, (Object)TEST_HOODIE_MAP_PAIR.countByKey());
    }

    @Test
    public void testMap() {
        this.assertHoodieDataEquals(Arrays.asList("key1,value1", "key1,value2", "key2,value3", "key2,value4", "key3,value5", "key4,value6"), TEST_HOODIE_MAP_PAIR.map((SerializableFunction & Serializable)pair -> (String)pair.getKey() + "," + (String)pair.getValue()));
    }

    @Test
    public void testMapToPair() {
        HashMap<String, List<Integer>> expectedResultMap = new HashMap<String, List<Integer>>();
        expectedResultMap.put("key10", Arrays.asList(1, 2));
        expectedResultMap.put("key20", Arrays.asList(3, 4));
        expectedResultMap.put("key30", Arrays.asList(5));
        expectedResultMap.put("key40", Arrays.asList(6));
        Assertions.assertEquals(expectedResultMap, (Object)HoodieMapPair.getMapPair((HoodiePairData)TEST_HOODIE_MAP_PAIR.mapToPair((SerializablePairFunction & Serializable)pair -> {
            String value = (String)pair.getValue();
            return new ImmutablePair((Object)((String)pair.getKey() + "0"), (Object)Integer.parseInt(String.valueOf(value.charAt(value.length() - 1))));
        })));
    }

    @Test
    public void testLeftOuterJoinSingleValuePerKey() {
        HoodiePairData pairData1 = TestHoodieMapPair.constructTestMapPairData(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE1), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE2), ImmutablePair.of((Object)KEY3, (Object)STRING_VALUE3), ImmutablePair.of((Object)KEY4, (Object)STRING_VALUE4)));
        HoodiePairData pairData2 = TestHoodieMapPair.constructTestMapPairData(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)1), ImmutablePair.of((Object)KEY2, (Object)2), ImmutablePair.of((Object)KEY5, (Object)3)));
        HashMap<String, List<Pair>> expectedResultMap = new HashMap<String, List<Pair>>();
        expectedResultMap.put(KEY1, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE1, (Object)Option.of((Object)1))));
        expectedResultMap.put(KEY2, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE2, (Object)Option.of((Object)2))));
        expectedResultMap.put(KEY3, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.empty())));
        expectedResultMap.put(KEY4, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.empty())));
        Assertions.assertEquals(expectedResultMap, (Object)HoodieMapPair.getMapPair((HoodiePairData)pairData1.leftOuterJoin(pairData2)));
    }

    @Test
    public void testLeftOuterJoinMultipleValuesPerKey() {
        HoodiePairData otherPairData = TestHoodieMapPair.constructTestMapPairData(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)1), ImmutablePair.of((Object)KEY2, (Object)2), ImmutablePair.of((Object)KEY2, (Object)3), ImmutablePair.of((Object)KEY3, (Object)4), ImmutablePair.of((Object)KEY5, (Object)5)));
        HashMap<String, List<Pair>> expectedResultMap = new HashMap<String, List<Pair>>();
        expectedResultMap.put(KEY1, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE1, (Object)Option.of((Object)1)), ImmutablePair.of((Object)STRING_VALUE2, (Object)Option.of((Object)1))));
        expectedResultMap.put(KEY2, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.of((Object)2)), ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.of((Object)3)), ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.of((Object)2)), ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.of((Object)3))));
        expectedResultMap.put(KEY3, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE5, (Object)Option.of((Object)4))));
        expectedResultMap.put(KEY4, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE6, (Object)Option.empty())));
        Assertions.assertEquals(expectedResultMap, (Object)HoodieMapPair.getMapPair((HoodiePairData)TEST_HOODIE_MAP_PAIR.leftOuterJoin(otherPairData)));
    }

    private static List<Pair<String, String>> constructPairs() {
        return Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE1), ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE2), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE3), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE4), ImmutablePair.of((Object)KEY3, (Object)STRING_VALUE5), ImmutablePair.of((Object)KEY4, (Object)STRING_VALUE6));
    }

    private static <V> HoodiePairData<String, V> constructTestMapPairData(List<Pair<String, V>> pairs) {
        HashMap<String, List<V>> map = new HashMap<String, List<V>>();
        TestHoodieMapPair.addPairsToMap(map, pairs);
        return HoodieMapPair.of(map);
    }

    private static <V> void addPairsToMap(Map<String, List<V>> map, List<Pair<String, V>> pairs) {
        for (Pair<String, V> pair : pairs) {
            String key = (String)pair.getKey();
            Object value = pair.getValue();
            List list = map.computeIfAbsent(key, k -> new ArrayList());
            list.add(value);
        }
    }

    private <T> void assertHoodieDataEquals(List<T> expectedList, HoodieData<T> hoodieData) {
        this.assertHoodieDataEquals(expectedList, hoodieData, Comparator.naturalOrder());
    }

    private <T> void assertHoodieDataEquals(List<T> expectedList, HoodieData<T> hoodieData, Comparator comparator) {
        Assertions.assertEquals(expectedList, hoodieData.collectAsList().stream().sorted(comparator).collect(Collectors.toList()));
    }
}

