/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFSUtils
extends HoodieCommonTestHarness {
    private final long minRollbackToKeep = 10L;
    private final long minCleanToKeep = 10L;
    private static String TEST_WRITE_TOKEN = "1-0-1";
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testMakeDataFileName() {
        String instantTime = HoodieActiveTimeline.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        Assertions.assertEquals((Object)FSUtils.makeDataFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName), (Object)(fileName + "_" + TEST_WRITE_TOKEN + "_" + instantTime + BASE_FILE_EXTENSION));
    }

    @Test
    public void testMaskFileName() {
        String instantTime = HoodieActiveTimeline.formatDate((Date)new Date());
        int taskPartitionId = 2;
        Assertions.assertEquals((Object)FSUtils.maskWithoutFileId((String)instantTime, (int)taskPartitionId), (Object)("*_" + taskPartitionId + "_" + instantTime + BASE_FILE_EXTENSION));
    }

    @Test
    public void testProcessFiles() throws Exception {
        List<String> folders = Arrays.asList("2016/04/15", "2016/05/16", ".hoodie/.temp/2/2016/04/15", ".hoodie/.temp/2/2016/05/16");
        folders.forEach(f -> {
            try {
                this.metaClient.getFs().mkdirs(new Path(new Path(this.basePath), f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        List<String> files = Stream.of("2016/04/15/1_1-0-1_20190528120000", "2016/05/16/2_1-0-1_20190528120000", ".hoodie/.temp/2/2016/05/16/2_1-0-1_20190528120000", ".hoodie/.temp/2/2016/04/15/1_1-0-1_20190528120000").map(fileName -> fileName + BASE_FILE_EXTENSION).collect(Collectors.toList());
        files.forEach(f -> {
            try {
                this.metaClient.getFs().create(new Path(new Path(this.basePath), f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        ArrayList collected = new ArrayList();
        FSUtils.processFiles((FileSystem)this.metaClient.getFs(), (String)this.basePath, status -> {
            collected.add(status.getPath().toString());
            return true;
        }, (boolean)true);
        Assertions.assertTrue((boolean)collected.stream().noneMatch(s -> s.contains(".hoodie")), (String)("Hoodie MetaFolder MUST be skipped but got :" + collected));
        Assertions.assertEquals((int)2, (int)collected.size());
        ArrayList collected2 = new ArrayList();
        FSUtils.processFiles((FileSystem)this.metaClient.getFs(), (String)this.basePath, status -> {
            collected2.add(status.getPath().toString());
            return true;
        }, (boolean)false);
        Assertions.assertFalse((boolean)collected2.stream().noneMatch(s -> s.contains(".hoodie")), (String)("Hoodie MetaFolder will be present :" + collected2));
        Assertions.assertEquals((int)5, (int)collected2.size(), (String)("Collected=" + collected2));
    }

    @Test
    public void testGetCommitTime() {
        String instantTime = HoodieActiveTimeline.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeDataFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
        fullFileName = FSUtils.makeLogFileName((String)fileName, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)TEST_WRITE_TOKEN);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
    }

    @Test
    public void testGetFileNameWithoutMeta() {
        String instantTime = HoodieActiveTimeline.formatDate((Date)new Date());
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeDataFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName);
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileId((String)fullFileName));
    }

    @Test
    public void testEnvVarVariablesPickedup() {
        this.environmentVariables.set("HOODIE_ENV_fs_DOT_key1", "value1");
        Configuration conf = FSUtils.prepareHadoopConf((Configuration)HoodieTestUtils.getDefaultHadoopConf());
        Assertions.assertEquals((Object)"value1", (Object)conf.get("fs.key1"));
        conf.set("fs.key1", "value11");
        conf.set("fs.key2", "value2");
        Assertions.assertEquals((Object)"value11", (Object)conf.get("fs.key1"));
        Assertions.assertEquals((Object)"value2", (Object)conf.get("fs.key2"));
    }

    @Test
    public void testGetRelativePartitionPath() {
        Path basePath = new Path("/test/apache");
        Path partitionPath = new Path("/test/apache/hudi/sub");
        Assertions.assertEquals((Object)"hudi/sub", (Object)FSUtils.getRelativePartitionPath((Path)basePath, (Path)partitionPath));
    }

    @Test
    public void testGetRelativePartitionPathSameFolder() {
        Path basePath = new Path("/test");
        Path partitionPath = new Path("/test");
        Assertions.assertEquals((Object)"", (Object)FSUtils.getRelativePartitionPath((Path)basePath, (Path)partitionPath));
    }

    @Test
    public void testGetRelativePartitionPathRepeatedFolderNameBasePath() {
        Path basePath = new Path("/test/apache/apache");
        Path partitionPath = new Path("/test/apache/apache/hudi");
        Assertions.assertEquals((Object)"hudi", (Object)FSUtils.getRelativePartitionPath((Path)basePath, (Path)partitionPath));
    }

    @Test
    public void testGetRelativePartitionPathRepeatedFolderNamePartitionPath() {
        Path basePath = new Path("/test/apache");
        Path partitionPath = new Path("/test/apache/apache/hudi");
        Assertions.assertEquals((Object)"apache/hudi", (Object)FSUtils.getRelativePartitionPath((Path)basePath, (Path)partitionPath));
    }

    @Test
    public void testOldLogFileName() {
        String partitionPath = "2019/01/01/";
        String fileName = UUID.randomUUID().toString();
        String oldLogFile = TestFSUtils.makeOldLogFileName(fileName, ".log", "100", 1);
        Path rlPath = new Path(new Path(partitionPath), oldLogFile);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((Path)rlPath));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((Path)rlPath));
        Assertions.assertEquals((Object)"100", (Object)FSUtils.getBaseCommitTimeFromLogPath((Path)rlPath));
        Assertions.assertEquals((int)1, (int)FSUtils.getFileVersionFromLog((Path)rlPath));
        Assertions.assertNull((Object)FSUtils.getTaskPartitionIdFromLogPath((Path)rlPath));
        Assertions.assertNull((Object)FSUtils.getStageIdFromLogPath((Path)rlPath));
        Assertions.assertNull((Object)FSUtils.getTaskAttemptIdFromLogPath((Path)rlPath));
        Assertions.assertNull((Object)FSUtils.getWriteTokenFromLogPath((Path)rlPath));
    }

    @Test
    public void tesLogFileName() {
        String partitionPath = "2019/01/01/";
        String fileName = UUID.randomUUID().toString();
        String logFile = FSUtils.makeLogFileName((String)fileName, (String)".log", (String)"100", (int)2, (String)"1-0-1");
        System.out.println("Log File =" + logFile);
        Path rlPath = new Path(new Path(partitionPath), logFile);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((Path)rlPath));
        Assertions.assertEquals((Object)fileName, (Object)FSUtils.getFileIdFromLogPath((Path)rlPath));
        Assertions.assertEquals((Object)"100", (Object)FSUtils.getBaseCommitTimeFromLogPath((Path)rlPath));
        Assertions.assertEquals((int)2, (int)FSUtils.getFileVersionFromLog((Path)rlPath));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskPartitionIdFromLogPath((Path)rlPath));
        Assertions.assertEquals((int)0, (Integer)FSUtils.getStageIdFromLogPath((Path)rlPath));
        Assertions.assertEquals((int)1, (Integer)FSUtils.getTaskAttemptIdFromLogPath((Path)rlPath));
    }

    @Test
    public void testOldLogFilesComparison() {
        String log1Ver0 = TestFSUtils.makeOldLogFileName("file1", ".log", "1", 0);
        String log1Ver1 = TestFSUtils.makeOldLogFileName("file1", ".log", "1", 1);
        String log1base2 = TestFSUtils.makeOldLogFileName("file1", ".log", "2", 0);
        List logFiles = Stream.of(log1base2, log1Ver1, log1Ver0).map(HoodieLogFile::new).sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
        Assertions.assertEquals((Object)log1Ver0, (Object)((HoodieLogFile)logFiles.get(0)).getFileName());
        Assertions.assertEquals((Object)log1Ver1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName());
        Assertions.assertEquals((Object)log1base2, (Object)((HoodieLogFile)logFiles.get(2)).getFileName());
    }

    @Test
    public void testLogFilesComparison() {
        String log1Ver0W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)0, (String)"0-0-1");
        String log1Ver0W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)0, (String)"1-1-1");
        String log1Ver1W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)1, (String)"0-0-1");
        String log1Ver1W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"1", (int)1, (String)"1-1-1");
        String log1base2W0 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)0, (String)"0-0-1");
        String log1base2W1 = FSUtils.makeLogFileName((String)"file1", (String)".log", (String)"2", (int)0, (String)"1-1-1");
        List logFiles = Stream.of(log1Ver1W1, log1base2W0, log1base2W1, log1Ver1W0, log1Ver0W1, log1Ver0W0).map(HoodieLogFile::new).sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
        Assertions.assertEquals((Object)log1Ver0W0, (Object)((HoodieLogFile)logFiles.get(0)).getFileName());
        Assertions.assertEquals((Object)log1Ver0W1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName());
        Assertions.assertEquals((Object)log1Ver1W0, (Object)((HoodieLogFile)logFiles.get(2)).getFileName());
        Assertions.assertEquals((Object)log1Ver1W1, (Object)((HoodieLogFile)logFiles.get(3)).getFileName());
        Assertions.assertEquals((Object)log1base2W0, (Object)((HoodieLogFile)logFiles.get(4)).getFileName());
        Assertions.assertEquals((Object)log1base2W1, (Object)((HoodieLogFile)logFiles.get(5)).getFileName());
    }

    public static String makeOldLogFileName(String fileId, String logFileExtension, String baseCommitTime, int version) {
        return "." + String.format("%s_%s%s.%d", fileId, baseCommitTime, logFileExtension, version);
    }

    @Test
    public void testFileNameRelatedFunctions() throws Exception {
        String instantTime = "20160501010101";
        String partitionStr = "2016/05/01";
        int taskPartitionId = 456;
        String writeToken = "456";
        String fileId = "Id123";
        int version = 1;
        String LOG_STR = "log";
        String LOG_EXTENTION = ".log";
        String dataFileName = FSUtils.makeDataFileName((String)instantTime, (String)writeToken, (String)fileId);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)dataFileName));
        Assertions.assertEquals((Object)fileId, (Object)FSUtils.getFileId((String)dataFileName));
        String logFileName = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)version, (String)writeToken);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((Path)new Path(logFileName)));
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getBaseCommitTimeFromLogPath((Path)new Path(logFileName)));
        Assertions.assertEquals((Object)fileId, (Object)FSUtils.getFileIdFromLogPath((Path)new Path(logFileName)));
        Assertions.assertEquals((int)version, (int)FSUtils.getFileVersionFromLog((Path)new Path(logFileName)));
        Assertions.assertEquals((Object)"log", (Object)FSUtils.getFileExtensionFromLog((Path)new Path(logFileName)));
        java.nio.file.Path partitionPath = Paths.get(this.basePath, partitionStr);
        Files.createDirectories(partitionPath, new FileAttribute[0]);
        String log1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)1, (String)writeToken);
        Files.createFile(partitionPath.resolve(log1), new FileAttribute[0]);
        String log2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)2, (String)writeToken);
        Files.createFile(partitionPath.resolve(log2), new FileAttribute[0]);
        String log3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)3, (String)writeToken);
        Files.createFile(partitionPath.resolve(log3), new FileAttribute[0]);
        Assertions.assertEquals((int)3, (int)((Integer)((Pair)FSUtils.getLatestLogVersion((FileSystem)FSUtils.getFs((String)this.basePath, (Configuration)new Configuration()), (Path)new Path(partitionPath.toString()), (String)fileId, (String)".log", (String)instantTime).get()).getLeft()));
        Assertions.assertEquals((int)4, (int)FSUtils.computeNextLogVersion((FileSystem)FSUtils.getFs((String)this.basePath, (Configuration)new Configuration()), (Path)new Path(partitionPath.toString()), (String)fileId, (String)".log", (String)instantTime));
    }

    private void prepareTestDirectory(FileSystem fileSystem, String rootDir) throws IOException {
        Path dirPath = new Path(rootDir);
        String subDir1 = rootDir + "/subdir1";
        String file1 = subDir1 + "/file1.txt";
        String subDir2 = rootDir + "/subdir2";
        String file2 = subDir2 + "/file2.txt";
        String file3 = rootDir + "/file3.txt";
        String[] dirs = new String[]{rootDir, subDir1, subDir2};
        String[] files = new String[]{file1, file2, file3};
        this.cleanUpTestDirectory(fileSystem, rootDir);
        for (String dir : dirs) {
            fileSystem.mkdirs(new Path(dir));
        }
        for (String filename : files) {
            fileSystem.create(new Path(filename));
        }
    }

    private void cleanUpTestDirectory(FileSystem fileSystem, String rootDir) throws IOException {
        fileSystem.delete(new Path(rootDir), true);
    }

    @Test
    public void testDeleteExistingDir() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.prepareTestDirectory((FileSystem)fileSystem, rootDir);
        Path rootDirPath = new Path(rootDir);
        Assertions.assertTrue((boolean)fileSystem.exists(rootDirPath));
        Assertions.assertTrue((boolean)FSUtils.deleteDir((HoodieEngineContext)new HoodieLocalEngineContext(this.metaClient.getHadoopConf()), (FileSystem)fileSystem, (Path)rootDirPath, (int)2));
        Assertions.assertFalse((boolean)fileSystem.exists(rootDirPath));
    }

    @Test
    public void testDeleteNonExistingDir() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.cleanUpTestDirectory((FileSystem)fileSystem, rootDir);
        Assertions.assertFalse((boolean)FSUtils.deleteDir((HoodieEngineContext)new HoodieLocalEngineContext(this.metaClient.getHadoopConf()), (FileSystem)fileSystem, (Path)new Path(rootDir), (int)2));
    }

    @Test
    public void testDeleteSubDirectoryRecursively() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        String subPathStr = rootDir + "/subdir1";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.prepareTestDirectory((FileSystem)fileSystem, rootDir);
        Assertions.assertTrue((boolean)FSUtils.deleteSubPath((String)subPathStr, (SerializableConfiguration)new SerializableConfiguration(fileSystem.getConf()), (boolean)true));
    }

    @Test
    public void testDeleteSubDirectoryNonRecursively() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        String subPathStr = rootDir + "/subdir1";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.prepareTestDirectory((FileSystem)fileSystem, rootDir);
        Assertions.assertThrows(HoodieIOException.class, () -> TestFSUtils.lambda$testDeleteSubDirectoryNonRecursively$7(subPathStr, (FileSystem)fileSystem));
    }

    @Test
    public void testDeleteSubPathAsFile() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        String subPathStr = rootDir + "/file3.txt";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.prepareTestDirectory((FileSystem)fileSystem, rootDir);
        Assertions.assertTrue((boolean)FSUtils.deleteSubPath((String)subPathStr, (SerializableConfiguration)new SerializableConfiguration(fileSystem.getConf()), (boolean)false));
    }

    @Test
    public void testDeleteNonExistingSubDirectory() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        String subPathStr = rootDir + "/subdir10";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.cleanUpTestDirectory((FileSystem)fileSystem, rootDir);
        Assertions.assertFalse((boolean)FSUtils.deleteSubPath((String)subPathStr, (SerializableConfiguration)new SerializableConfiguration(fileSystem.getConf()), (boolean)true));
    }

    @Test
    public void testParallelizeSubPathProcessWithExistingDir() throws IOException {
        String rootDir = this.basePath + "/.hoodie/.temp";
        HoodieWrapperFileSystem fileSystem = this.metaClient.getFs();
        this.prepareTestDirectory((FileSystem)fileSystem, rootDir);
        Map result = FSUtils.parallelizeSubPathProcess((HoodieEngineContext)new HoodieLocalEngineContext(fileSystem.getConf()), (FileSystem)fileSystem, (Path)new Path(rootDir), (int)2, fileStatus -> !fileStatus.getPath().getName().contains("1"), (FSUtils.SerializableFunction & Serializable)pairOfSubPathAndConf -> {
            Path subPath = new Path((String)pairOfSubPathAndConf.getKey());
            List<Object> listFiles = new ArrayList();
            try {
                FileSystem fs = subPath.getFileSystem(((SerializableConfiguration)pairOfSubPathAndConf.getValue()).get());
                FileStatus[] fileStatuses = fs.listStatus(subPath);
                listFiles = Arrays.stream(fileStatuses).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return listFiles;
        });
        Assertions.assertEquals((int)2, (int)result.size());
        for (String subPath : result.keySet()) {
            if (subPath.contains("subdir2")) {
                Assertions.assertEquals(Collections.singletonList("file2.txt"), result.get(subPath));
                continue;
            }
            if (!subPath.contains("file3")) continue;
            Assertions.assertEquals(Collections.singletonList("file3.txt"), result.get(subPath));
        }
    }

    private static /* synthetic */ void lambda$testDeleteSubDirectoryNonRecursively$7(String subPathStr, FileSystem fileSystem) throws Throwable {
        FSUtils.deleteSubPath((String)subPathStr, (SerializableConfiguration)new SerializableConfiguration(fileSystem.getConf()), (boolean)false);
    }
}

