/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.InputStream;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieCommitMetadata {
    @Test
    public void testPerfStatPresenceInHoodieMetadata() throws Exception {
        List<HoodieWriteStat> fakeHoodieWriteStats = HoodieTestUtils.generateFakeHoodieWriteStat(100);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        fakeHoodieWriteStats.forEach(stat -> commitMetadata.addWriteStat(stat.getPartitionPath(), stat));
        Assertions.assertTrue((commitMetadata.getTotalCreateTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalUpsertTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalScanTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalLogFilesCompacted() > 0L ? 1 : 0) != 0);
        String serializedCommitMetadata = commitMetadata.toJsonString();
        HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertEquals((long)0L, (long)metadata.getTotalScanTime());
        Assertions.assertTrue((metadata.getTotalLogFilesCompacted() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompatibilityWithoutOperationType() throws Exception {
        String serializedCommitMetadata = FileIOUtils.readAsUTFString((InputStream)TestHoodieCommitMetadata.class.getResourceAsStream("/old-version.commit"));
        HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertSame((Object)metadata.getOperationType(), (Object)WriteOperationType.UNKNOWN);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        Assertions.assertSame((Object)commitMetadata.getOperationType(), (Object)WriteOperationType.INSERT);
        serializedCommitMetadata = commitMetadata.toJsonString();
        metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertSame((Object)metadata.getOperationType(), (Object)WriteOperationType.INSERT);
    }
}

