/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieFileGroup {
    @Test
    public void testCommittedFileSlices() {
        Stream<String> completed = Arrays.asList("001").stream();
        Stream<String> inflight = Arrays.asList("002").stream();
        MockHoodieTimeline activeTimeline = new MockHoodieTimeline(completed, inflight);
        HoodieFileGroup fileGroup = new HoodieFileGroup("", "data", activeTimeline.getCommitsTimeline().filterCompletedInstants());
        for (int i = 0; i < 3; ++i) {
            HoodieBaseFile baseFile = new HoodieBaseFile("data_1_00" + i);
            fileGroup.addBaseFile(baseFile);
        }
        Assertions.assertEquals((long)2L, (long)fileGroup.getAllFileSlices().count());
        Assertions.assertTrue((!fileGroup.getAllFileSlices().anyMatch(s -> s.getBaseInstantTime().equals("002")) ? 1 : 0) != 0);
        Assertions.assertEquals((long)3L, (long)fileGroup.getAllFileSlicesIncludingInflight().count());
        Assertions.assertTrue((boolean)((FileSlice)fileGroup.getLatestFileSlice().get()).getBaseInstantTime().equals("001"));
        Assertions.assertTrue((boolean)((FileSlice)new HoodieFileGroup(fileGroup).getLatestFileSlice().get()).getBaseInstantTime().equals("001"));
    }
}

