/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMySqlDebeziumAvroPayload {
    private static final String KEY_FIELD_NAME = "Key";
    private Schema avroSchema;

    @BeforeEach
    void setUp() {
        this.avroSchema = Schema.createRecord(Arrays.asList(new Schema.Field(KEY_FIELD_NAME, Schema.create((Schema.Type)Schema.Type.INT), "", (Object)0), new Schema.Field("_change_operation_type", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("_event_seq", Schema.create((Schema.Type)Schema.Type.STRING), "", null)));
    }

    @Test
    public void testInsert() throws IOException {
        GenericRecord insertRecord = this.createRecord(0, Operation.INSERT, "00001.111");
        MySqlDebeziumAvroPayload payload = new MySqlDebeziumAvroPayload(insertRecord, (Comparable)((Object)"00001.111"));
        this.validateRecord((Option<IndexedRecord>)payload.getInsertValue(this.avroSchema), 0, Operation.INSERT, "00001.111");
    }

    @Test
    public void testPreCombine() {
        GenericRecord insertRecord = this.createRecord(0, Operation.INSERT, "00002.111");
        MySqlDebeziumAvroPayload insertPayload = new MySqlDebeziumAvroPayload(insertRecord, (Comparable)((Object)"00002.111"));
        GenericRecord updateRecord = this.createRecord(0, Operation.UPDATE, "00001.111");
        MySqlDebeziumAvroPayload updatePayload = new MySqlDebeziumAvroPayload(updateRecord, (Comparable)((Object)"00001.111"));
        GenericRecord deleteRecord = this.createRecord(0, Operation.DELETE, "00002.11");
        MySqlDebeziumAvroPayload deletePayload = new MySqlDebeziumAvroPayload(deleteRecord, (Comparable)((Object)"00002.11"));
        Assertions.assertEquals((Object)insertPayload, (Object)insertPayload.preCombine((OverwriteWithLatestAvroPayload)updatePayload));
        Assertions.assertEquals((Object)deletePayload, (Object)deletePayload.preCombine((OverwriteWithLatestAvroPayload)updatePayload));
        Assertions.assertEquals((Object)insertPayload, (Object)deletePayload.preCombine((OverwriteWithLatestAvroPayload)insertPayload));
    }

    @Test
    public void testMergeWithUpdate() throws IOException {
        GenericRecord updateRecord = this.createRecord(1, Operation.UPDATE, "00002.11");
        MySqlDebeziumAvroPayload payload = new MySqlDebeziumAvroPayload(updateRecord, (Comparable)((Object)"00002.11"));
        GenericRecord existingRecord = this.createRecord(1, Operation.INSERT, "00001.111");
        Option mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 1, Operation.UPDATE, "00002.11");
        GenericRecord lateRecord = this.createRecord(1, Operation.UPDATE, "00000.222");
        payload = new MySqlDebeziumAvroPayload(lateRecord, (Comparable)((Object)"00000.222"));
        mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 1, Operation.INSERT, "00001.111");
    }

    @Test
    public void testMergeWithDelete() throws IOException {
        GenericRecord deleteRecord = this.createRecord(2, Operation.DELETE, "00002.11");
        MySqlDebeziumAvroPayload payload = new MySqlDebeziumAvroPayload(deleteRecord, (Comparable)((Object)"00002.11"));
        GenericRecord existingRecord = this.createRecord(2, Operation.UPDATE, "00001.111");
        Option mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        Assertions.assertFalse((boolean)mergedRecord.isPresent());
        GenericRecord lateRecord = this.createRecord(2, Operation.DELETE, "00000.222");
        payload = new MySqlDebeziumAvroPayload(lateRecord, (Comparable)((Object)"00000.222"));
        mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 2, Operation.UPDATE, "00001.111");
    }

    private GenericRecord createRecord(int primaryKeyValue, Operation op, String seqValue) {
        GenericData.Record record = new GenericData.Record(this.avroSchema);
        record.put(KEY_FIELD_NAME, (Object)primaryKeyValue);
        record.put("_change_operation_type", (Object)op.op);
        record.put("_event_seq", (Object)seqValue);
        return record;
    }

    private void validateRecord(Option<IndexedRecord> iRecord, int primaryKeyValue, Operation op, String seqValue) {
        IndexedRecord record = (IndexedRecord)iRecord.get();
        Assertions.assertEquals((int)primaryKeyValue, (int)((Integer)record.get(0)));
        Assertions.assertEquals((Object)op.op, (Object)record.get(1).toString());
        Assertions.assertEquals((Object)seqValue, (Object)record.get(2).toString());
    }

    private static enum Operation {
        INSERT("c"),
        UPDATE("u"),
        DELETE("d");

        public final String op;

        private Operation(String op) {
            this.op = op;
        }
    }
}

