/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.properties;

import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypedProperties {
    @Test
    public void testGetString() {
        Properties properties = new Properties();
        properties.put("key1", "value1");
        TypedProperties typedProperties = new TypedProperties(properties);
        Assertions.assertEquals((Object)"value1", (Object)typedProperties.getString("key1"));
        Assertions.assertEquals((Object)"value1", (Object)typedProperties.getString("key1", "default"));
        Assertions.assertEquals((Object)"default", (Object)typedProperties.getString("key2", "default"));
    }

    @Test
    public void testGetInteger() {
        Properties properties = new Properties();
        properties.put("key1", "123");
        TypedProperties typedProperties = new TypedProperties(properties);
        Assertions.assertEquals((int)123, (int)typedProperties.getInteger("key1"));
        Assertions.assertEquals((int)123, (int)typedProperties.getInteger("key1", 456));
        Assertions.assertEquals((int)456, (int)typedProperties.getInteger("key2", 456));
    }

    @Test
    public void testGetDouble() {
        Properties properties = new Properties();
        properties.put("key1", "123.4");
        TypedProperties typedProperties = new TypedProperties(properties);
        Assertions.assertEquals((double)123.4, (double)typedProperties.getDouble("key1"));
        Assertions.assertEquals((double)123.4, (double)typedProperties.getDouble("key1", 0.001));
        Assertions.assertEquals((double)0.001, (double)typedProperties.getDouble("key2", 0.001));
    }

    @Test
    public void testGetLong() {
        Properties properties = new Properties();
        properties.put("key1", "1354354354");
        TypedProperties typedProperties = new TypedProperties(properties);
        Assertions.assertEquals((long)1354354354L, (long)typedProperties.getLong("key1"));
        Assertions.assertEquals((long)1354354354L, (long)typedProperties.getLong("key1", 8578494434L));
        Assertions.assertEquals((long)8578494434L, (long)typedProperties.getLong("key2", 8578494434L));
    }

    @Test
    public void testGetBoolean() {
        Properties properties = new Properties();
        properties.put("key1", "true");
        TypedProperties typedProperties = new TypedProperties(properties);
        Assertions.assertEquals((Object)true, (Object)typedProperties.getBoolean("key1"));
        Assertions.assertEquals((Object)true, (Object)typedProperties.getBoolean("key1", false));
        Assertions.assertEquals((Object)false, (Object)typedProperties.getBoolean("key2", false));
    }
}

