/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieTableConfig
extends HoodieCommonTestHarness {
    private FileSystem fs;
    private Path metaPath;
    private Path cfgPath;
    private Path backupCfgPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.fs = new Path(this.basePath).getFileSystem(new Configuration());
        this.metaPath = new Path(this.basePath, ".hoodie");
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.NAME.key(), "test-table");
        HoodieTableConfig.create((FileSystem)this.fs, (Path)this.metaPath, (Properties)props);
        this.cfgPath = new Path(this.metaPath, "hoodie.properties");
        this.backupCfgPath = new Path(this.metaPath, "hoodie.properties.backup");
    }

    @Test
    public void testCreate() throws IOException {
        Assertions.assertTrue((boolean)this.fs.exists(new Path(this.metaPath, "hoodie.properties")));
        HoodieTableConfig config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        Assertions.assertEquals((int)4, (int)config.getProps().size());
    }

    @Test
    public void testUpdate() throws IOException {
        Properties updatedProps = new Properties();
        updatedProps.setProperty(HoodieTableConfig.NAME.key(), "test-table2");
        updatedProps.setProperty(HoodieTableConfig.PRECOMBINE_FIELD.key(), "new_field");
        HoodieTableConfig.update((FileSystem)this.fs, (Path)this.metaPath, (Properties)updatedProps);
        Assertions.assertTrue((boolean)this.fs.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.fs.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        Assertions.assertEquals((int)5, (int)config.getProps().size());
        Assertions.assertEquals((Object)"test-table2", (Object)config.getTableName());
        Assertions.assertEquals((Object)"new_field", (Object)config.getPreCombineField());
    }

    @Test
    public void testDelete() throws IOException {
        Set deletedProps = CollectionUtils.createSet((Object[])new String[]{HoodieTableConfig.ARCHIVELOG_FOLDER.key(), "hoodie.invalid.config"});
        HoodieTableConfig.delete((FileSystem)this.fs, (Path)this.metaPath, (Set)deletedProps);
        Assertions.assertTrue((boolean)this.fs.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.fs.exists(this.backupCfgPath));
        HoodieTableConfig config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        Assertions.assertEquals((int)3, (int)config.getProps().size());
        Assertions.assertNull((Object)config.getProps().getProperty("hoodie.invalid.config"));
        Assertions.assertFalse((boolean)config.getProps().contains((Object)HoodieTableConfig.ARCHIVELOG_FOLDER.key()));
    }

    @Test
    public void testReadsWhenPropsFileDoesNotExist() throws IOException {
        this.fs.delete(this.cfgPath, false);
        Assertions.assertThrows(HoodieIOException.class, () -> new HoodieTableConfig(this.fs, this.metaPath.toString(), null));
    }

    @Test
    public void testReadsWithUpdateFailures() throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        this.fs.delete(this.cfgPath, false);
        try (FSDataOutputStream out = this.fs.create(this.backupCfgPath);){
            config.getProps().store((OutputStream)out, "");
        }
        Assertions.assertFalse((boolean)this.fs.exists(this.cfgPath));
        Assertions.assertTrue((boolean)this.fs.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        Assertions.assertEquals((int)4, (int)config.getProps().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUpdateRecovery(boolean shouldPropsFileExist) throws IOException {
        HoodieTableConfig config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        if (!shouldPropsFileExist) {
            this.fs.delete(this.cfgPath, false);
        }
        try (FSDataOutputStream out = this.fs.create(this.backupCfgPath);){
            config.getProps().store((OutputStream)out, "");
        }
        HoodieTableConfig.recoverIfNeeded((FileSystem)this.fs, (Path)this.cfgPath, (Path)this.backupCfgPath);
        Assertions.assertTrue((boolean)this.fs.exists(this.cfgPath));
        Assertions.assertFalse((boolean)this.fs.exists(this.backupCfgPath));
        config = new HoodieTableConfig(this.fs, this.metaPath.toString(), null);
        Assertions.assertEquals((int)4, (int)config.getProps().size());
    }
}

