/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieFSPermission;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieTableFileSystemView
extends HoodieCommonTestHarness {
    private static final Logger LOG = LogManager.getLogger(TestHoodieTableFileSystemView.class);
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with bootstrap enable={0}";
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    private static final String BOOTSTRAP_SOURCE_PATH = "/usr/warehouse/hive/data/tables/src1/";
    protected SyncableFileSystemView fsView;
    protected TableFileSystemView.BaseFileOnlyView roView;
    protected TableFileSystemView.SliceView rtView;

    public static Stream<Arguments> configParams() {
        return Arrays.stream(new Boolean[][]{{true}, {false}}).map(Arguments::of);
    }

    @BeforeEach
    public void setup() throws IOException {
        this.metaClient = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType(), BOOTSTRAP_SOURCE_PATH, false);
        this.basePath = this.metaClient.getBasePath();
        this.refreshFsView();
    }

    @Override
    protected void refreshFsView() throws IOException {
        super.refreshFsView();
        this.closeFsView();
        this.fsView = this.getFileSystemView(this.metaClient.getActiveTimeline().filterCompletedAndCompactionInstants());
        this.roView = this.fsView;
        this.rtView = this.fsView;
    }

    private void closeFsView() {
        if (null != this.fsView) {
            this.fsView.close();
            this.fsView = null;
        }
    }

    @Test
    public void testViewForFileSlicesWithNoBaseFile() throws Exception {
        this.testViewForFileSlicesWithNoBaseFile(1, 0, "2016/05/01");
    }

    @Test
    public void testViewForFileSlicesWithNoBaseFileNonPartitioned() throws Exception {
        this.testViewForFileSlicesWithNoBaseFile(1, 0, "");
    }

    @Test
    public void testCloseHoodieTableFileSystemView() throws Exception {
        String instantTime1 = "1";
        String instantTime2 = "2";
        String clusteringInstantTime3 = "3";
        String clusteringInstantTime4 = "4";
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("fake_file_id");
        partitionToReplaceFileIds.put("fake_partition_path", replacedFileIds);
        HoodieInstant instant1 = new HoodieInstant(true, "commit", instantTime1);
        HoodieInstant instant2 = new HoodieInstant(true, "commit", instantTime2);
        HoodieInstant clusteringInstant3 = new HoodieInstant(true, "replacecommit", clusteringInstantTime3);
        HoodieInstant clusteringInstant4 = new HoodieInstant(true, "replacecommit", clusteringInstantTime4);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)"", (String)"replacecommit");
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant2, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, clusteringInstant3, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, clusteringInstant4, (Option<byte[]>)Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        this.refreshFsView();
        boolean deleteReplaceCommit = new File(this.basePath + "/.hoodie/" + clusteringInstantTime3 + ".replacecommit").delete();
        boolean deleteReplaceCommitRequested = new File(this.basePath + "/.hoodie/" + clusteringInstantTime3 + ".replacecommit.requested").delete();
        boolean deleteReplaceCommitInflight = new File(this.basePath + "/.hoodie/" + clusteringInstantTime3 + ".replacecommit.inflight").delete();
        Assertions.assertTrue((deleteReplaceCommit && deleteReplaceCommitInflight && deleteReplaceCommitRequested ? 1 : 0) != 0);
        Assertions.assertDoesNotThrow(() -> this.fsView.close());
    }

    protected void testViewForFileSlicesWithNoBaseFile(int expNumTotalFileSlices, int expNumTotalDataFiles, String partitionPath) throws Exception {
        Paths.get(this.basePath, partitionPath).toFile().mkdirs();
        String fileId = UUID.randomUUID().toString();
        String instantTime1 = "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)1, (String)TEST_WRITE_TOKEN);
        Paths.get(this.basePath, partitionPath, fileName1).toFile().createNewFile();
        Paths.get(this.basePath, partitionPath, fileName2).toFile().createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", instantTime1);
        HoodieInstant deltaInstant2 = new HoodieInstant(true, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant3 = new HoodieInstant(true, "deltacommit", deltaInstantTime2);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant2, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant3, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        List dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertTrue((boolean)dataFiles.isEmpty(), (String)"No data file expected");
        List fileSliceList = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        FileSlice fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime2).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestUnCompactedFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size());
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"File-Id must be set correctly");
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Data file for base instant must be present");
        Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant for file-group set correctly");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Correct number of log-files shows up in file-slice");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((long)expNumTotalFileSlices, (long)this.rtView.getAllFileSlices(partitionPath).count(), (String)"Total number of file-slices in view matches expected");
        Assertions.assertEquals((long)expNumTotalDataFiles, (long)this.roView.getAllBaseFiles(partitionPath).count(), (String)"Total number of data-files in view matches expected");
        Assertions.assertEquals((long)1L, (long)this.fsView.getAllFileGroups(partitionPath).count(), (String)"Total number of file-groups in view matches expected");
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}")
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithNoBaseFileAndRequestedCompaction(boolean testBootstrap) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(true, false, 2, 1, true, testBootstrap);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}")
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithBaseFileAndRequestedCompaction(boolean testBootstrap) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(false, false, 2, 2, true, testBootstrap);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}")
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithNoBaseFileAndInflightCompaction(boolean testBootstrap) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(true, true, 2, 1, true, testBootstrap);
    }

    @ParameterizedTest(name="[{index}] Test with bootstrap enable={0}")
    @MethodSource(value={"configParams"})
    public void testViewForFileSlicesWithBaseFileAndInflightCompaction(boolean testBootstrap) throws Exception {
        this.testViewForFileSlicesWithAsyncCompaction(false, true, 2, 2, true, testBootstrap);
    }

    private Stream<FileSlice> getAllRawFileSlices(String partitionPath) {
        return this.fsView.getAllFileGroups(partitionPath).map(HoodieFileGroup::getAllFileSlicesIncludingInflight).flatMap(sliceList -> sliceList);
    }

    public Stream<FileSlice> getLatestRawFileSlices(String partitionPath) {
        return this.fsView.getAllFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlicesIncludingInflight).filter(Option::isPresent).map(Option::get);
    }

    private void checkExternalFile(HoodieFileStatus srcFileStatus, Option<BaseFile> bootstrapBaseFile, boolean testBootstrap) {
        if (testBootstrap) {
            Assertions.assertTrue((boolean)bootstrapBaseFile.isPresent());
            Assertions.assertEquals((Object)FileStatusUtils.toPath((HoodiePath)srcFileStatus.getPath()), (Object)new Path(((BaseFile)bootstrapBaseFile.get()).getPath()));
            Assertions.assertEquals((Object)srcFileStatus.getPath(), (Object)FileStatusUtils.fromPath((Path)new Path(((BaseFile)bootstrapBaseFile.get()).getPath())));
            Assertions.assertEquals((Object)srcFileStatus.getOwner(), (Object)((BaseFile)bootstrapBaseFile.get()).getFileStatus().getOwner());
            Assertions.assertEquals((Object)srcFileStatus.getGroup(), (Object)((BaseFile)bootstrapBaseFile.get()).getFileStatus().getGroup());
            Assertions.assertEquals((Long)srcFileStatus.getAccessTime(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getFileStatus().getAccessTime()));
            Assertions.assertEquals((Long)srcFileStatus.getModificationTime(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getFileStatus().getModificationTime()));
            Assertions.assertEquals((Long)srcFileStatus.getBlockSize(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getFileStatus().getBlockSize()));
            Assertions.assertEquals((Long)srcFileStatus.getLength(), (Long)new Long(((BaseFile)bootstrapBaseFile.get()).getFileStatus().getLen()));
            Assertions.assertEquals((Integer)srcFileStatus.getBlockReplication(), (Integer)new Integer(((BaseFile)bootstrapBaseFile.get()).getFileStatus().getReplication()));
            Assertions.assertEquals((Object)(srcFileStatus.getIsDir() == null ? false : srcFileStatus.getIsDir()), (Object)((BaseFile)bootstrapBaseFile.get()).getFileStatus().isDirectory());
            Assertions.assertEquals((Object)FileStatusUtils.toFSPermission((HoodieFSPermission)srcFileStatus.getPermission()), (Object)((BaseFile)bootstrapBaseFile.get()).getFileStatus().getPermission());
            Assertions.assertEquals((Object)srcFileStatus.getPermission(), (Object)FileStatusUtils.fromFSPermission((FsPermission)((BaseFile)bootstrapBaseFile.get()).getFileStatus().getPermission()));
            Assertions.assertEquals((Object)(srcFileStatus.getSymlink() != null ? 1 : 0), (Object)((BaseFile)bootstrapBaseFile.get()).getFileStatus().isSymlink());
        } else {
            Assertions.assertFalse((boolean)bootstrapBaseFile.isPresent());
        }
    }

    protected void testViewForFileSlicesWithAsyncCompaction(boolean skipCreatingDataFile, boolean isCompactionInFlight, int expTotalFileSlices, int expTotalDataFiles, boolean includeInvalidAndInflight, boolean testBootstrap) throws Exception {
        HoodieInstant compactionInstant;
        if (testBootstrap) {
            this.metaClient = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType(), BOOTSTRAP_SOURCE_PATH, testBootstrap);
        }
        String partitionPath = "2016/05/01";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId = UUID.randomUUID().toString();
        String srcName = "part_0000" + this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        HoodieFileStatus srcFileStatus = HoodieFileStatus.newBuilder().setPath(HoodiePath.newBuilder().setUri(BOOTSTRAP_SOURCE_PATH + partitionPath + "/" + srcName).build()).setLength(Long.valueOf(0x10000000L)).setAccessTime(Long.valueOf(new Date().getTime())).setModificationTime(Long.valueOf(new Date().getTime() + 99999L)).setBlockReplication(Integer.valueOf(2)).setOwner("hudi").setGroup("hudi").setBlockSize(Long.valueOf(0x8000000L)).setPermission(HoodieFSPermission.newBuilder().setUserAction(FsAction.ALL.name()).setGroupAction(FsAction.READ.name()).setOtherAction(FsAction.NONE.name()).setStickyBit(Boolean.valueOf(true)).build()).build();
        String instantTime1 = testBootstrap && !skipCreatingDataFile ? "00000000000001" : "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String dataFileName = null;
        if (!skipCreatingDataFile) {
            dataFileName = FSUtils.makeDataFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId);
            new File(this.basePath + "/" + partitionPath + "/" + dataFileName).createNewFile();
        }
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName2 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", instantTime1);
        HoodieInstant deltaInstant2 = new HoodieInstant(true, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant3 = new HoodieInstant(true, "deltacommit", deltaInstantTime2);
        if (testBootstrap && !skipCreatingDataFile) {
            try (BootstrapIndex.IndexWriter writer = new HFileBootstrapIndex(this.metaClient).createWriter(BOOTSTRAP_SOURCE_PATH);){
                writer.begin();
                BootstrapFileMapping mapping = new BootstrapFileMapping(BOOTSTRAP_SOURCE_PATH, partitionPath, partitionPath, srcFileStatus, fileId);
                ArrayList<BootstrapFileMapping> b = new ArrayList<BootstrapFileMapping>();
                b.add(mapping);
                writer.appendNextPartition(partitionPath, b);
                writer.finish();
            }
        }
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant2, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant3, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSlices.size());
        FileSlice fileSlice = (FileSlice)fileSlices.get(0);
        Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime());
        if (!skipCreatingDataFile) {
            Assertions.assertTrue((boolean)fileSlice.getBaseFile().isPresent());
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile(), testBootstrap);
        }
        String compactionRequestedTime = "4";
        String compactDataFileName = FSUtils.makeDataFileName((String)compactionRequestedTime, (String)TEST_WRITE_TOKEN, (String)fileId);
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath, fileSlices.get(0)));
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        if (isCompactionInFlight) {
            new File(this.basePath + "/" + partitionPath + "/" + compactDataFileName).createNewFile();
            compactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
            HoodieInstant requested = HoodieTimeline.getCompactionRequestedInstant((String)compactionInstant.getTimestamp());
            commitTimeline.saveToCompactionRequested(requested, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
            commitTimeline.transitionCompactionRequestedToInflight(requested);
        } else {
            compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", compactionRequestedTime);
            commitTimeline.saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        }
        this.refreshFsView();
        List slices = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)slices.size(), (String)"Expected latest file-slices");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)((FileSlice)slices.get(0)).getBaseInstantTime(), (String)"Base-Instant must be compaction Instant");
        Assertions.assertFalse((boolean)((FileSlice)slices.get(0)).getBaseFile().isPresent(), (String)"Latest File Slice must not have data-file");
        Assertions.assertEquals((long)0L, (long)((FileSlice)slices.get(0)).getLogFiles().count(), (String)"Latest File Slice must not have any log-files");
        String deltaInstantTime4 = "5";
        String deltaInstantTime5 = "6";
        List<String> allInstantTimes = Arrays.asList(instantTime1, deltaInstantTime1, deltaInstantTime2, compactionRequestedTime, deltaInstantTime4, deltaInstantTime5);
        String fileName3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)compactionRequestedTime, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName4 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)compactionRequestedTime, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath + "/" + fileName4).createNewFile();
        HoodieInstant deltaInstant4 = new HoodieInstant(true, "deltacommit", deltaInstantTime4);
        HoodieInstant deltaInstant5 = new HoodieInstant(true, "deltacommit", deltaInstantTime5);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant4, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant5, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        List<HoodieBaseFile> dataFiles = this.roView.getAllBaseFiles(partitionPath).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertTrue((boolean)dataFiles.isEmpty(), (String)"No data file expected");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
            Assertions.assertEquals((Object)dataFileName, (Object)((HoodieBaseFile)dataFiles.get(0)).getFileName(), (String)"Expect only valid data-file");
        }
        List fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect file-slice to be merged");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
        if (!skipCreatingDataFile) {
            Assertions.assertEquals((Object)dataFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Data file must be present");
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile(), testBootstrap);
        } else {
            Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected as it was not created");
        }
        Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant of penultimate file-slice must be base instant");
        List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)4, (int)logFiles.size(), (String)"Log files must include those after compaction request");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName2, (Object)((HoodieLogFile)logFiles.get(2)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(3)).getFileName(), (String)"Log File Order check");
        fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5, true).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect only one file-id");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
        Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected in latest file-slice");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Compaction requested instant must be base instant");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Log files must include only those after compaction request");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFiles(partitionPath).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        dataFiles = this.roView.getLatestBaseFilesInRange(allInstantTimes).collect(Collectors.toList());
        if (skipCreatingDataFile) {
            Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"Expect no data file to be returned");
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
            dataFiles.forEach(df -> Assertions.assertEquals((Object)df.getCommitTime(), (Object)instantTime1, (String)"Expect data-file for instant 1 be returned"));
            this.checkExternalFile(srcFileStatus, (Option<BaseFile>)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile(), testBootstrap);
        }
        String inflightFileId1 = UUID.randomUUID().toString();
        String inflightFileId2 = UUID.randomUUID().toString();
        String orphanFileId1 = UUID.randomUUID().toString();
        String orphanFileId2 = UUID.randomUUID().toString();
        String invalidInstantId = "INVALIDTIME";
        String inflightDeltaInstantTime = "7";
        String orphanDataFileName = FSUtils.makeDataFileName((String)"INVALIDTIME", (String)TEST_WRITE_TOKEN, (String)orphanFileId1);
        new File(this.basePath + "/" + partitionPath + "/" + orphanDataFileName).createNewFile();
        String orphanLogFileName = FSUtils.makeLogFileName((String)orphanFileId2, (String)".log", (String)"INVALIDTIME", (int)0, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + orphanLogFileName).createNewFile();
        String inflightDataFileName = FSUtils.makeDataFileName((String)inflightDeltaInstantTime, (String)TEST_WRITE_TOKEN, (String)inflightFileId1);
        new File(this.basePath + "/" + partitionPath + "/" + inflightDataFileName).createNewFile();
        String inflightLogFileName = FSUtils.makeLogFileName((String)inflightFileId2, (String)".log", (String)inflightDeltaInstantTime, (int)0, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath + "/" + inflightLogFileName).createNewFile();
        commitTimeline.createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", inflightDeltaInstantTime));
        commitTimeline.transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", inflightDeltaInstantTime), Option.empty());
        this.refreshFsView();
        List allRawFileSlices = this.getAllRawFileSlices(partitionPath).collect(Collectors.toList());
        dataFiles = allRawFileSlices.stream().flatMap(slice -> {
            if (slice.getBaseFile().isPresent()) {
                return Stream.of(slice.getBaseFile().get());
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        if (includeInvalidAndInflight) {
            Assertions.assertEquals((int)(2 + (isCompactionInFlight ? 1 : 0) + (skipCreatingDataFile ? 0 : 1)), (int)dataFiles.size(), (String)"Inflight/Orphan data-file is also expected");
            Set fileNames = dataFiles.stream().map(BaseFile::getFileName).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)fileNames.contains(orphanDataFileName), (String)"Expect orphan data-file to be present");
            Assertions.assertTrue((boolean)fileNames.contains(inflightDataFileName), (String)"Expect inflight data-file to be present");
            if (!skipCreatingDataFile) {
                Assertions.assertTrue((boolean)fileNames.contains(dataFileName), (String)"Expect old committed data-file");
            }
            if (isCompactionInFlight) {
                Assertions.assertTrue((boolean)fileNames.contains(compactDataFileName), (String)"Expect inflight compacted data file to be present");
            }
            fileSliceList = this.getLatestRawFileSlices(partitionPath).collect(Collectors.toList());
            Assertions.assertEquals((int)(includeInvalidAndInflight ? 5 : 1), (int)fileSliceList.size(), (String)"Expect both inflight and orphan file-slice to be included");
            Map<String, FileSlice> fileSliceMap = fileSliceList.stream().collect(Collectors.toMap(FileSlice::getFileId, r -> r));
            FileSlice orphanFileSliceWithDataFile = fileSliceMap.get(orphanFileId1);
            FileSlice orphanFileSliceWithLogFile = fileSliceMap.get(orphanFileId2);
            FileSlice inflightFileSliceWithDataFile = fileSliceMap.get(inflightFileId1);
            FileSlice inflightFileSliceWithLogFile = fileSliceMap.get(inflightFileId2);
            Assertions.assertEquals((Object)"INVALIDTIME", (Object)orphanFileSliceWithDataFile.getBaseInstantTime(), (String)"Orphan File Slice with data-file check base-commit");
            Assertions.assertEquals((Object)orphanDataFileName, (Object)((HoodieBaseFile)orphanFileSliceWithDataFile.getBaseFile().get()).getFileName(), (String)"Orphan File Slice with data-file check data-file");
            Assertions.assertEquals((long)0L, (long)orphanFileSliceWithDataFile.getLogFiles().count(), (String)"Orphan File Slice with data-file check data-file");
            Assertions.assertEquals((Object)inflightDeltaInstantTime, (Object)inflightFileSliceWithDataFile.getBaseInstantTime(), (String)"Inflight File Slice with data-file check base-commit");
            Assertions.assertEquals((Object)inflightDataFileName, (Object)((HoodieBaseFile)inflightFileSliceWithDataFile.getBaseFile().get()).getFileName(), (String)"Inflight File Slice with data-file check data-file");
            Assertions.assertEquals((long)0L, (long)inflightFileSliceWithDataFile.getLogFiles().count(), (String)"Inflight File Slice with data-file check data-file");
            Assertions.assertEquals((Object)"INVALIDTIME", (Object)orphanFileSliceWithLogFile.getBaseInstantTime(), (String)"Orphan File Slice with log-file check base-commit");
            Assertions.assertFalse((boolean)orphanFileSliceWithLogFile.getBaseFile().isPresent(), (String)"Orphan File Slice with log-file check data-file");
            logFiles = orphanFileSliceWithLogFile.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Orphan File Slice with log-file check data-file");
            Assertions.assertEquals((Object)orphanLogFileName, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Orphan File Slice with log-file check data-file");
            Assertions.assertEquals((Object)inflightDeltaInstantTime, (Object)inflightFileSliceWithLogFile.getBaseInstantTime(), (String)"Inflight File Slice with log-file check base-commit");
            Assertions.assertFalse((boolean)inflightFileSliceWithLogFile.getBaseFile().isPresent(), (String)"Inflight File Slice with log-file check data-file");
            logFiles = inflightFileSliceWithLogFile.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)logFiles.size(), (String)"Inflight File Slice with log-file check data-file");
            Assertions.assertEquals((Object)inflightLogFileName, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Inflight File Slice with log-file check data-file");
        }
        compactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
        if (!isCompactionInFlight) {
            new File(this.basePath + "/" + partitionPath + "/" + compactDataFileName).createNewFile();
            commitTimeline.createNewInstant(compactionInstant);
        }
        commitTimeline.saveAsComplete(compactionInstant, Option.empty());
        this.refreshFsView();
        this.roView.getAllBaseFiles(partitionPath);
        fileSliceList = this.rtView.getLatestFileSlices(partitionPath).collect(Collectors.toList());
        LOG.info((Object)("FILESLICE LIST=" + fileSliceList));
        dataFiles = fileSliceList.stream().map(FileSlice::getBaseFile).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-files in latest view as there is only one file-group");
        Assertions.assertEquals((Object)compactDataFileName, (Object)((HoodieBaseFile)dataFiles.get(0)).getFileName(), (String)"Data Filename must match");
        Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Only one latest file-slice in the partition");
        Assertions.assertFalse((boolean)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        fileSlice = (FileSlice)fileSliceList.get(0);
        Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId(), (String)"Check file-Id is set correctly");
        Assertions.assertEquals((Object)compactDataFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Check data-filename is set correctly");
        Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Ensure base-instant is now compaction request instant");
        logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Only log-files after compaction request shows up");
        Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
        Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
        dataFiles = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        Assertions.assertFalse((boolean)((HoodieBaseFile)dataFiles.get(0)).getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFiles(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        dataFiles = this.roView.getLatestBaseFilesInRange(allInstantTimes).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"Expect only one data-file to be sent");
        dataFiles.forEach(df -> {
            Assertions.assertEquals((Object)df.getCommitTime(), (Object)compactionRequestedTime, (String)"Expect data-file created by compaction be returned");
            Assertions.assertFalse((boolean)df.getBootstrapBaseFile().isPresent(), (String)"No external data file must be present");
        });
        Assertions.assertEquals((long)expTotalFileSlices, (long)this.rtView.getAllFileSlices(partitionPath).count(), (String)"Total number of file-slices in partitions matches expected");
        Assertions.assertEquals((long)expTotalDataFiles, (long)this.roView.getAllBaseFiles(partitionPath).count(), (String)"Total number of data-files in partitions matches expected");
        Assertions.assertEquals((long)5L, (long)this.fsView.getAllFileGroups(partitionPath).count(), (String)"Total number of file-groups in partitions matches expected");
    }

    @Test
    public void testGetLatestDataFilesForFileId() throws IOException {
        String partitionPath = "2016/05/01";
        new File(this.basePath + "/" + partitionPath).mkdirs();
        String fileId = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath).anyMatch(dfile -> dfile.getFileId().equals(fileId)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId);
        new File(this.basePath + "/" + partitionPath + "/" + fileName1).createNewFile();
        this.refreshFsView();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath).anyMatch(dfile -> dfile.getFileId().equals(fileId)), (String)"No commit, should not find any data file");
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", commitTime1);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName1, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
        String commitTime2 = "2";
        String fileName2 = FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId);
        new File(this.basePath + "/" + partitionPath + "/" + fileName2).createNewFile();
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName1, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
        HoodieInstant instant2 = new HoodieInstant(true, "commit", commitTime2);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant2, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        Assertions.assertEquals((Object)fileName2, (Object)this.roView.getLatestBaseFiles(partitionPath).filter(dfile -> dfile.getFileId().equals(fileId)).findFirst().get().getFileName());
    }

    @Test
    public void testStreamLatestVersionInPartition() throws IOException {
        this.testStreamLatestVersionInPartition(false);
    }

    public void testStreamLatestVersionInPartition(boolean isLatestFileSliceOnly) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String cleanTime1 = "1";
        String commitTime1 = "2";
        String commitTime2 = "3";
        String commitTime3 = "4";
        String commitTime4 = "5";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime4, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime4, (int)1, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)commitTime3, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId4, (String)".log", (String)commitTime4, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(this.basePath + "/.hoodie/" + cleanTime1 + ".clean").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime4 + ".commit").createNewFile();
        this.testStreamLatestVersionInPartition(isLatestFileSliceOnly, fullPartitionPath, commitTime1, commitTime2, commitTime3, commitTime4, fileId1, fileId2, fileId3, fileId4);
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").delete();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").delete();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").delete();
        this.testStreamLatestVersionInPartition(isLatestFileSliceOnly, fullPartitionPath, commitTime1, commitTime2, commitTime3, commitTime4, fileId1, fileId2, fileId3, fileId4);
    }

    private void testStreamLatestVersionInPartition(boolean isLatestFileSliceOnly, String fullPartitionPath, String commitTime1, String commitTime2, String commitTime3, String commitTime4, String fileId1, String fileId2, String fileId3, String fileId4) throws IOException {
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path(fullPartitionPath));
        Assertions.assertEquals((int)11, (int)statuses.length);
        this.refreshFsView();
        List allSlices = this.rtView.getAllFileSlices("2016/05/01").collect(Collectors.toList());
        Assertions.assertEquals((int)(isLatestFileSliceOnly ? 4 : 8), (int)allSlices.size());
        Map<String, Long> fileSliceMap = allSlices.stream().collect(Collectors.groupingBy(FileSlice::getFileId, Collectors.counting()));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 2L), (long)fileSliceMap.get(fileId1));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 3L), (long)fileSliceMap.get(fileId2));
        Assertions.assertEquals((long)(isLatestFileSliceOnly ? 1L : 2L), (long)fileSliceMap.get(fileId3));
        Assertions.assertEquals((long)1L, (long)fileSliceMap.get(fileId4));
        List dataFileList = this.roView.getLatestBaseFilesBeforeOrOn("2016/05/01", commitTime4).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)dataFileList.size());
        HashSet<String> filenames = new HashSet<String>();
        for (Object status : dataFileList) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)));
        filenames = new HashSet();
        List logFilesList = this.rtView.getLatestFileSlicesBeforeOrOn("2016/05/01", commitTime4, true).map(FileSlice::getLogFiles).flatMap(logFileList -> logFileList).collect(Collectors.toList());
        Assertions.assertEquals((int)logFilesList.size(), (int)4);
        for (HoodieLogFile logFile : logFilesList) {
            filenames.add(logFile.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime4, (int)0, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime4, (int)1, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)commitTime3, (int)0, (String)TEST_WRITE_TOKEN)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeLogFileName((String)fileId4, (String)".log", (String)commitTime4, (int)0, (String)TEST_WRITE_TOKEN)));
        List dataFiles = this.roView.getLatestBaseFilesBeforeOrOn("2016/05/01", commitTime3).collect(Collectors.toList());
        filenames = new HashSet();
        for (HoodieBaseFile status : dataFiles) {
            filenames.add(status.getFileName());
        }
        if (!isLatestFileSliceOnly) {
            Assertions.assertEquals((int)3, (int)dataFiles.size());
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)));
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)));
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)));
        } else {
            Assertions.assertEquals((int)1, (int)dataFiles.size());
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)));
        }
        logFilesList = this.rtView.getLatestFileSlicesBeforeOrOn("2016/05/01", commitTime3, true).map(FileSlice::getLogFiles).flatMap(logFileList -> logFileList).collect(Collectors.toList());
        Assertions.assertEquals((int)logFilesList.size(), (int)1);
        Assertions.assertEquals((Object)((HoodieLogFile)logFilesList.get(0)).getFileName(), (Object)FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)commitTime3, (int)0, (String)TEST_WRITE_TOKEN));
    }

    @Test
    public void testStreamEveryVersionInPartition() throws IOException {
        this.testStreamEveryVersionInPartition(false);
    }

    protected void testStreamEveryVersionInPartition(boolean isLatestFileSliceOnly) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime4 + ".commit").createNewFile();
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path(fullPartitionPath));
        Assertions.assertEquals((int)7, (int)statuses.length);
        this.refreshFsView();
        List fileGroups = this.fsView.getAllFileGroups("2016/05/01").collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)fileGroups.size());
        for (HoodieFileGroup fileGroup : fileGroups) {
            String fileId = fileGroup.getFileGroupId().getFileId();
            HashSet filenames = new HashSet();
            fileGroup.getAllBaseFiles().forEach(dataFile -> {
                Assertions.assertEquals((Object)fileId, (Object)dataFile.getFileId(), (String)"All same fileId should be grouped");
                filenames.add(dataFile.getFileName());
            });
            HashSet<String> expFileNames = new HashSet<String>();
            if (fileId.equals(fileId1)) {
                if (!isLatestFileSliceOnly) {
                    expFileNames.add(FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1));
                }
                expFileNames.add(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1));
                Assertions.assertEquals(expFileNames, filenames);
                continue;
            }
            if (fileId.equals(fileId2)) {
                if (!isLatestFileSliceOnly) {
                    expFileNames.add(FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2));
                    expFileNames.add(FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2));
                }
                expFileNames.add(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2));
                Assertions.assertEquals(expFileNames, filenames);
                continue;
            }
            if (!isLatestFileSliceOnly) {
                expFileNames.add(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3));
            }
            expFileNames.add(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3));
            Assertions.assertEquals(expFileNames, filenames);
        }
    }

    @Test
    public void testStreamLatestVersionInRange() throws IOException {
        this.testStreamLatestVersionInRange(false);
    }

    protected void testStreamLatestVersionInRange(boolean isLatestFileSliceOnly) throws IOException {
        String fullPartitionPath = this.basePath + "/2016/05/01/";
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime1, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)commitTime3, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime4 + ".commit").createNewFile();
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path(fullPartitionPath));
        Assertions.assertEquals((int)9, (int)statuses.length);
        this.refreshFsView();
        this.roView.getAllBaseFiles("2016/05/01/");
        List dataFiles = this.roView.getLatestBaseFilesInRange(Arrays.asList(commitTime2, commitTime3)).collect(Collectors.toList());
        Assertions.assertEquals((int)(isLatestFileSliceOnly ? 2 : 3), (int)dataFiles.size());
        HashSet<String> filenames = new HashSet<String>();
        for (HoodieBaseFile status : dataFiles) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId1)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)));
        if (!isLatestFileSliceOnly) {
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)));
        }
        List slices = this.rtView.getLatestFileSliceInRange(Arrays.asList(commitTime3, commitTime4)).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)slices.size());
        for (FileSlice slice : slices) {
            if (slice.getFileId().equals(fileId1)) {
                Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime3);
                Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
                Assertions.assertEquals((long)slice.getLogFiles().count(), (long)0L);
                continue;
            }
            if (slice.getFileId().equals(fileId2)) {
                Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime3);
                Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
                Assertions.assertEquals((long)slice.getLogFiles().count(), (long)1L);
                continue;
            }
            if (!slice.getFileId().equals(fileId3)) continue;
            Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)commitTime4);
            Assertions.assertTrue((boolean)slice.getBaseFile().isPresent());
            Assertions.assertEquals((long)slice.getLogFiles().count(), (long)0L);
        }
    }

    @Test
    public void testStreamLatestVersionsBefore() throws IOException {
        this.testStreamLatestVersionsBefore(false);
    }

    protected void testStreamLatestVersionsBefore(boolean isLatestFileSliceOnly) throws IOException {
        String partitionPath = "2016/05/01/";
        String fullPartitionPath = this.basePath + "/" + partitionPath;
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime4 + ".commit").createNewFile();
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path(fullPartitionPath));
        Assertions.assertEquals((int)7, (int)statuses.length);
        this.refreshFsView();
        List dataFiles = this.roView.getLatestBaseFilesBeforeOrOn(partitionPath, commitTime2).collect(Collectors.toList());
        if (!isLatestFileSliceOnly) {
            Assertions.assertEquals((int)2, (int)dataFiles.size());
            HashSet<String> filenames = new HashSet<String>();
            for (HoodieBaseFile status : dataFiles) {
                filenames.add(status.getFileName());
            }
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)));
            Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)));
        } else {
            Assertions.assertEquals((int)0, (int)dataFiles.size());
        }
    }

    @Test
    public void testStreamLatestVersions() throws IOException {
        this.testStreamLatestVersions(false);
    }

    protected void testStreamLatestVersions(boolean isLatestFileSliceOnly) throws IOException {
        String partitionPath = "2016/05/01";
        String fullPartitionPath = this.basePath + "/" + partitionPath;
        new File(fullPartitionPath).mkdirs();
        String commitTime1 = "1";
        String commitTime2 = "2";
        String commitTime3 = "3";
        String commitTime4 = "4";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime1, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileId1, (String)".log", (String)commitTime4, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime2, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeLogFileName((String)fileId2, (String)".log", (String)commitTime2, (int)0, (String)TEST_WRITE_TOKEN)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(fullPartitionPath + "/" + FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)).createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime1 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime2 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime3 + ".commit").createNewFile();
        new File(this.basePath + "/.hoodie/" + commitTime4 + ".commit").createNewFile();
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path(fullPartitionPath));
        Assertions.assertEquals((int)10, (int)statuses.length);
        this.refreshFsView();
        this.fsView.getAllBaseFiles(partitionPath);
        List fileGroups = this.fsView.getAllFileGroups(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)fileGroups.size());
        for (HoodieFileGroup fileGroup : fileGroups) {
            List slices = fileGroup.getAllFileSlices().collect(Collectors.toList());
            String fileId = fileGroup.getFileGroupId().getFileId();
            if (fileId.equals(fileId1)) {
                Assertions.assertEquals((int)(isLatestFileSliceOnly ? 1 : 2), (int)slices.size());
                Assertions.assertEquals((Object)commitTime4, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
                if (isLatestFileSliceOnly) continue;
                Assertions.assertEquals((Object)commitTime1, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
                continue;
            }
            if (fileId.equals(fileId2)) {
                Assertions.assertEquals((int)(isLatestFileSliceOnly ? 1 : 3), (int)slices.size());
                Assertions.assertEquals((Object)commitTime3, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
                if (isLatestFileSliceOnly) continue;
                Assertions.assertEquals((Object)commitTime2, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
                Assertions.assertEquals((Object)commitTime1, (Object)((FileSlice)slices.get(2)).getBaseInstantTime());
                continue;
            }
            if (!fileId.equals(fileId3)) continue;
            Assertions.assertEquals((int)(isLatestFileSliceOnly ? 1 : 2), (int)slices.size());
            Assertions.assertEquals((Object)commitTime4, (Object)((FileSlice)slices.get(0)).getBaseInstantTime());
            if (isLatestFileSliceOnly) continue;
            Assertions.assertEquals((Object)commitTime3, (Object)((FileSlice)slices.get(1)).getBaseInstantTime());
        }
        List statuses1 = this.roView.getLatestBaseFiles().collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)statuses1.size());
        HashSet<String> filenames = new HashSet<String>();
        for (HoodieBaseFile status : statuses1) {
            filenames.add(status.getFileName());
        }
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId1)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime3, (String)TEST_WRITE_TOKEN, (String)fileId2)));
        Assertions.assertTrue((boolean)filenames.contains(FSUtils.makeDataFileName((String)commitTime4, (String)TEST_WRITE_TOKEN, (String)fileId3)));
    }

    @Test
    public void testPendingCompactionWithDuplicateFileIdsAcrossPartitions() throws Exception {
        String partitionPath1 = "2016/05/01";
        String partitionPath2 = "2016/05/02";
        String partitionPath3 = "2016/05/03";
        String fullPartitionPath1 = this.basePath + "/" + partitionPath1 + "/";
        new File(fullPartitionPath1).mkdirs();
        String fullPartitionPath2 = this.basePath + "/" + partitionPath2 + "/";
        new File(fullPartitionPath2).mkdirs();
        String fullPartitionPath3 = this.basePath + "/" + partitionPath3 + "/";
        new File(fullPartitionPath3).mkdirs();
        String instantTime1 = "1";
        String deltaInstantTime1 = "2";
        String deltaInstantTime2 = "3";
        String fileId = UUID.randomUUID().toString();
        String dataFileName = FSUtils.makeDataFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId);
        new File(fullPartitionPath1 + dataFileName).createNewFile();
        String fileName1 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime1, (int)0, (String)TEST_WRITE_TOKEN);
        new File(fullPartitionPath1 + fileName1).createNewFile();
        new File(fullPartitionPath2 + FSUtils.makeDataFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId)).createNewFile();
        new File(fullPartitionPath2 + fileName1).createNewFile();
        new File(fullPartitionPath3 + FSUtils.makeDataFileName((String)instantTime1, (String)TEST_WRITE_TOKEN, (String)fileId)).createNewFile();
        new File(fullPartitionPath3 + fileName1).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", instantTime1);
        HoodieInstant deltaInstant2 = new HoodieInstant(true, "deltacommit", deltaInstantTime1);
        HoodieInstant deltaInstant3 = new HoodieInstant(true, "deltacommit", deltaInstantTime2);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant2, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant3, (Option<byte[]>)Option.empty());
        FileStatus[] statuses = this.metaClient.getFs().listStatus(new Path[]{new Path(fullPartitionPath1), new Path(fullPartitionPath2), new Path(fullPartitionPath3)});
        Assertions.assertEquals((int)6, (int)statuses.length);
        this.refreshFsView();
        Arrays.asList(partitionPath1, partitionPath2, partitionPath3).forEach(p -> this.fsView.getAllFileGroups(p).count());
        List groups = Stream.of(partitionPath1, partitionPath2, partitionPath3).flatMap(p -> this.fsView.getAllFileGroups(p)).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)groups.size(), (String)"Expected number of file-groups");
        Assertions.assertEquals((int)3, (int)groups.stream().map(HoodieFileGroup::getPartitionPath).collect(Collectors.toSet()).size(), (String)"Partitions must be different for file-groups");
        Set fileIds = groups.stream().map(HoodieFileGroup::getFileGroupId).map(HoodieFileGroupId::getFileId).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)fileIds.size(), (String)"File Id must be same");
        Assertions.assertTrue((boolean)fileIds.contains(fileId), (String)"Expected FileId");
        ArrayList<Pair> partitionFileSlicesPairs = new ArrayList<Pair>();
        List fileSlices = this.rtView.getLatestFileSlices(partitionPath1).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath1, fileSlices.get(0)));
        fileSlices = this.rtView.getLatestFileSlices(partitionPath2).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath2, fileSlices.get(0)));
        fileSlices = this.rtView.getLatestFileSlices(partitionPath3).collect(Collectors.toList());
        partitionFileSlicesPairs.add(Pair.of((Object)partitionPath3, fileSlices.get(0)));
        String compactionRequestedTime = "2";
        String compactDataFileName = FSUtils.makeDataFileName((String)compactionRequestedTime, (String)TEST_WRITE_TOKEN, (String)fileId);
        HoodieCompactionPlan compactionPlan = CompactionUtils.buildFromFileSlices(partitionFileSlicesPairs, (Option)Option.empty(), (Option)Option.empty());
        new File(this.basePath + "/" + partitionPath1 + "/" + compactDataFileName).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + compactDataFileName).createNewFile();
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionRequestedTime);
        HoodieInstant requested = HoodieTimeline.getCompactionRequestedInstant((String)compactionInstant.getTimestamp());
        this.metaClient.getActiveTimeline().saveToCompactionRequested(requested, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        this.metaClient.getActiveTimeline().transitionCompactionRequestedToInflight(requested);
        String deltaInstantTime4 = "4";
        String deltaInstantTime5 = "6";
        String fileName3 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)compactionRequestedTime, (int)0, (String)TEST_WRITE_TOKEN);
        String fileName4 = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)compactionRequestedTime, (int)1, (String)TEST_WRITE_TOKEN);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName4).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        new File(this.basePath + "/" + partitionPath3 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath3 + "/" + fileName4).createNewFile();
        HoodieInstant deltaInstant4 = new HoodieInstant(true, "deltacommit", deltaInstantTime4);
        HoodieInstant deltaInstant5 = new HoodieInstant(true, "deltacommit", deltaInstantTime5);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant4, (Option<byte[]>)Option.empty());
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, deltaInstant5, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        List dataFiles = this.roView.getAllBaseFiles(partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
        Assertions.assertEquals((Object)"1", (Object)((HoodieBaseFile)dataFiles.get(0)).getCommitTime(), (String)"Expect only valid commit");
        dataFiles = this.roView.getAllBaseFiles(partitionPath2).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)dataFiles.size(), (String)"One data-file is expected as there is only one file-group");
        Assertions.assertEquals((Object)"1", (Object)((HoodieBaseFile)dataFiles.get(0)).getCommitTime(), (String)"Expect only valid commit");
        Arrays.asList(partitionPath1, partitionPath2, partitionPath3).forEach(partitionPath -> {
            List fileSliceList = this.rtView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect file-slice to be merged");
            FileSlice fileSlice = (FileSlice)fileSliceList.get(0);
            Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
            Assertions.assertEquals((Object)dataFileName, (Object)((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName(), (String)"Data file must be present");
            Assertions.assertEquals((Object)instantTime1, (Object)fileSlice.getBaseInstantTime(), (String)"Base Instant of penultimate file-slice must be base instant");
            List logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)3, (int)logFiles.size(), (String)"Log files must include those after compaction request");
            Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)fileName1, (Object)((HoodieLogFile)logFiles.get(2)).getFileName(), (String)"Log File Order check");
            fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5, true).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)fileSliceList.size(), (String)"Expect only one file-id");
            fileSlice = (FileSlice)fileSliceList.get(0);
            Assertions.assertEquals((Object)fileId, (Object)fileSlice.getFileId());
            Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"No data-file expected in latest file-slice");
            Assertions.assertEquals((Object)compactionRequestedTime, (Object)fileSlice.getBaseInstantTime(), (String)"Compaction requested instant must be base instant");
            logFiles = fileSlice.getLogFiles().collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)logFiles.size(), (String)"Log files must include only those after compaction request");
            Assertions.assertEquals((Object)fileName4, (Object)((HoodieLogFile)logFiles.get(0)).getFileName(), (String)"Log File Order check");
            Assertions.assertEquals((Object)fileName3, (Object)((HoodieLogFile)logFiles.get(1)).getFileName(), (String)"Log File Order check");
            fileSliceList = this.rtView.getLatestFileSlicesBeforeOrOn(partitionPath, deltaInstantTime5, false).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)fileSliceList.size(), (String)"Expect empty list as file-id is in pending compaction");
        });
        Assertions.assertEquals((long)3L, (long)this.fsView.getPendingCompactionOperations().count());
        Set partitionsInCompaction = this.fsView.getPendingCompactionOperations().map(Pair::getValue).map(CompactionOperation::getPartitionPath).collect(Collectors.toSet());
        Assertions.assertEquals((int)3, (int)partitionsInCompaction.size());
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath1));
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath2));
        Assertions.assertTrue((boolean)partitionsInCompaction.contains(partitionPath3));
        Set fileIdsInCompaction = this.fsView.getPendingCompactionOperations().map(Pair::getValue).map(CompactionOperation::getFileId).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)fileIdsInCompaction.size());
        Assertions.assertTrue((boolean)fileIdsInCompaction.contains(fileId));
    }

    private static void saveAsComplete(HoodieActiveTimeline timeline, HoodieInstant inflight, Option<byte[]> data) {
        if (inflight.getAction().equals("compaction")) {
            timeline.transitionCompactionInflightToComplete(inflight, data);
        } else {
            HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.getTimestamp());
            timeline.createNewInstant(requested);
            timeline.transitionRequestedToInflight(requested, Option.empty());
            timeline.saveAsComplete(inflight, data);
        }
    }

    @Test
    public void testReplaceWithTimeTravel() throws IOException {
        String partitionPath1 = "2020/06/27";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1);
        String fileName2 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", commitTime1);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        String fileName3 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3);
        String fileName4 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId4);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName4).createNewFile();
        String commitTime2 = "2";
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add(fileId1);
        partitionToReplaceFileIds.put(partitionPath1, replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT_OVERWRITE, (String)"", (String)"replacecommit");
        commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant2 = new HoodieInstant(true, "replacecommit", commitTime2);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant2, (Option<byte[]>)Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        SyncableFileSystemView filteredView = this.getFileSystemView((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsBefore("2"), false);
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)1L, (long)filteredView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        List replacedOnInstant1 = this.fsView.getReplacedFileGroupsBeforeOrOn("1", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)replacedOnInstant1.size());
        List allReplaced = this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)allReplaced.size());
        Assertions.assertEquals((Object)fileId1, (Object)((HoodieFileGroup)allReplaced.get(0)).getFileGroupId().getFileId());
        allReplaced = this.fsView.getReplacedFileGroupsBefore("2", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)allReplaced.size());
        allReplaced = this.fsView.getAllReplacedFileGroups(partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)allReplaced.size());
        Assertions.assertEquals((Object)fileId1, (Object)((HoodieFileGroup)allReplaced.get(0)).getFileGroupId().getFileId());
    }

    @Test
    public void testReplaceFileIdIsExcludedInView() throws IOException {
        String partitionPath1 = "2020/06/27";
        String partitionPath2 = "2020/07/14";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        new File(this.basePath + "/" + partitionPath2).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2)), (String)"No commit, should not find any data file");
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath2).anyMatch(dfile -> dfile.getFileId().equals(fileId3) || dfile.getFileId().equals(fileId4)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1);
        String fileName2 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2);
        String fileName3 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3);
        String fileName4 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId4);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName3).createNewFile();
        new File(this.basePath + "/" + partitionPath2 + "/" + fileName4).createNewFile();
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIdsP1 = new ArrayList<String>();
        replacedFileIdsP1.add(fileId1);
        partitionToReplaceFileIds.put(partitionPath1, replacedFileIdsP1);
        ArrayList<String> replacedFileIdsP2 = new ArrayList<String>();
        replacedFileIdsP2.add(fileId3);
        replacedFileIdsP2.add(fileId4);
        partitionToReplaceFileIds.put(partitionPath2, replacedFileIdsP2);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(Collections.emptyList(), partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT_OVERWRITE, (String)"", (String)"replacecommit");
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "replacecommit", commitTime1);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.of((Object)commitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        this.refreshFsView();
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((Object)fileName2, (Object)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).findFirst().get().getFileName());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        Assertions.assertEquals((long)0L, (long)this.roView.getLatestBaseFiles(partitionPath2).filter(dfile -> dfile.getFileId().equals(fileId4)).count());
        List replacedOnInstant1 = this.fsView.getReplacedFileGroupsBeforeOrOn("0", partitionPath1).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)replacedOnInstant1.size());
        List allReplaced = this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath1).collect(Collectors.toList());
        allReplaced.addAll(this.fsView.getReplacedFileGroupsBeforeOrOn("2", partitionPath2).collect(Collectors.toList()));
        Assertions.assertEquals((int)3, (int)allReplaced.size());
        Set allReplacedFileIds = allReplaced.stream().map(fg -> fg.getFileGroupId().getFileId()).collect(Collectors.toSet());
        Set actualReplacedFileIds = Stream.of(fileId1, fileId3, fileId4).collect(Collectors.toSet());
        Assertions.assertEquals(actualReplacedFileIds, allReplacedFileIds);
    }

    @Test
    public void testPendingClusteringOperations() throws IOException {
        String partitionPath1 = "2020/06/27";
        new File(this.basePath + "/" + partitionPath1).mkdirs();
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.roView.getLatestBaseFiles(partitionPath1).anyMatch(dfile -> dfile.getFileId().equals(fileId1) || dfile.getFileId().equals(fileId2) || dfile.getFileId().equals(fileId3)), (String)"No commit, should not find any data file");
        String commitTime1 = "1";
        String fileName1 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId1);
        String fileName2 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId2);
        String fileName3 = FSUtils.makeDataFileName((String)commitTime1, (String)TEST_WRITE_TOKEN, (String)fileId3);
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName1).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName2).createNewFile();
        new File(this.basePath + "/" + partitionPath1 + "/" + fileName3).createNewFile();
        HoodieActiveTimeline commitTimeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant1 = new HoodieInstant(true, "commit", commitTime1);
        TestHoodieTableFileSystemView.saveAsComplete(commitTimeline, instant1, (Option<byte[]>)Option.empty());
        this.refreshFsView();
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId1)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId2)).count());
        Assertions.assertEquals((long)1L, (long)this.roView.getLatestBaseFiles(partitionPath1).filter(dfile -> dfile.getFileId().equals(fileId3)).count());
        List[] fileSliceGroups = new List[]{Collections.singletonList(this.fsView.getLatestFileSlice(partitionPath1, fileId1).get()), Collections.singletonList(this.fsView.getLatestFileSlice(partitionPath1, fileId2).get())};
        HoodieClusteringPlan plan = ClusteringUtils.createClusteringPlan((String)"strategy", new HashMap(), (List[])fileSliceGroups, Collections.emptyMap());
        String clusterTime = "2";
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", clusterTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setClusteringPlan(plan).setOperationType(WriteOperationType.CLUSTER.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingReplaceCommit(instant2, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
        this.refreshFsView();
        Set fileIds = this.fsView.getFileGroupsInPendingClustering().map(e -> ((HoodieFileGroupId)e.getLeft()).getFileId()).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)fileIds.contains(fileId1));
        Assertions.assertTrue((boolean)fileIds.contains(fileId2));
        Assertions.assertFalse((boolean)fileIds.contains(fileId3));
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

