/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestIncrementalFSViewSync
extends HoodieCommonTestHarness {
    private static final Logger LOG = LogManager.getLogger(TestIncrementalFSViewSync.class);
    private static final int NUM_FILE_IDS_PER_PARTITION = 10;
    private static String TEST_WRITE_TOKEN = "1-0-1";
    private final List<String> partitions = Arrays.asList("2018/01/01", "2018/01/02", "2019/03/01");
    private final List<String> fileIdsPerPartition = IntStream.range(0, 10).mapToObj(x -> UUID.randomUUID().toString()).collect(Collectors.toList());

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
        for (String p : this.partitions) {
            Files.createDirectories(Paths.get(this.basePath, p), new FileAttribute[0]);
        }
        this.refreshFsView();
    }

    @Test
    public void testEmptyPartitionsAndTimeline() throws IOException {
        SyncableFileSystemView view = this.getFileSystemView(this.metaClient);
        Assertions.assertFalse((boolean)view.getLastInstant().isPresent());
        this.partitions.forEach(p -> Assertions.assertEquals((long)0L, (long)view.getLatestFileSlices(p).count()));
    }

    @Test
    public void testAsyncCompaction() throws IOException {
        SyncableFileSystemView view = this.getFileSystemView(this.metaClient);
        view.sync();
        Map<String, List<String>> instantsToFiles = this.testMultipleWriteSteps(view, Arrays.asList("11", "12", "13"), true, "11");
        this.scheduleCompaction(view, "14");
        this.unscheduleCompaction(view, "14", "13", "11");
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Collections.singletonList("15"), true, "11"));
        this.scheduleCompaction(view, "16");
        this.testMultipleWriteSteps(view, Collections.singletonList("16"), false, "16", 2);
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Arrays.asList("17", "18"), true, "16", 2));
        this.scheduleCompaction(view, "19");
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Collections.singletonList("20"), true, "19", 3));
        this.testCleans(view, Collections.singletonList("21"), (Map<String, List<String>>)new HashMap<String, List<String>>(){
            {
                this.put("11", Arrays.asList("12", "13", "15"));
            }
        }, instantsToFiles, Collections.singletonList("11"), 0, 0);
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Collections.singletonList("22"), true, "19", 2));
        this.testRestore(view, Collections.singletonList("23"), new HashMap<String, List<String>>(), Collections.singletonList(this.getHoodieCommitInstant("22", true)), "24", false);
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Collections.singletonList("24"), true, "19", 2));
        instantsToFiles.putAll(this.testMultipleWriteSteps(view, Collections.singletonList("19"), false, "19", 2, Collections.singletonList(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "24"))));
    }

    @Test
    public void testIngestion() throws IOException {
        SyncableFileSystemView view = this.getFileSystemView(this.metaClient);
        String firstEmptyInstantTs = "11";
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        this.metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(true, "commit", firstEmptyInstantTs));
        this.metaClient.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "commit", firstEmptyInstantTs), Option.of((Object)metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        view.sync();
        Assertions.assertTrue((boolean)view.getLastInstant().isPresent());
        Assertions.assertEquals((Object)"11", (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)view.getLastInstant().get()).getState());
        Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)view.getLastInstant().get()).getAction());
        this.partitions.forEach(p -> Assertions.assertEquals((long)0L, (long)view.getLatestFileSlices(p).count()));
        this.metaClient.reloadActiveTimeline();
        SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
        this.areViewsConsistent(view, newView, 0L);
        Map<String, List<String>> instantsToFiles = this.testMultipleWriteSteps(view, Arrays.asList("12", "13", "14"));
        this.testRestore(view, Arrays.asList("15", "16", "17"), instantsToFiles, Arrays.asList(this.getHoodieCommitInstant("14", false), this.getHoodieCommitInstant("13", false), this.getHoodieCommitInstant("12", false)), "17", true);
        instantsToFiles = this.testMultipleWriteSteps(view, Arrays.asList("18", "19", "20"));
        this.testCleans(view, Arrays.asList("21", "22"), instantsToFiles, Arrays.asList("18", "19"), 0, 0);
    }

    @Test
    public void testReplaceCommits() throws IOException {
        SyncableFileSystemView view = this.getFileSystemView(this.metaClient);
        String firstEmptyInstantTs = "11";
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        this.metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(true, "commit", firstEmptyInstantTs));
        this.metaClient.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "commit", firstEmptyInstantTs), Option.of((Object)metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        view.sync();
        Assertions.assertTrue((boolean)view.getLastInstant().isPresent());
        Assertions.assertEquals((Object)"11", (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)view.getLastInstant().get()).getState());
        Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)view.getLastInstant().get()).getAction());
        this.partitions.forEach(p -> Assertions.assertEquals((long)0L, (long)view.getLatestFileSlices(p).count()));
        this.metaClient.reloadActiveTimeline();
        SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
        this.areViewsConsistent(view, newView, 0L);
        Map<String, List<String>> instantsToFiles = this.testMultipleWriteSteps(view, Arrays.asList("12"));
        this.testMultipleReplaceSteps(instantsToFiles, view, Arrays.asList("13", "14"), 10);
        this.testRestore(view, Arrays.asList("15", "16"), instantsToFiles, Arrays.asList(this.getHoodieReplaceInstant("14"), this.getHoodieReplaceInstant("13")), "17", true, 1, this.fileIdsPerPartition.size());
        instantsToFiles.remove("14");
        instantsToFiles.remove("13");
        this.testMultipleReplaceSteps(instantsToFiles, view, Arrays.asList("18", "19", "20"), 10);
        this.testCleans(view, Arrays.asList("21", "22"), instantsToFiles, Arrays.asList("18", "19"), 10, 1);
    }

    private void testMultipleReplaceSteps(Map<String, List<String>> instantsToFiles, SyncableFileSystemView view, List<String> instants, int initialExpectedSlicesPerPartition) {
        int expectedSlicesPerPartition = initialExpectedSlicesPerPartition;
        for (int i = 0; i < instants.size(); ++i) {
            try {
                this.generateReplaceInstant(instants.get(i), instantsToFiles);
                view.sync();
                this.metaClient.reloadActiveTimeline();
                SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
                expectedSlicesPerPartition = expectedSlicesPerPartition + this.fileIdsPerPartition.size() - 1;
                this.areViewsConsistent(view, newView, expectedSlicesPerPartition * this.partitions.size());
                continue;
            }
            catch (IOException e) {
                throw new HoodieIOException("unable to test replace", e);
            }
        }
    }

    private Map<String, List<String>> generateReplaceInstant(String replaceInstant, Map<String, List<String>> instantsToFiles) throws IOException {
        Map<String, List<String>> partitionToReplacedFileIds = this.pickFilesToReplace(instantsToFiles);
        List<String> newFileIdsToUse = IntStream.range(0, 10).mapToObj(x -> UUID.randomUUID().toString()).collect(Collectors.toList());
        List<String> replacedFiles = this.addReplaceInstant(this.metaClient, replaceInstant, this.generateDataForInstant(replaceInstant, replaceInstant, false, newFileIdsToUse), partitionToReplacedFileIds);
        instantsToFiles.put(replaceInstant, replacedFiles);
        return partitionToReplacedFileIds;
    }

    private Map<String, List<String>> pickFilesToReplace(Map<String, List<String>> instantsToFiles) {
        if (instantsToFiles.isEmpty()) {
            return Collections.emptyMap();
        }
        String maxInstant = (String)instantsToFiles.keySet().stream().max(Comparator.naturalOrder()).get();
        Map partitionToFileIdsList = instantsToFiles.get(maxInstant).stream().map(file -> {
            int lastPartition = file.lastIndexOf("/");
            return Pair.of((Object)file.substring(0, lastPartition), (Object)file.substring(lastPartition + 1));
        }).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
        return this.partitions.stream().map(p -> Pair.of((Object)p, (Object)FSUtils.getFileId((String)((String)((List)partitionToFileIdsList.get(p)).get(0))))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
    }

    private HoodieInstant getHoodieReplaceInstant(String timestamp) {
        return new HoodieInstant(false, "replacecommit", timestamp);
    }

    private HoodieInstant getHoodieCommitInstant(String timestamp, boolean isDeltaCommit) {
        String action = isDeltaCommit ? "deltacommit" : "commit";
        return new HoodieInstant(false, action, timestamp);
    }

    @Test
    public void testMultipleTransitions() throws IOException {
        SyncableFileSystemView view1 = this.getFileSystemView(this.metaClient);
        view1.sync();
        Map<String, List<String>> instantsToFiles = this.testMultipleWriteSteps(view1, Collections.singletonList("11"), true, "11");
        SyncableFileSystemView view2 = this.getFileSystemView(HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getBasePath()).build());
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Arrays.asList("12", "13"), true, "11"));
        instantsToFiles.putAll(this.testMultipleWriteSteps(view1, Collections.singletonList("14"), true, "11"));
        view2.sync();
        SyncableFileSystemView view3 = this.getFileSystemView(HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getBasePath()).build());
        view3.sync();
        this.areViewsConsistent(view1, view2, this.partitions.size() * this.fileIdsPerPartition.size());
        this.scheduleCompaction(view2, "15");
        this.unscheduleCompaction(view2, "15", "14", "11");
        view1.sync();
        this.areViewsConsistent(view1, view2, this.partitions.size() * this.fileIdsPerPartition.size());
        SyncableFileSystemView view4 = this.getFileSystemView(HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getBasePath()).build());
        view4.sync();
        this.scheduleCompaction(view2, "16");
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Arrays.asList("17", "18"), true, "16", 2));
        this.testMultipleWriteSteps(view2, Collections.singletonList("16"), false, "16", 2, Collections.singletonList(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "18")));
        view1.sync();
        this.areViewsConsistent(view1, view2, this.partitions.size() * this.fileIdsPerPartition.size() * 2);
        SyncableFileSystemView view5 = this.getFileSystemView(HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getBasePath()).build());
        view5.sync();
        this.testCleans(view2, Collections.singletonList("19"), (Map<String, List<String>>)new HashMap<String, List<String>>(){
            {
                this.put("11", Arrays.asList("12", "13", "14"));
            }
        }, instantsToFiles, Collections.singletonList("11"), 0, 0);
        this.scheduleCompaction(view2, "20");
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Arrays.asList("21", "22"), true, "20", 2));
        this.testMultipleWriteSteps(view2, Collections.singletonList("20"), false, "20", 2, Collections.singletonList(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "22")));
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Arrays.asList("23", "24"), true, "20", 2));
        view1.sync();
        this.areViewsConsistent(view1, view2, this.partitions.size() * this.fileIdsPerPartition.size() * 2);
        SyncableFileSystemView view6 = this.getFileSystemView(HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getBasePath()).build());
        view6.sync();
        this.testRestore(view2, Collections.singletonList("25"), new HashMap<String, List<String>>(), Collections.singletonList(this.getHoodieCommitInstant("24", true)), "29", true);
        this.testRestore(view2, Collections.singletonList("26"), new HashMap<String, List<String>>(), Collections.singletonList(this.getHoodieCommitInstant("23", true)), "29", false);
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Collections.singletonList("27"), true, "20", 2));
        this.scheduleCompaction(view2, "28");
        instantsToFiles.putAll(this.testMultipleWriteSteps(view2, Collections.singletonList("29"), true, "28", 3));
        this.testMultipleWriteSteps(view2, Collections.singletonList("28"), false, "28", 3, Collections.singletonList(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "29")));
        Arrays.asList(view1, view2, view3, view4, view5, view6).forEach(v -> {
            v.sync();
            this.areViewsConsistent((SyncableFileSystemView)v, view1, this.partitions.size() * this.fileIdsPerPartition.size() * 3);
        });
    }

    private void testCleans(SyncableFileSystemView view, List<String> newCleanerInstants, Map<String, List<String>> instantsToFiles, List<String> cleanedInstants, int numberOfFilesAddedPerInstant, int numberOfFilesReplacedPerInstant) {
        Map<String, List<String>> deltaInstantMap = cleanedInstants.stream().map(e -> Pair.of((Object)e, new ArrayList())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        this.testCleans(view, newCleanerInstants, deltaInstantMap, instantsToFiles, cleanedInstants, numberOfFilesAddedPerInstant, numberOfFilesReplacedPerInstant);
    }

    private void testCleans(SyncableFileSystemView view, List<String> newCleanerInstants, Map<String, List<String>> deltaInstantMap, Map<String, List<String>> instantsToFiles, List<String> cleanedInstants, int numFilesAddedPerInstant, int numFilesReplacedPerInstant) {
        int netFilesAddedPerInstant = numFilesAddedPerInstant - numFilesReplacedPerInstant;
        Assertions.assertEquals((int)newCleanerInstants.size(), (int)cleanedInstants.size());
        long exp = this.partitions.stream().mapToLong(p1 -> view.getAllFileSlices(p1).count()).findAny().getAsLong();
        LOG.info((Object)("Initial File Slices :" + exp));
        for (int idx = 0; idx < newCleanerInstants.size(); ++idx) {
            String instant = cleanedInstants.get(idx);
            try {
                ArrayList<String> filesToDelete = new ArrayList<String>((Collection)instantsToFiles.get(instant));
                deltaInstantMap.get(instant).forEach(n -> filesToDelete.addAll((Collection)instantsToFiles.get(n)));
                this.performClean(instant, filesToDelete, newCleanerInstants.get(idx));
                long expTotalFileSlicesPerPartition = exp -= (long)(this.fileIdsPerPartition.size() - numFilesReplacedPerInstant);
                view.sync();
                Assertions.assertTrue((boolean)view.getLastInstant().isPresent());
                Assertions.assertEquals((Object)newCleanerInstants.get(idx), (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
                Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)view.getLastInstant().get()).getState());
                Assertions.assertEquals((Object)"clean", (Object)((HoodieInstant)view.getLastInstant().get()).getAction());
                this.partitions.forEach(p -> {
                    LOG.info((Object)("PARTITION : " + p));
                    LOG.info((Object)("\tFileSlices :" + view.getAllFileSlices(p).collect(Collectors.toList())));
                });
                int instantIdx = newCleanerInstants.size() - idx;
                this.partitions.forEach(p -> Assertions.assertEquals((long)(this.fileIdsPerPartition.size() + instantIdx * netFilesAddedPerInstant), (long)view.getLatestFileSlices(p).count()));
                this.partitions.forEach(p -> Assertions.assertEquals((long)expTotalFileSlicesPerPartition, (long)view.getAllFileSlices(p).count()));
                this.metaClient.reloadActiveTimeline();
                SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
                this.areViewsConsistent(view, newView, expTotalFileSlicesPerPartition * (long)this.partitions.size());
                continue;
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        }
    }

    private void testRestore(SyncableFileSystemView view, List<String> newRestoreInstants, Map<String, List<String>> instantsToFiles, List<HoodieInstant> rolledBackInstants, String emptyRestoreInstant, boolean isRestore) {
        this.testRestore(view, newRestoreInstants, instantsToFiles, rolledBackInstants, emptyRestoreInstant, isRestore, 0, 0);
    }

    private void testRestore(SyncableFileSystemView view, List<String> newRestoreInstants, Map<String, List<String>> instantsToFiles, List<HoodieInstant> rolledBackInstants, String emptyRestoreInstant, boolean isRestore, int totalReplacedFileSlicesPerPartition, int totalFilesAddedPerPartitionPerInstant) {
        Assertions.assertEquals((int)newRestoreInstants.size(), (int)rolledBackInstants.size());
        long initialFileSlices = this.partitions.stream().mapToLong(p -> view.getAllFileSlices(p).count()).findAny().getAsLong();
        int numFileSlicesAddedPerInstant = totalFilesAddedPerPartitionPerInstant - totalReplacedFileSlicesPerPartition;
        long expectedLatestFileSlices = this.fileIdsPerPartition.size() + rolledBackInstants.size() * numFileSlicesAddedPerInstant;
        IntStream.range(0, newRestoreInstants.size()).forEach(idx -> {
            HoodieInstant instant = (HoodieInstant)rolledBackInstants.get(idx);
            try {
                boolean isDeltaCommit = "deltacommit".equalsIgnoreCase(instant.getAction());
                this.performRestore(instant, (List)instantsToFiles.get(instant.getTimestamp()), (String)newRestoreInstants.get(idx), isRestore);
                long expTotalFileSlicesPerPartition = isDeltaCommit ? initialFileSlices : initialFileSlices - (long)((idx + 1) * (this.fileIdsPerPartition.size() - totalReplacedFileSlicesPerPartition));
                view.sync();
                Assertions.assertTrue((boolean)view.getLastInstant().isPresent());
                LOG.info((Object)("Last Instant is :" + view.getLastInstant().get()));
                if (isRestore) {
                    Assertions.assertEquals(newRestoreInstants.get(idx), (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
                    Assertions.assertEquals((Object)"restore", (Object)((HoodieInstant)view.getLastInstant().get()).getAction());
                }
                Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)view.getLastInstant().get()).getState());
                if (HoodieTimeline.compareTimestamps((String)((String)newRestoreInstants.get(idx)), (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)emptyRestoreInstant)) {
                    this.partitions.forEach(p -> Assertions.assertEquals((long)0L, (long)view.getLatestFileSlices(p).count()));
                } else {
                    this.partitions.forEach(p -> Assertions.assertEquals((long)(expectedLatestFileSlices - (long)((idx + 1) * numFileSlicesAddedPerInstant)), (long)view.getLatestFileSlices(p).count()));
                }
                this.partitions.forEach(p -> Assertions.assertEquals((long)expTotalFileSlicesPerPartition, (long)view.getAllFileSlices(p).count()));
                this.metaClient.reloadActiveTimeline();
                SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
                this.areViewsConsistent(view, newView, expTotalFileSlicesPerPartition * (long)this.partitions.size());
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
    }

    private void performClean(String instant, List<String> files, String cleanInstant) throws IOException {
        Map<String, List<String>> partititonToFiles = this.deleteFiles(files);
        List cleanStats = partititonToFiles.entrySet().stream().map(e -> new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (String)e.getKey(), (List)e.getValue(), (List)e.getValue(), new ArrayList(), Integer.toString(Integer.parseInt(instant) + 1))).collect(Collectors.toList());
        HoodieInstant cleanInflightInstant = new HoodieInstant(true, "clean", cleanInstant);
        this.metaClient.getActiveTimeline().createNewInstant(cleanInflightInstant);
        HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)cleanInstant, (Option)Option.empty(), cleanStats);
        this.metaClient.getActiveTimeline().saveAsComplete(cleanInflightInstant, TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)cleanMetadata));
    }

    private void performRestore(HoodieInstant instant, List<String> files, String rollbackInstant, boolean isRestore) throws IOException {
        Map<String, List<String>> partititonToFiles = this.deleteFiles(files);
        List rollbackStats = partititonToFiles.entrySet().stream().map(e -> new HoodieRollbackStat((String)e.getKey(), (List)e.getValue(), new ArrayList(), new HashMap(), new HashMap())).collect(Collectors.toList());
        ArrayList<HoodieInstant> rollbacks = new ArrayList<HoodieInstant>();
        rollbacks.add(instant);
        HoodieRollbackMetadata rollbackMetadata = TimelineMetadataUtils.convertRollbackMetadata((String)rollbackInstant, (Option)Option.empty(), rollbacks, rollbackStats);
        if (isRestore) {
            ArrayList<HoodieRollbackMetadata> rollbackM = new ArrayList<HoodieRollbackMetadata>();
            rollbackM.add(rollbackMetadata);
            HoodieRestoreMetadata metadata = TimelineMetadataUtils.convertRestoreMetadata((String)rollbackInstant, (long)100L, Collections.singletonList(instant), (Map)CollectionUtils.createImmutableMap((Object)rollbackInstant, rollbackM));
            HoodieInstant restoreInstant = new HoodieInstant(true, "restore", rollbackInstant);
            this.metaClient.getActiveTimeline().createNewInstant(restoreInstant);
            this.metaClient.getActiveTimeline().saveAsComplete(restoreInstant, TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)metadata));
        } else {
            this.metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(true, "rollback", rollbackInstant));
            this.metaClient.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "rollback", rollbackInstant), TimelineMetadataUtils.serializeRollbackMetadata((HoodieRollbackMetadata)rollbackMetadata));
        }
        boolean deleted = this.metaClient.getFs().delete(new Path(this.metaClient.getMetaPath(), instant.getFileName()), false);
        Assertions.assertTrue((boolean)deleted);
    }

    private Map<String, List<String>> deleteFiles(List<String> files) {
        if (null == files) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> partititonToFiles = new HashMap<String, List<String>>();
        this.partitions.forEach(p -> {
            List cfr_ignored_0 = partititonToFiles.put((String)p, new ArrayList());
        });
        for (String f : files) {
            String fullPath = String.format("%s/%s", this.metaClient.getBasePath(), f);
            new File(fullPath).delete();
            String partition = this.partitions.stream().filter(f::startsWith).findAny().get();
            ((List)partititonToFiles.get(partition)).add(fullPath);
        }
        return partititonToFiles;
    }

    private void scheduleCompaction(SyncableFileSystemView view, String instantTime) throws IOException {
        List slices = this.partitions.stream().flatMap(p -> view.getLatestFileSlices(p).map(s -> Pair.of((Object)p, (Object)s))).collect(Collectors.toList());
        long initialExpTotalFileSlices = this.partitions.stream().mapToLong(p -> view.getAllFileSlices(p).count()).sum();
        HoodieCompactionPlan plan = CompactionUtils.buildFromFileSlices(slices, (Option)Option.empty(), (Option)Option.empty());
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime);
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)plan));
        view.sync();
        this.partitions.forEach(p -> {
            view.getLatestFileSlices(p).forEach(fs -> {
                Assertions.assertEquals((Object)instantTime, (Object)fs.getBaseInstantTime());
                Assertions.assertEquals((Object)p, (Object)fs.getPartitionPath());
                Assertions.assertFalse((boolean)fs.getBaseFile().isPresent());
            });
            view.getLatestMergedFileSlicesBeforeOrOn(p, instantTime).forEach(fs -> {
                Assertions.assertTrue((boolean)HoodieTimeline.compareTimestamps((String)instantTime, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)fs.getBaseInstantTime()));
                Assertions.assertEquals((Object)p, (Object)fs.getPartitionPath());
            });
        });
        this.metaClient.reloadActiveTimeline();
        SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
        this.areViewsConsistent(view, newView, initialExpTotalFileSlices + (long)(this.partitions.size() * this.fileIdsPerPartition.size()));
    }

    private void unscheduleCompaction(SyncableFileSystemView view, String compactionInstantTime, String newLastInstant, String newBaseInstant) throws IOException {
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", compactionInstantTime);
        boolean deleted = this.metaClient.getFs().delete(new Path(this.metaClient.getMetaPath(), instant.getFileName()), false);
        ValidationUtils.checkArgument((boolean)deleted, (String)"Unable to delete compaction instant.");
        view.sync();
        Assertions.assertEquals((Object)newLastInstant, (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
        this.partitions.forEach(p -> view.getLatestFileSlices(p).forEach(fs -> Assertions.assertEquals((Object)newBaseInstant, (Object)fs.getBaseInstantTime())));
    }

    private Map<String, List<String>> testMultipleWriteSteps(SyncableFileSystemView view, List<String> instants, boolean deltaCommit, String baseInstantForDeltaCommit) throws IOException {
        return this.testMultipleWriteSteps(view, instants, deltaCommit, baseInstantForDeltaCommit, 1);
    }

    private Map<String, List<String>> testMultipleWriteSteps(SyncableFileSystemView view, List<String> instants, boolean deltaCommit, String baseInstantForDeltaCommit, int begin) throws IOException {
        return this.testMultipleWriteSteps(view, instants, deltaCommit, baseInstantForDeltaCommit, begin, instants.stream().map(i -> new HoodieInstant(HoodieInstant.State.COMPLETED, deltaCommit ? "deltacommit" : "commit", i)).collect(Collectors.toList()));
    }

    private Map<String, List<String>> testMultipleWriteSteps(SyncableFileSystemView view, List<String> instants) throws IOException {
        return this.testMultipleWriteSteps(view, instants, false, null, 1);
    }

    private Map<String, List<String>> testMultipleWriteSteps(SyncableFileSystemView view, List<String> instants, boolean deltaCommit, String baseInstantForDeltaCommit, int begin, List<HoodieInstant> lastInstants) throws IOException {
        HashMap<String, List<String>> instantToFiles = new HashMap<String, List<String>>();
        int multiple = begin;
        for (int idx = 0; idx < instants.size(); ++idx) {
            String instant = instants.get(idx);
            LOG.info((Object)("Adding instant=" + instant));
            HoodieInstant lastInstant = lastInstants.get(idx);
            List<String> filePaths = this.addInstant(this.metaClient, instant, deltaCommit, deltaCommit ? baseInstantForDeltaCommit : instant);
            view.sync();
            Assertions.assertTrue((boolean)view.getLastInstant().isPresent());
            Assertions.assertEquals((Object)lastInstant.getTimestamp(), (Object)((HoodieInstant)view.getLastInstant().get()).getTimestamp());
            Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)view.getLastInstant().get()).getState());
            Assertions.assertEquals((Object)lastInstant.getAction(), (Object)((HoodieInstant)view.getLastInstant().get()).getAction(), (String)("Expected Last=" + lastInstant + ", Found Instants=" + view.getTimeline().getInstants().collect(Collectors.toList())));
            this.partitions.forEach(p -> Assertions.assertEquals((long)this.fileIdsPerPartition.size(), (long)view.getLatestFileSlices(p).count()));
            long expTotalFileSlicesPerPartition = this.fileIdsPerPartition.size() * multiple;
            this.partitions.forEach(p -> Assertions.assertEquals((long)expTotalFileSlicesPerPartition, (long)view.getAllFileSlices(p).count()));
            if (deltaCommit) {
                this.partitions.forEach(p -> view.getLatestFileSlices(p).forEach(f -> Assertions.assertEquals((Object)baseInstantForDeltaCommit, (Object)f.getBaseInstantTime())));
            } else {
                this.partitions.forEach(p -> view.getLatestBaseFiles(p).forEach(f -> Assertions.assertEquals((Object)instant, (Object)f.getCommitTime())));
            }
            this.metaClient.reloadActiveTimeline();
            SyncableFileSystemView newView = this.getFileSystemView(this.metaClient);
            this.areViewsConsistent(view, newView, this.fileIdsPerPartition.size() * this.partitions.size() * multiple);
            instantToFiles.put(instant, filePaths);
            if (deltaCommit) continue;
            ++multiple;
        }
        return instantToFiles;
    }

    private void areViewsConsistent(SyncableFileSystemView view1, SyncableFileSystemView view2, long expectedTotalFileSlices) {
        Assertions.assertEquals((Object)view1.getLastInstant(), (Object)view2.getLastInstant());
        Map<HoodieFileGroupId, HoodieFileGroup> fileGroupsMap1 = this.partitions.stream().flatMap(arg_0 -> ((SyncableFileSystemView)view1).getAllFileGroups(arg_0)).collect(Collectors.toMap(HoodieFileGroup::getFileGroupId, fg -> fg));
        Map<HoodieFileGroupId, HoodieFileGroup> fileGroupsMap2 = this.partitions.stream().flatMap(arg_0 -> ((SyncableFileSystemView)view2).getAllFileGroups(arg_0)).collect(Collectors.toMap(HoodieFileGroup::getFileGroupId, fg -> fg));
        Assertions.assertEquals(fileGroupsMap1.keySet(), fileGroupsMap2.keySet());
        long gotSlicesCount = fileGroupsMap1.keySet().stream().map(k -> Pair.of(fileGroupsMap1.get(k), fileGroupsMap2.get(k))).mapToLong(e -> {
            HoodieFileGroup fg1 = (HoodieFileGroup)e.getKey();
            HoodieFileGroup fg2 = (HoodieFileGroup)e.getValue();
            Assertions.assertEquals((Object)fg1.getFileGroupId(), (Object)fg2.getFileGroupId());
            List slices1 = fg1.getAllRawFileSlices().collect(Collectors.toList());
            List slices2 = fg2.getAllRawFileSlices().collect(Collectors.toList());
            Assertions.assertEquals((int)slices1.size(), (int)slices2.size());
            IntStream.range(0, slices1.size()).mapToObj(idx -> Pair.of(slices1.get(idx), slices2.get(idx))).forEach(e2 -> {
                FileSlice slice1 = (FileSlice)e2.getKey();
                FileSlice slice2 = (FileSlice)e2.getValue();
                Assertions.assertEquals((Object)slice1.getBaseInstantTime(), (Object)slice2.getBaseInstantTime());
                Assertions.assertEquals((Object)slice1.getFileId(), (Object)slice2.getFileId());
                Assertions.assertEquals((Object)slice1.getBaseFile().isPresent(), (Object)slice2.getBaseFile().isPresent());
                if (slice1.getBaseFile().isPresent()) {
                    HoodieBaseFile df1 = (HoodieBaseFile)slice1.getBaseFile().get();
                    HoodieBaseFile df2 = (HoodieBaseFile)slice2.getBaseFile().get();
                    Assertions.assertEquals((Object)df1.getCommitTime(), (Object)df2.getCommitTime());
                    Assertions.assertEquals((Object)df1.getFileId(), (Object)df2.getFileId());
                    Assertions.assertEquals((Object)df1.getFileName(), (Object)df2.getFileName());
                    Assertions.assertEquals((Object)Path.getPathWithoutSchemeAndAuthority((Path)new Path(df1.getPath())), (Object)Path.getPathWithoutSchemeAndAuthority((Path)new Path(df2.getPath())));
                }
                List logPaths1 = slice1.getLogFiles().map(lf -> Path.getPathWithoutSchemeAndAuthority((Path)lf.getPath())).collect(Collectors.toList());
                List logPaths2 = slice2.getLogFiles().map(lf -> Path.getPathWithoutSchemeAndAuthority((Path)lf.getPath())).collect(Collectors.toList());
                Assertions.assertEquals(logPaths1, logPaths2);
            });
            return slices1.size();
        }).sum();
        Assertions.assertEquals((long)expectedTotalFileSlices, (long)gotSlicesCount);
        Set ops1 = view1.getPendingCompactionOperations().collect(Collectors.toSet());
        Set ops2 = view2.getPendingCompactionOperations().collect(Collectors.toSet());
        Assertions.assertEquals(ops1, ops2);
    }

    private List<Pair<String, HoodieWriteStat>> generateDataForInstant(String baseInstant, String instant, boolean deltaCommit) {
        return this.generateDataForInstant(baseInstant, instant, deltaCommit, this.fileIdsPerPartition);
    }

    private List<Pair<String, HoodieWriteStat>> generateDataForInstant(String baseInstant, String instant, boolean deltaCommit, List<String> fileIds) {
        return this.partitions.stream().flatMap(p -> fileIds.stream().map(f -> {
            try {
                File file = new File(this.basePath + "/" + p + "/" + (deltaCommit ? FSUtils.makeLogFileName((String)f, (String)".log", (String)baseInstant, (int)Integer.parseInt(instant), (String)TEST_WRITE_TOKEN) : FSUtils.makeDataFileName((String)instant, (String)TEST_WRITE_TOKEN, (String)f)));
                file.createNewFile();
                HoodieWriteStat w = new HoodieWriteStat();
                w.setFileId(f);
                w.setPath(String.format("%s/%s", p, file.getName()));
                return Pair.of((Object)p, (Object)w);
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        })).collect(Collectors.toList());
    }

    private List<String> addInstant(HoodieTableMetaClient metaClient, String instant, boolean deltaCommit, String baseInstant) throws IOException {
        List<Pair<String, HoodieWriteStat>> writeStats = this.generateDataForInstant(baseInstant, instant, deltaCommit);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        writeStats.forEach(e -> metadata.addWriteStat((String)e.getKey(), (HoodieWriteStat)e.getValue()));
        HoodieInstant inflightInstant = new HoodieInstant(true, deltaCommit ? "deltacommit" : "commit", instant);
        metaClient.getActiveTimeline().createNewInstant(inflightInstant);
        metaClient.getActiveTimeline().saveAsComplete(inflightInstant, Option.of((Object)metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        return writeStats.stream().map(e -> ((HoodieWriteStat)e.getValue()).getPath()).collect(Collectors.toList());
    }

    private List<String> addReplaceInstant(HoodieTableMetaClient metaClient, String instant, List<Pair<String, HoodieWriteStat>> writeStats, Map<String, List<String>> partitionToReplaceFileIds) throws IOException {
        HoodieInstant newRequestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", instant);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.UNKNOWN.name()).build();
        metaClient.getActiveTimeline().saveToPendingReplaceCommit(newRequestedInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
        metaClient.reloadActiveTimeline();
        HoodieInstant inflightInstant = metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(newRequestedInstant, Option.empty());
        HoodieReplaceCommitMetadata replaceCommitMetadata = new HoodieReplaceCommitMetadata();
        writeStats.forEach(e -> replaceCommitMetadata.addWriteStat((String)e.getKey(), (HoodieWriteStat)e.getValue()));
        replaceCommitMetadata.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
        metaClient.getActiveTimeline().saveAsComplete(inflightInstant, Option.of((Object)replaceCommitMetadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        return writeStats.stream().map(e -> ((HoodieWriteStat)e.getValue()).getPath()).collect(Collectors.toList());
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

