/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.http.client.HttpResponseException;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TestPriorityBasedFileSystemView {
    @Mock
    private SyncableFileSystemView primary;
    @Mock
    private SyncableFileSystemView secondary;
    @InjectMocks
    private PriorityBasedFileSystemView fsView;
    private Stream<HoodieBaseFile> testBaseFileStream;
    private Stream<FileSlice> testFileSliceStream;

    @BeforeEach
    public void setUp() {
        this.fsView = new PriorityBasedFileSystemView(this.primary, this.secondary);
        this.testBaseFileStream = Stream.of(new HoodieBaseFile("test"));
        this.testFileSliceStream = Stream.of(new FileSlice("2020-01-01", "20:20", "file0001" + ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
    }

    private void resetMocks() {
        Mockito.reset((Object[])new SyncableFileSystemView[]{this.primary, this.secondary});
    }

    @Test
    public void testGetLatestBaseFiles() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        Mockito.when((Object)this.primary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadRequestExceptionWithPrimary() {
        TestLogAppender appender = new TestLogAppender();
        Logger logger = Logger.getRootLogger();
        try {
            logger.addAppender((Appender)appender);
            Stream<HoodieBaseFile> expected = this.testBaseFileStream;
            this.resetMocks();
            Mockito.when((Object)this.primary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException((Throwable)new HttpResponseException(400, "Bad Request"))});
            Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
            Stream actual = this.fsView.getLatestBaseFiles();
            Assertions.assertEquals(expected, (Object)actual);
            List<LoggingEvent> logs = appender.getLog();
            LoggingEvent firstLogEntry = logs.get(0);
            Assertions.assertEquals((Object)firstLogEntry.getLevel(), (Object)Level.WARN);
            Assertions.assertTrue((boolean)((String)firstLogEntry.getMessage()).contains("Got error running preferred function. Likely due to another concurrent writer in progress. Trying secondary"));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    @Test
    public void testGetLatestBaseFilesWithPartitionPath() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFiles(partitionPath));
    }

    @Test
    public void testGetLatestBaseFilesBeforeOrOn() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        String maxCommitTime = "2010-10-10";
        Mockito.when((Object)this.primary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime));
    }

    @Test
    public void testGetLatestBaseFile() {
        Option expected = Option.of((Object)new HoodieBaseFile("test.file"));
        String partitionPath = "/table2";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestBaseFile(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFile(partitionPath, fileID));
    }

    @Test
    public void testGetBaseFileOn() {
        Option expected = Option.of((Object)new HoodieBaseFile("test.file"));
        String partitionPath = "/table2";
        String instantTime = "2020-01-01";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getBaseFileOn(partitionPath, instantTime, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getBaseFileOn(partitionPath, instantTime, fileID));
    }

    @Test
    public void testGetLatestBaseFilesInRange() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        List<String> commitsToReturn = Collections.singletonList("/table2");
        Mockito.when((Object)this.primary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestBaseFilesInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFilesInRange(commitsToReturn));
    }

    @Test
    public void testGetAllBaseFiles() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getAllBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllBaseFiles(partitionPath));
    }

    @Test
    public void testGetLatestFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlices(partitionPath));
    }

    @Test
    public void testGetLatestUnCompactedFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestUnCompactedFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestUnCompactedFileSlices(partitionPath));
    }

    @Test
    public void testGetLatestFileSlicesBeforeOrOn() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        String maxCommitTime = "2020-01-01";
        Mockito.when((Object)this.primary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false));
    }

    @Test
    public void testGetLatestMergedFileSlicesBeforeOrOn() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        String maxInstantTime = "2020-01-01";
        Mockito.when((Object)this.primary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime));
    }

    @Test
    public void testGetLatestFileSliceInRange() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        List<String> commitsToReturn = Collections.singletonList("/table2");
        Mockito.when((Object)this.primary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestFileSliceInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSliceInRange(commitsToReturn));
    }

    @Test
    public void testGetAllFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getAllFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllFileSlices(partitionPath));
    }

    @Test
    public void testGetAllFileGroups() {
        String partitionPath = "/table2";
        Stream expected = Collections.singleton(new HoodieFileGroup(partitionPath, "id1", (HoodieTimeline)new MockHoodieTimeline(Stream.empty(), Stream.empty()))).stream();
        Mockito.when((Object)this.primary.getAllFileGroups(partitionPath)).thenReturn(expected);
        Stream actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getAllFileGroups(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenReturn(expected);
        actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenReturn(expected);
        actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllFileGroups(partitionPath));
    }

    @Test
    public void testGetPendingCompactionOperations() {
        Stream expected = Collections.singleton(new ImmutablePair((Object)"test", (Object)new CompactionOperation())).stream();
        Mockito.when((Object)this.primary.getPendingCompactionOperations()).thenReturn(expected);
        Stream actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getPendingCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getPendingCompactionOperations());
    }

    @Test
    public void testClose() {
        this.fsView.close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testReset() {
        this.fsView.reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testGetLastInstant() {
        Option expected = Option.of((Object)new HoodieInstant(true, "", ""));
        Mockito.when((Object)this.primary.getLastInstant()).thenReturn((Object)expected);
        Option actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLastInstant()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLastInstant()).thenReturn((Object)expected);
        actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLastInstant()).thenReturn((Object)expected);
        actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLastInstant()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLastInstant());
    }

    @Test
    public void testGetTimeline() {
        MockHoodieTimeline expected = new MockHoodieTimeline(Stream.empty(), Stream.empty());
        Mockito.when((Object)this.primary.getTimeline()).thenReturn((Object)expected);
        HoodieTimeline actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getTimeline()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getTimeline()).thenReturn((Object)expected);
        actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getTimeline()).thenReturn((Object)expected);
        actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getTimeline()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getTimeline());
    }

    @Test
    public void testSync() {
        this.fsView.sync();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testGetLatestFileSlice() {
        Option expected = Option.fromJavaOptional(this.testFileSliceStream.findFirst());
        String partitionPath = "/table2";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.primary.getLatestFileSlice(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlice(partitionPath, fileID));
    }

    @Test
    public void testGetPreferredView() {
        Assertions.assertEquals((Object)this.primary, (Object)this.fsView.getPreferredView());
    }

    @Test
    public void testGetSecondaryView() {
        Assertions.assertEquals((Object)this.secondary, (Object)this.fsView.getSecondaryView());
    }

    class TestLogAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        TestLogAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }
}

