/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.CompactionTestUtils;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.exception.HoodieException;

public class ClusteringTestUtils {
    public static HoodieClusteringPlan createClusteringPlan(HoodieTableMetaClient metaClient, String instantTime, String fileId) {
        try {
            String basePath = metaClient.getBasePath();
            String partition = HoodieTestUtils.DEFAULT_PARTITION_PATHS[0];
            FileCreateUtils.createBaseFile(basePath, partition, instantTime, fileId, 1L);
            FileSlice slice = new FileSlice(partition, instantTime, fileId);
            slice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile(Paths.get(basePath, partition, FileCreateUtils.baseFileName(instantTime, fileId)).toString()));
            List[] fileSliceGroups = new List[]{Collections.singletonList(slice)};
            HoodieClusteringPlan clusteringPlan = ClusteringUtils.createClusteringPlan((String)"strategy", new HashMap(), (List[])fileSliceGroups, Collections.emptyMap());
            return clusteringPlan;
        }
        catch (Exception e) {
            throw new HoodieException(e.getMessage(), (Throwable)e);
        }
    }
}

