/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.common.fs.inline.InLineFSUtils;

public class FileSystemTestUtils {
    public static final String TEMP = "tmp";
    public static final String FORWARD_SLASH = "/";
    public static final String FILE_SCHEME = "file";
    public static final String COLON = ":";
    public static final Random RANDOM = new Random();

    public static Path getRandomOuterInMemPath() {
        String randomFileName = UUID.randomUUID().toString();
        String fileSuffix = ":/tmp/" + randomFileName;
        return new Path("inmemfs" + fileSuffix);
    }

    public static Path getRandomOuterFSPath() {
        String randomFileName = UUID.randomUUID().toString();
        String fileSuffix = ":/tmp/" + randomFileName;
        return new Path(FILE_SCHEME + fileSuffix);
    }

    public static Path getPhantomFile(Path outerPath, long startOffset, long inlineLength) {
        return InLineFSUtils.getInlineFilePath((Path)outerPath, (String)FILE_SCHEME, (long)startOffset, (long)inlineLength);
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        if (!fileToDelete.exists()) {
            return;
        }
        if (!fileToDelete.delete()) {
            String message = "Unable to delete file " + fileToDelete + ".";
            throw new IOException(message);
        }
    }

    public static List<FileStatus> listRecursive(FileSystem fs, Path path) throws IOException {
        return FileSystemTestUtils.listFiles(fs, path, true);
    }

    public static List<FileStatus> listFiles(FileSystem fs, Path path, boolean recursive) throws IOException {
        RemoteIterator itr = fs.listFiles(path, recursive);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            statuses.add((FileStatus)itr.next());
        }
        return statuses;
    }
}

