/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.junit.jupiter.api.io.TempDir;

public class HoodieCommonTestHarness {
    protected String tableName = null;
    protected String basePath = null;
    protected transient HoodieTestDataGenerator dataGen = null;
    protected transient HoodieTableMetaClient metaClient;
    @TempDir
    public Path tempDir;

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void initPath() {
        try {
            Path basePath = this.tempDir.resolve("dataset");
            Files.createDirectories(basePath, new FileAttribute[0]);
            this.basePath = basePath.toString();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    protected void initTestDataGenerator() {
        this.dataGen = new HoodieTestDataGenerator();
    }

    protected void cleanupTestDataGenerator() {
        if (this.dataGen != null) {
            this.dataGen = null;
        }
    }

    protected void initMetaClient() throws IOException {
        this.metaClient = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType());
        this.basePath = this.metaClient.getBasePath();
    }

    protected void refreshFsView() throws IOException {
        this.metaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, false);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTimeline timeline, boolean enableIncrementalTimelineSync) {
        return new HoodieTableFileSystemView(this.metaClient, timeline, enableIncrementalTimelineSync);
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) throws IOException {
        return this.getFileSystemView(metaClient, metaClient.getActiveTimeline().filterCompletedAndCompactionInstants());
    }

    protected SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline timeline) throws IOException {
        return this.getFileSystemView(timeline, true);
    }

    protected SyncableFileSystemView getFileSystemViewWithUnCommittedSlices(HoodieTableMetaClient metaClient) {
        try {
            return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), HoodieTestTable.of(metaClient).listAllBaseAndLogFiles());
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error getting file system view", ioe);
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.COPY_ON_WRITE;
    }
}

