/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTestTable {
    private static final Logger LOG = LogManager.getLogger(HoodieTestTable.class);
    private static final Random RANDOM = new Random();
    protected static HoodieTestTableState testTableState;
    private final List<String> inflightCommits = new ArrayList<String>();
    protected final String basePath;
    protected final FileSystem fs;
    protected HoodieTableMetaClient metaClient;
    protected String currentInstantTime;

    protected HoodieTestTable(String basePath, FileSystem fs, HoodieTableMetaClient metaClient) {
        ValidationUtils.checkArgument((boolean)Objects.equals(basePath, metaClient.getBasePath()));
        ValidationUtils.checkArgument((boolean)Objects.equals(fs, metaClient.getRawFs()));
        this.basePath = basePath;
        this.fs = fs;
        this.metaClient = metaClient;
        testTableState = HoodieTestTableState.of();
    }

    public static HoodieTestTable of(HoodieTableMetaClient metaClient) {
        testTableState = HoodieTestTableState.of();
        return new HoodieTestTable(metaClient.getBasePath(), metaClient.getRawFs(), metaClient);
    }

    public static String makeNewCommitTime(int sequence) {
        return String.format("%09d", sequence);
    }

    public static String makeNewCommitTime() {
        return HoodieTestTable.makeNewCommitTime(Instant.now());
    }

    public static String makeNewCommitTime(Instant dateTime) {
        return HoodieActiveTimeline.formatDate((Date)Date.from(dateTime));
    }

    public static List<String> makeIncrementalCommitTimes(int num) {
        return HoodieTestTable.makeIncrementalCommitTimes(num, 1);
    }

    public static List<String> makeIncrementalCommitTimes(int num, int firstOffsetSeconds) {
        return HoodieTestTable.makeIncrementalCommitTimes(num, firstOffsetSeconds, 0);
    }

    public static List<String> makeIncrementalCommitTimes(int num, int firstOffsetSeconds, int deltaSecs) {
        Instant now = Instant.now();
        return IntStream.range(0, num).mapToObj(i -> HoodieTestTable.makeNewCommitTime(now.plus(deltaSecs == 0 ? (long)(firstOffsetSeconds + i) : (long)(i == 0 ? firstOffsetSeconds : i * deltaSecs + i), ChronoUnit.SECONDS))).collect(Collectors.toList());
    }

    public HoodieTestTable addRequestedCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightCommit(this.basePath, instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightDeltaCommit(this.basePath, instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCommit(String instantTime) throws Exception {
        return this.addCommit(instantTime, (Option<HoodieCommitMetadata>)Option.empty());
    }

    public HoodieTestTable addCommit(String instantTime, Option<HoodieCommitMetadata> metadata) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightCommit(this.basePath, instantTime);
        FileCreateUtils.createCommit(this.basePath, instantTime, metadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, HoodieTestTableState testTableState) {
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)operationType, (HoodieTableType)this.metaClient.getTableType());
        return this.createCommitMetadata(operationType, commitTime, Collections.emptyMap(), testTableState, false, actionType);
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, HoodieTestTableState testTableState, boolean bootstrap) {
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)operationType, (HoodieTableType)this.metaClient.getTableType());
        return this.createCommitMetadata(operationType, commitTime, Collections.emptyMap(), testTableState, bootstrap, actionType);
    }

    public HoodieCommitMetadata createCommitMetadata(WriteOperationType operationType, String commitTime, Map<String, List<String>> partitionToReplaceFileIds, HoodieTestTableState testTableState, boolean bootstrap, String action) {
        List<HoodieWriteStat> writeStats = HoodieTestTable.generateHoodieWriteStatForPartition(testTableState.getPartitionToBaseFileInfoMap(commitTime), commitTime, bootstrap);
        if (HoodieTableType.MERGE_ON_READ.equals((Object)this.metaClient.getTableType()) && WriteOperationType.UPSERT.equals((Object)operationType)) {
            writeStats.addAll(HoodieTestTable.generateHoodieWriteStatForPartitionLogFiles(testTableState.getPartitionToLogFileInfoMap(commitTime), commitTime, bootstrap));
        }
        Map extraMetadata = CollectionUtils.createImmutableMap((Object)"test", (Object)"test");
        return CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.of((Object)extraMetadata), (WriteOperationType)operationType, (String)"", (String)action);
    }

    public HoodieTestTable moveInflightCommitToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            FileCreateUtils.createCommit(this.basePath, instantTime, (Option<HoodieCommitMetadata>)Option.of((Object)metadata));
        } else {
            FileCreateUtils.createDeltaCommit(this.basePath, instantTime, metadata);
        }
        this.inflightCommits.remove(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createDeltaCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addDeltaCommit(String instantTime, HoodieCommitMetadata metadata) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createDeltaCommit(this.basePath, instantTime, metadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addReplaceCommit(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata, Option<HoodieCommitMetadata> inflightReplaceMetadata, HoodieReplaceCommitMetadata completeReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit(this.basePath, instantTime, requestedReplaceMetadata);
        FileCreateUtils.createInflightReplaceCommit(this.basePath, instantTime, inflightReplaceMetadata);
        FileCreateUtils.createReplaceCommit(this.basePath, instantTime, completeReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedReplace(String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit(this.basePath, instantTime, requestedReplaceMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addInflightClean(String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createRequestedCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createInflightCleanFile(this.basePath, instantTime, cleanerPlan);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addClean(String instantTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata metadata) throws IOException {
        FileCreateUtils.createRequestedCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createInflightCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createCleanFile(this.basePath, instantTime, metadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addClean(String instantTime) throws IOException {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap());
        HoodieCleanStat cleanStats = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, HoodieTestUtils.DEFAULT_PARTITION_PATHS[RANDOM.nextInt(HoodieTestUtils.DEFAULT_PARTITION_PATHS.length)], Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), instantTime);
        HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)instantTime, (Option)Option.of((Object)0L), Collections.singletonList(cleanStats));
        return HoodieTestTable.of(this.metaClient).addClean(instantTime, cleanerPlan, cleanMetadata);
    }

    public Pair<HoodieCleanerPlan, HoodieCleanMetadata> getHoodieCleanMetadata(String commitTime, HoodieTestTableState testTableState) {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant(commitTime, "clean", ""), "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap());
        ArrayList<HoodieCleanStat> cleanStats = new ArrayList<HoodieCleanStat>();
        for (Map.Entry<String, List<String>> entry : testTableState.getPartitionToFileIdMapForCleaner(commitTime).entrySet()) {
            cleanStats.add(new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, entry.getKey(), entry.getValue(), entry.getValue(), Collections.emptyList(), commitTime));
        }
        return Pair.of((Object)cleanerPlan, (Object)CleanerUtils.convertCleanMetadata((String)commitTime, (Option)Option.of((Object)0L), cleanStats));
    }

    public HoodieTestTable addInflightRollback(String instantTime) throws IOException {
        FileCreateUtils.createInflightRollbackFile(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRollback(String instantTime, HoodieRollbackMetadata rollbackMetadata) throws IOException {
        FileCreateUtils.createInflightRollbackFile(this.basePath, instantTime);
        FileCreateUtils.createRollbackFile(this.basePath, instantTime, rollbackMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRestore(String instantTime, HoodieRestoreMetadata restoreMetadata) throws IOException {
        FileCreateUtils.createRestoreFile(this.basePath, instantTime, restoreMetadata);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieRollbackMetadata getRollbackMetadata(String instantTimeToDelete, Map<String, List<String>> partitionToFilesMeta) throws Exception {
        HoodieRollbackMetadata rollbackMetadata = new HoodieRollbackMetadata();
        rollbackMetadata.setCommitsRollback(Collections.singletonList(instantTimeToDelete));
        rollbackMetadata.setStartRollbackTime(instantTimeToDelete);
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieRollbackPartitionMetadata>();
        for (Map.Entry<String, List<String>> entry : partitionToFilesMeta.entrySet()) {
            HoodieRollbackPartitionMetadata rollbackPartitionMetadata = new HoodieRollbackPartitionMetadata();
            rollbackPartitionMetadata.setPartitionPath(entry.getKey());
            rollbackPartitionMetadata.setSuccessDeleteFiles(entry.getValue());
            rollbackPartitionMetadata.setFailedDeleteFiles(new ArrayList());
            rollbackPartitionMetadata.setWrittenLogFiles(this.getWrittenLogFiles(instantTimeToDelete, entry));
            long rollbackLogFileSize = 50 + RANDOM.nextInt(500);
            String fileId = UUID.randomUUID().toString();
            String logFileName = FileCreateUtils.logFileName(instantTimeToDelete, fileId, 0);
            FileCreateUtils.createLogFile(this.basePath, entry.getKey(), instantTimeToDelete, fileId, 0, (int)rollbackLogFileSize);
            rollbackPartitionMetadata.setRollbackLogFiles(CollectionUtils.createImmutableMap((Object)logFileName, (Object)rollbackLogFileSize));
            partitionMetadataMap.put(entry.getKey(), rollbackPartitionMetadata);
        }
        rollbackMetadata.setPartitionMetadata(partitionMetadataMap);
        rollbackMetadata.setInstantsRollback(Collections.singletonList(new HoodieInstantInfo(instantTimeToDelete, "rollback")));
        return rollbackMetadata;
    }

    private Map<String, Long> getWrittenLogFiles(String instant, Map.Entry<String, List<String>> entry) {
        HashMap<String, Long> writtenLogFiles = new HashMap<String, Long>();
        for (String fileName : entry.getValue()) {
            if (!FSUtils.isLogFile((Path)new Path(fileName)) || testTableState.getPartitionToLogFileInfoMap(instant) == null || !testTableState.getPartitionToLogFileInfoMap(instant).containsKey(entry.getKey())) continue;
            List<Pair<String, Integer[]>> fileInfos = testTableState.getPartitionToLogFileInfoMap(instant).get(entry.getKey());
            for (Pair<String, Integer[]> fileInfo : fileInfos) {
                if (!fileName.equals(FileCreateUtils.logFileName(instant, (String)fileInfo.getLeft(), ((Integer[])fileInfo.getRight())[0]))) continue;
                writtenLogFiles.put(fileName, (long)((Integer[])fileInfo.getRight())[1]);
            }
        }
        return writtenLogFiles;
    }

    public HoodieSavepointMetadata getSavepointMetadata(String instant, Map<String, List<String>> partitionToFilesMeta) {
        HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata();
        savepointMetadata.setSavepointedAt(Long.valueOf(instant));
        HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieSavepointPartitionMetadata>();
        for (Map.Entry<String, List<String>> entry : partitionToFilesMeta.entrySet()) {
            HoodieSavepointPartitionMetadata savepointPartitionMetadata = new HoodieSavepointPartitionMetadata();
            savepointPartitionMetadata.setPartitionPath(entry.getKey());
            savepointPartitionMetadata.setSavepointDataFile(entry.getValue());
            partitionMetadataMap.put(entry.getKey(), savepointPartitionMetadata);
        }
        savepointMetadata.setPartitionMetadata(partitionMetadataMap);
        savepointMetadata.setSavepointedBy("test");
        return savepointMetadata;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime) throws IOException {
        FileCreateUtils.createRequestedCompaction(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, HoodieCompactionPlan compactionPlan) throws IOException {
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime);
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        return this.addRequestedCompaction(instantTime);
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, FileSlice ... fileSlices) throws IOException {
        HoodieCompactionPlan plan = CompactionUtils.buildFromFileSlices(Arrays.stream(fileSlices).map(fs -> Pair.of((Object)fs.getPartitionPath(), (Object)fs)).collect(Collectors.toList()), (Option)Option.empty(), (Option)Option.empty());
        return this.addRequestedCompaction(instantTime, plan);
    }

    public HoodieTestTable addInflightCompaction(String instantTime, HoodieCommitMetadata commitMetadata) throws Exception {
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        for (Map.Entry entry : commitMetadata.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : (List)entry.getValue()) {
                fileSlices.add(new FileSlice((String)entry.getKey(), instantTime, stat.getPath()));
            }
        }
        this.addRequestedCompaction(instantTime, fileSlices.toArray(new FileSlice[0]));
        FileCreateUtils.createInflightCompaction(this.basePath, instantTime);
        this.inflightCommits.add(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable addCompaction(String instantTime, HoodieCommitMetadata commitMetadata) throws Exception {
        FileCreateUtils.createRequestedCompaction(this.basePath, instantTime);
        FileCreateUtils.createInflightCompaction(this.basePath, instantTime);
        return this.addCommit(instantTime, (Option<HoodieCommitMetadata>)Option.of((Object)commitMetadata));
    }

    public HoodieTestTable moveInflightCompactionToComplete(String instantTime, HoodieCommitMetadata metadata) throws IOException {
        FileCreateUtils.createCommit(this.basePath, instantTime, (Option<HoodieCommitMetadata>)Option.of((Object)metadata));
        this.inflightCommits.remove(instantTime);
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forDeltaCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forReplaceCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable withPartitionMetaFiles(String ... partitionPaths) throws IOException {
        for (String partitionPath : partitionPaths) {
            FileCreateUtils.createPartitionMetaFile(this.basePath, partitionPath);
        }
        return this;
    }

    public HoodieTestTable withMarkerFile(String partitionPath, String fileId, IOType ioType) throws IOException {
        FileCreateUtils.createMarkerFile(this.basePath, partitionPath, this.currentInstantTime, fileId, ioType);
        return this;
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, int num, IOType ioType) throws IOException {
        String[] fileIds = (String[])IntStream.range(0, num).mapToObj(i -> UUID.randomUUID().toString()).toArray(String[]::new);
        return this.withMarkerFiles(partitionPath, fileIds, ioType);
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, String[] fileIds, IOType ioType) throws IOException {
        for (String fileId : fileIds) {
            FileCreateUtils.createMarkerFile(this.basePath, partitionPath, this.currentInstantTime, fileId, ioType);
        }
        return this;
    }

    public Map<String, String> getFileIdsWithBaseFilesInPartitions(String ... partitions) throws Exception {
        HashMap<String, String> partitionFileIdMap = new HashMap<String, String>();
        for (String p : partitions) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile(this.basePath, p, this.currentInstantTime, fileId);
            partitionFileIdMap.put(p, fileId);
        }
        return partitionFileIdMap;
    }

    public HoodieTestTable withBaseFilesInPartitions(Map<String, String> partitionAndFileId) throws Exception {
        for (Map.Entry<String, String> pair : partitionAndFileId.entrySet()) {
            this.withBaseFilesInPartition(pair.getKey(), pair.getValue());
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, String ... fileIds) throws Exception {
        for (String f : fileIds) {
            FileCreateUtils.createBaseFile(this.basePath, partition, this.currentInstantTime, f);
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, int ... lengths) throws Exception {
        for (int l : lengths) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile(this.basePath, partition, this.currentInstantTime, fileId, l);
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, List<Pair<String, Integer>> fileInfos) throws Exception {
        for (Pair<String, Integer> fileInfo : fileInfos) {
            FileCreateUtils.createBaseFile(this.basePath, partition, this.currentInstantTime, (String)fileInfo.getKey(), ((Integer)fileInfo.getValue()).intValue());
        }
        return this;
    }

    public String getFileIdWithLogFile(String partitionPath) throws Exception {
        String fileId = UUID.randomUUID().toString();
        this.withLogFile(partitionPath, fileId);
        return fileId;
    }

    public HoodieTestTable withLogFile(String partitionPath, String fileId) throws Exception {
        return this.withLogFile(partitionPath, fileId, 0);
    }

    public HoodieTestTable withLogFile(String partitionPath, String fileId, int ... versions) throws Exception {
        for (int version : versions) {
            FileCreateUtils.createLogFile(this.basePath, partitionPath, this.currentInstantTime, fileId, version);
        }
        return this;
    }

    public HoodieTestTable withLogFilesInPartition(String partition, List<Pair<String, Integer[]>> fileInfos) throws Exception {
        for (Pair<String, Integer[]> fileInfo : fileInfos) {
            FileCreateUtils.createLogFile(this.basePath, partition, this.currentInstantTime, (String)fileInfo.getKey(), ((Integer[])fileInfo.getValue())[0], ((Integer[])fileInfo.getValue())[1]);
        }
        return this;
    }

    public boolean inflightCommitExists(String instantTime) {
        try {
            return this.fs.exists(this.getInflightCommitFilePath(instantTime));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean commitExists(String instantTime) {
        try {
            return this.fs.exists(this.getCommitFilePath(instantTime));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean baseFilesExist(Map<String, String> partitionAndFileId, String instantTime) {
        return partitionAndFileId.entrySet().stream().allMatch(entry -> {
            String partition = (String)entry.getKey();
            String fileId = (String)entry.getValue();
            return this.baseFileExists(partition, instantTime, fileId);
        });
    }

    public boolean baseFileExists(String partition, String instantTime, String fileId) {
        try {
            return this.fs.exists(new Path(Paths.get(this.basePath, partition, FileCreateUtils.baseFileName(instantTime, fileId)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean logFilesExist(String partition, String instantTime, String fileId, int ... versions) {
        return Arrays.stream(versions).allMatch(v -> this.logFileExists(partition, instantTime, fileId, v));
    }

    public boolean logFileExists(String partition, String instantTime, String fileId, int version) {
        try {
            return this.fs.exists(new Path(Paths.get(this.basePath, partition, FileCreateUtils.logFileName(instantTime, fileId, version)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public Path getInflightCommitFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, ".hoodie", instantTime + ".inflight").toUri());
    }

    public Path getCommitFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, ".hoodie", instantTime + ".commit").toUri());
    }

    public Path getRequestedCompactionFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, ".hoodie/.aux", instantTime + HoodieTimeline.REQUESTED_COMPACTION_EXTENSION).toUri());
    }

    public Path getPartitionPath(String partition) {
        return new Path(Paths.get(this.basePath, partition).toUri());
    }

    public List<java.nio.file.Path> getAllPartitionPaths() throws IOException {
        java.nio.file.Path basePathPath = Paths.get(this.basePath, ".hoodie/.temp").getParent().getParent();
        return FileCreateUtils.getPartitionPaths(basePathPath);
    }

    public Path getBaseFilePath(String partition, String fileId) {
        return new Path(Paths.get(this.basePath, partition, this.getBaseFileNameById(fileId)).toUri());
    }

    public String getBaseFileNameById(String fileId) {
        return FileCreateUtils.baseFileName(this.currentInstantTime, fileId);
    }

    public Path getLogFilePath(String partition, String fileId, int version) {
        return new Path(Paths.get(this.basePath, partition, this.getLogFileNameById(fileId, version)).toString());
    }

    public String getLogFileNameById(String fileId, int version) {
        return FileCreateUtils.logFileName(this.currentInstantTime, fileId, version);
    }

    public List<String> getEarliestFilesInPartition(String partition, int count) throws IOException {
        List<FileStatus> fileStatuses = Arrays.asList(this.listAllFilesInPartition(partition));
        fileStatuses.sort(Comparator.comparing(FileStatus::getModificationTime));
        return fileStatuses.subList(0, count).stream().map(entry -> entry.getPath().getName()).collect(Collectors.toList());
    }

    public List<String> inflightCommits() {
        return this.inflightCommits;
    }

    public FileStatus[] listAllBaseFiles() throws IOException {
        return this.listAllBaseFiles(((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
    }

    public FileStatus[] listAllBaseFiles(String fileExtension) throws IOException {
        return (FileStatus[])FileSystemTestUtils.listRecursive(this.fs, new Path(this.basePath)).stream().filter(status -> status.getPath().getName().endsWith(fileExtension)).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllLogFiles() throws IOException {
        return this.listAllLogFiles(HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public FileStatus[] listAllLogFiles(String fileExtension) throws IOException {
        return (FileStatus[])FileSystemTestUtils.listRecursive(this.fs, new Path(this.basePath)).stream().filter(status -> status.getPath().getName().contains(fileExtension)).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllBaseAndLogFiles() throws IOException {
        return (FileStatus[])Stream.concat(Stream.of(this.listAllBaseFiles()), Stream.of(this.listAllLogFiles())).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllFilesInPartition(String partitionPath) throws IOException {
        return (FileStatus[])FileSystemTestUtils.listRecursive(this.fs, new Path(Paths.get(this.basePath, partitionPath).toString())).stream().filter(entry -> {
            boolean toReturn = true;
            String fileName = entry.getPath().getName();
            if (fileName.equals(".hoodie_partition_metadata")) {
                toReturn = false;
            } else {
                for (String inflight : this.inflightCommits) {
                    if (!fileName.contains(inflight)) continue;
                    toReturn = false;
                    break;
                }
            }
            return toReturn;
        }).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllFilesInTempFolder() throws IOException {
        return FileSystemTestUtils.listRecursive(this.fs, new Path(Paths.get(this.basePath, ".hoodie/.temp").toString())).toArray(new FileStatus[0]);
    }

    public void deleteFilesInPartition(String partitionPath, List<String> filesToDelete) throws IOException {
        FileStatus[] allFiles = this.listAllFilesInPartition(partitionPath);
        Arrays.stream(allFiles).filter(entry -> filesToDelete.contains(entry.getPath().getName())).forEach(entry -> {
            try {
                Files.delete(Paths.get(this.basePath, partitionPath, entry.getPath().getName()));
            }
            catch (IOException e) {
                throw new HoodieTestTableException(e);
            }
        });
    }

    public HoodieTestTable doRollback(String commitTimeToRollback, String commitTime) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTimeToRollback);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTimeToRollback);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        HoodieRollbackMetadata rollbackMetadata = this.getRollbackMetadata(commitTimeToRollback, partitionFiles);
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        return this.addRollback(commitTime, rollbackMetadata);
    }

    public HoodieTestTable doRollbackWithExtraFiles(String commitTimeToRollback, String commitTime, Map<String, List<String>> extraFiles) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTimeToRollback);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTimeToRollback);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : extraFiles.entrySet()) {
            if (!partitionFiles.containsKey(entry.getKey())) continue;
            partitionFiles.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
        HoodieRollbackMetadata rollbackMetadata = this.getRollbackMetadata(commitTimeToRollback, partitionFiles);
        return this.addRollback(commitTime, rollbackMetadata);
    }

    public HoodieTestTable doRestore(String commitToRestoreTo, String restoreTime) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List commitsToRollback = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsAfter(commitToRestoreTo).getReverseOrderedInstants().collect(Collectors.toList());
        HashMap<String, List<HoodieRollbackMetadata>> rollbackMetadataMap = new HashMap<String, List<HoodieRollbackMetadata>>();
        for (HoodieInstant commitInstantToRollback : commitsToRollback) {
            Option<HoodieCommitMetadata> commitMetadata = this.getCommitMeta(commitInstantToRollback);
            if (!commitMetadata.isPresent()) {
                throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitInstantToRollback.getTimestamp());
            }
            Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
            rollbackMetadataMap.put(commitInstantToRollback.getTimestamp(), Collections.singletonList(this.getRollbackMetadata(commitInstantToRollback.getTimestamp(), partitionFiles)));
            for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
                this.deleteFilesInPartition(entry.getKey(), entry.getValue());
            }
        }
        HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.convertRestoreMetadata((String)restoreTime, (long)1000L, commitsToRollback, rollbackMetadataMap);
        return this.addRestore(restoreTime, restoreMetadata);
    }

    public HoodieReplaceCommitMetadata doCluster(String commitTime, Map<String, List<String>> partitionToReplaceFileIds, List<String> partitions, int filesPerPartition) throws Exception {
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(WriteOperationType.CLUSTER, this.metaClient.getTableType(), commitTime, partitions, filesPerPartition);
        this.currentInstantTime = commitTime;
        HashMap partitionToReplaceFileIdsWithLength = new HashMap();
        for (Map.Entry<String, List<String>> entry : partitionToReplaceFileIds.entrySet()) {
            String partition = entry.getKey();
            partitionToReplaceFileIdsWithLength.put(entry.getKey(), new ArrayList());
            for (String fileId : entry.getValue()) {
                int length = 100 + RANDOM.nextInt(500);
                ((List)partitionToReplaceFileIdsWithLength.get(partition)).add(Pair.of((Object)fileId, (Object)length));
            }
        }
        List<HoodieWriteStat> writeStats = HoodieTestTable.generateHoodieWriteStatForPartition(testTableState.getPartitionToBaseFileInfoMap(commitTime), commitTime, false);
        for (String partition : testTableState.getPartitionToBaseFileInfoMap(commitTime).keySet()) {
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
        }
        HoodieReplaceCommitMetadata hoodieReplaceCommitMetadata = (HoodieReplaceCommitMetadata)CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.CLUSTER, (String)"", (String)"replacecommit");
        this.addReplaceCommit(commitTime, (Option<HoodieRequestedReplaceMetadata>)Option.empty(), (Option<HoodieCommitMetadata>)Option.empty(), hoodieReplaceCommitMetadata);
        return hoodieReplaceCommitMetadata;
    }

    public HoodieCleanMetadata doClean(String commitTime, Map<String, Integer> partitionFileCountsToDelete) throws IOException {
        HashMap<String, List<String>> partitionFilesToDelete = new HashMap<String, List<String>>();
        for (Map.Entry<String, Integer> entry : partitionFileCountsToDelete.entrySet()) {
            partitionFilesToDelete.put(entry.getKey(), this.getEarliestFilesInPartition(entry.getKey(), entry.getValue()));
        }
        HoodieTestTableState testTableState = new HoodieTestTableState();
        for (Map.Entry entry : partitionFilesToDelete.entrySet()) {
            testTableState = testTableState.createTestTableStateForCleaner(commitTime, (String)entry.getKey(), (List)entry.getValue());
            this.deleteFilesInPartition((String)entry.getKey(), (List)entry.getValue());
        }
        Pair<HoodieCleanerPlan, HoodieCleanMetadata> pair = this.getHoodieCleanMetadata(commitTime, testTableState);
        this.addClean(commitTime, (HoodieCleanerPlan)pair.getKey(), (HoodieCleanMetadata)pair.getValue());
        return (HoodieCleanMetadata)pair.getValue();
    }

    public HoodieCleanMetadata doCleanBasedOnCommits(String cleanCommitTime, List<String> commitsToClean) throws IOException {
        HashMap<String, Integer> partitionFileCountsToDelete = new HashMap<String, Integer>();
        for (String commitTime : commitsToClean) {
            Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTime);
            if (!commitMetadata.isPresent()) continue;
            Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
            for (String partition : partitionFiles.keySet()) {
                partitionFileCountsToDelete.put(partition, partitionFiles.get(partition).size() + partitionFileCountsToDelete.getOrDefault(partition, 0));
            }
        }
        return this.doClean(cleanCommitTime, partitionFileCountsToDelete);
    }

    public HoodieSavepointMetadata doSavepoint(String commitTime) throws IOException {
        Option<HoodieCommitMetadata> commitMetadata = this.getMetadataForInstant(commitTime);
        if (!commitMetadata.isPresent()) {
            throw new IllegalArgumentException("Instant to rollback not present in timeline: " + commitTime);
        }
        Map<String, List<String>> partitionFiles = HoodieTestTable.getPartitionFiles((HoodieCommitMetadata)commitMetadata.get());
        HoodieSavepointMetadata savepointMetadata = this.getSavepointMetadata(commitTime, partitionFiles);
        for (Map.Entry<String, List<String>> entry : partitionFiles.entrySet()) {
            this.deleteFilesInPartition(entry.getKey(), entry.getValue());
        }
        return savepointMetadata;
    }

    public HoodieCommitMetadata doCompaction(String commitTime, List<String> partitions) throws Exception {
        return this.doCompaction(commitTime, partitions, false);
    }

    public HoodieCommitMetadata doCompaction(String commitTime, List<String> partitions, boolean inflight) throws Exception {
        this.currentInstantTime = commitTime;
        if (partitions.isEmpty()) {
            partitions = Collections.singletonList("");
        }
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(WriteOperationType.COMPACT, this.metaClient.getTableType(), commitTime, partitions, 1);
        HoodieCommitMetadata commitMetadata = this.createCommitMetadata(WriteOperationType.COMPACT, commitTime, testTableState);
        for (String partition : partitions) {
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
        }
        if (inflight) {
            this.addInflightCompaction(commitTime, commitMetadata);
        } else {
            this.addCompaction(commitTime, commitMetadata);
        }
        return commitMetadata;
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> partitions, int filesPerPartition) throws Exception {
        return this.doWriteOperation(commitTime, operationType, Collections.emptyList(), partitions, filesPerPartition, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition) throws Exception {
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitions, filesPerPartition, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition, boolean bootstrap) throws Exception {
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitions, filesPerPartition, bootstrap, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> partitions, int filesPerPartition, boolean bootstrap) throws Exception {
        return this.doWriteOperation(commitTime, operationType, Collections.emptyList(), partitions, filesPerPartition, bootstrap, false);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, List<String> partitions, int filesPerPartition, boolean bootstrap, boolean createInflightCommit) throws Exception {
        if (partitions.isEmpty()) {
            partitions = Collections.singletonList("");
        }
        Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = HoodieTestTable.getPartitionFiles(partitions, filesPerPartition);
        return this.doWriteOperation(commitTime, operationType, newPartitionsToAdd, partitionToFilesNameLengthMap, bootstrap, createInflightCommit);
    }

    public HoodieCommitMetadata doWriteOperation(String commitTime, WriteOperationType operationType, List<String> newPartitionsToAdd, Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap, boolean bootstrap, boolean createInflightCommit) throws Exception {
        if (partitionToFilesNameLengthMap.isEmpty()) {
            partitionToFilesNameLengthMap = Collections.singletonMap("", Collections.EMPTY_LIST);
        }
        HoodieTestTableState testTableState = HoodieTestTable.getTestTableStateWithPartitionFileInfo(operationType, this.metaClient.getTableType(), commitTime, partitionToFilesNameLengthMap);
        HoodieCommitMetadata commitMetadata = this.createCommitMetadata(operationType, commitTime, testTableState, bootstrap);
        for (String string : newPartitionsToAdd) {
            this.withPartitionMetaFiles(string);
        }
        if (createInflightCommit) {
            if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
                this.addInflightCommit(commitTime);
            } else {
                this.addInflightDeltaCommit(commitTime);
            }
        } else if (this.metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            this.addCommit(commitTime, (Option<HoodieCommitMetadata>)Option.of((Object)commitMetadata));
        } else {
            this.addDeltaCommit(commitTime, commitMetadata);
        }
        for (Map.Entry entry : partitionToFilesNameLengthMap.entrySet()) {
            String partition = (String)entry.getKey();
            this.withBaseFilesInPartition(partition, testTableState.getPartitionToBaseFileInfoMap(commitTime).get(partition));
            if (!HoodieTableType.MERGE_ON_READ.equals((Object)this.metaClient.getTableType()) || !WriteOperationType.UPSERT.equals((Object)operationType)) continue;
            this.withLogFilesInPartition(partition, testTableState.getPartitionToLogFileInfoMap(commitTime).get(partition));
        }
        return commitMetadata;
    }

    private Option<HoodieCommitMetadata> getMetadataForInstant(String instantTime) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Option hoodieInstant = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().filter(i -> i.getTimestamp().equals(instantTime)).firstInstant();
        try {
            if (hoodieInstant.isPresent()) {
                return this.getCommitMeta((HoodieInstant)hoodieInstant.get());
            }
            return Option.empty();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read metadata for instant " + hoodieInstant.get(), io);
        }
    }

    private Option<HoodieCommitMetadata> getCommitMeta(HoodieInstant hoodieInstant) throws IOException {
        switch (hoodieInstant.getAction()) {
            case "replacecommit": {
                HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])this.metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieReplaceCommitMetadata.class);
                return Option.of((Object)replaceCommitMetadata);
            }
            case "deltacommit": 
            case "commit": {
                HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])this.metaClient.getActiveTimeline().getInstantDetails(hoodieInstant).get()), HoodieCommitMetadata.class);
                return Option.of((Object)commitMetadata);
            }
        }
        throw new IllegalArgumentException("Unknown instant action" + hoodieInstant.getAction());
    }

    private static Map<String, List<String>> getPartitionFiles(HoodieCommitMetadata commitMetadata) {
        HashMap<String, List<String>> partitionFilesToDelete = new HashMap<String, List<String>>();
        Map partitionToWriteStats = commitMetadata.getPartitionToWriteStats();
        for (Map.Entry entry : partitionToWriteStats.entrySet()) {
            partitionFilesToDelete.put((String)entry.getKey(), new ArrayList());
            ((List)entry.getValue()).forEach(writeStat -> ((List)partitionFilesToDelete.get(entry.getKey())).add(writeStat.getFileId()));
        }
        return partitionFilesToDelete;
    }

    protected static Map<String, List<Pair<String, Integer>>> getPartitionFiles(List<String> partitions, int filesPerPartition) {
        HashMap<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = new HashMap<String, List<Pair<String, Integer>>>();
        for (String partition : partitions) {
            Stream<Integer> fileLengths = IntStream.range(0, filesPerPartition).map(i -> 100 + RANDOM.nextInt(500)).boxed();
            List fileNameAndLengthList = fileLengths.map(len -> Pair.of((Object)UUID.randomUUID().toString(), (Object)len)).collect(Collectors.toList());
            partitionToFilesNameLengthMap.put(partition, fileNameAndLengthList);
        }
        return partitionToFilesNameLengthMap;
    }

    private static HoodieTestTableState getTestTableStateWithPartitionFileInfo(WriteOperationType operationType, HoodieTableType tableType, String commitTime, List<String> partitions, int filesPerPartition) {
        Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap = HoodieTestTable.getPartitionFiles(partitions, filesPerPartition);
        return HoodieTestTable.getTestTableStateWithPartitionFileInfo(operationType, tableType, commitTime, partitionToFilesNameLengthMap);
    }

    private static HoodieTestTableState getTestTableStateWithPartitionFileInfo(WriteOperationType operationType, HoodieTableType tableType, String commitTime, Map<String, List<Pair<String, Integer>>> partitionToFilesNameLengthMap) {
        for (Map.Entry<String, List<Pair<String, Integer>>> partitionEntry : partitionToFilesNameLengthMap.entrySet()) {
            String partitionName = partitionEntry.getKey();
            List<Pair<String, Integer>> fileNameAndLengthList = partitionEntry.getValue();
            if (HoodieTableType.MERGE_ON_READ.equals((Object)tableType) && WriteOperationType.UPSERT.equals((Object)operationType)) {
                List<Pair<Integer, Integer>> fileVersionAndLength = fileNameAndLengthList.stream().map(nameLengthPair -> Pair.of((Object)0, (Object)nameLengthPair.getRight())).collect(Collectors.toList());
                testTableState = testTableState.createTestTableStateForBaseAndLogFiles(commitTime, partitionName, fileVersionAndLength);
                continue;
            }
            testTableState = testTableState.createTestTableStateForBaseFilesOnly(commitTime, partitionName, fileNameAndLengthList);
        }
        return testTableState;
    }

    private static List<HoodieWriteStat> generateHoodieWriteStatForPartition(Map<String, List<Pair<String, Integer>>> partitionToFileIdMap, String commitTime, boolean bootstrap) {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        for (Map.Entry<String, List<Pair<String, Integer>>> entry : partitionToFileIdMap.entrySet()) {
            String partition = entry.getKey();
            for (Pair<String, Integer> fileIdInfo : entry.getValue()) {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                String fileName = bootstrap ? (String)fileIdInfo.getKey() : FileCreateUtils.baseFileName(commitTime, (String)fileIdInfo.getKey());
                writeStat.setFileId(fileName);
                writeStat.setPartitionPath(partition);
                writeStat.setPath(partition + "/" + fileName);
                writeStat.setTotalWriteBytes((long)((Integer)fileIdInfo.getValue()).intValue());
                writeStats.add(writeStat);
            }
        }
        return writeStats;
    }

    private static List<HoodieWriteStat> generateHoodieWriteStatForPartitionLogFiles(Map<String, List<Pair<String, Integer[]>>> partitionToFileIdMap, String commitTime, boolean bootstrap) {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        if (partitionToFileIdMap == null) {
            return writeStats;
        }
        for (Map.Entry<String, List<Pair<String, Integer[]>>> entry : partitionToFileIdMap.entrySet()) {
            String partition = entry.getKey();
            for (Pair<String, Integer[]> fileIdInfo : entry.getValue()) {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                String fileName = bootstrap ? (String)fileIdInfo.getKey() : FileCreateUtils.logFileName(commitTime, (String)fileIdInfo.getKey(), ((Integer[])fileIdInfo.getValue())[0]);
                writeStat.setFileId(fileName);
                writeStat.setPartitionPath(partition);
                writeStat.setPath(partition + "/" + fileName);
                writeStat.setTotalWriteBytes((long)((Integer[])fileIdInfo.getValue())[1].intValue());
                writeStats.add(writeStat);
            }
        }
        return writeStats;
    }

    static class HoodieTestTableState {
        Map<String, Map<String, List<String>>> commitsToPartitionToFileIdForCleaner = new HashMap<String, Map<String, List<String>>>();
        Map<String, Map<String, List<Pair<String, Integer>>>> commitsToPartitionToBaseFileInfoStats = new HashMap<String, Map<String, List<Pair<String, Integer>>>>();
        Map<String, Map<String, List<Pair<String, Integer[]>>>> commitsToPartitionToLogFileInfoStats = new HashMap<String, Map<String, List<Pair<String, Integer[]>>>>();

        HoodieTestTableState() {
        }

        static HoodieTestTableState of() {
            return new HoodieTestTableState();
        }

        HoodieTestTableState createTestTableStateForCleaner(String commitTime, String partitionPath, List<String> filesToClean) {
            if (!this.commitsToPartitionToFileIdForCleaner.containsKey(commitTime)) {
                this.commitsToPartitionToFileIdForCleaner.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToFileIdForCleaner.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToFileIdForCleaner.get(commitTime).put(partitionPath, new ArrayList());
            }
            this.commitsToPartitionToFileIdForCleaner.get(commitTime).get(partitionPath).addAll(filesToClean);
            return this;
        }

        Map<String, List<String>> getPartitionToFileIdMapForCleaner(String commitTime) {
            return this.commitsToPartitionToFileIdForCleaner.get(commitTime);
        }

        HoodieTestTableState createTestTableStateForBaseFileLengthsOnly(String commitTime, String partitionPath, List<Integer> lengths) {
            ArrayList<Pair<String, Integer>> fileNameLengthList = new ArrayList<Pair<String, Integer>>();
            for (int length : lengths) {
                fileNameLengthList.add((Pair<String, Integer>)Pair.of((Object)UUID.randomUUID().toString(), (Object)length));
            }
            return this.createTestTableStateForBaseFilesOnly(commitTime, partitionPath, fileNameLengthList);
        }

        HoodieTestTableState createTestTableStateForBaseFilesOnly(String commitTime, String partitionPath, List<Pair<String, Integer>> fileNameAndLengthList) {
            if (!this.commitsToPartitionToBaseFileInfoStats.containsKey(commitTime)) {
                this.commitsToPartitionToBaseFileInfoStats.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToBaseFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToBaseFileInfoStats.get(commitTime).put(partitionPath, new ArrayList());
            }
            this.commitsToPartitionToBaseFileInfoStats.get(commitTime).get(partitionPath).addAll(fileNameAndLengthList);
            return this;
        }

        HoodieTestTableState createTestTableStateForBaseAndLogFiles(String commitTime, String partitionPath, List<Pair<Integer, Integer>> versionsAndLengths) {
            if (!this.commitsToPartitionToBaseFileInfoStats.containsKey(commitTime)) {
                this.createTestTableStateForBaseFileLengthsOnly(commitTime, partitionPath, versionsAndLengths.stream().map(Pair::getRight).collect(Collectors.toList()));
            }
            if (!this.commitsToPartitionToBaseFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.createTestTableStateForBaseFileLengthsOnly(commitTime, partitionPath, versionsAndLengths.stream().map(Pair::getRight).collect(Collectors.toList()));
            }
            if (!this.commitsToPartitionToLogFileInfoStats.containsKey(commitTime)) {
                this.commitsToPartitionToLogFileInfoStats.put(commitTime, new HashMap());
            }
            if (!this.commitsToPartitionToLogFileInfoStats.get(commitTime).containsKey(partitionPath)) {
                this.commitsToPartitionToLogFileInfoStats.get(commitTime).put(partitionPath, new ArrayList());
            }
            ArrayList<Pair> fileInfos = new ArrayList<Pair>();
            for (int i = 0; i < versionsAndLengths.size(); ++i) {
                Pair<Integer, Integer> versionAndLength = versionsAndLengths.get(i);
                String fileId = FSUtils.getFileId((String)((String)this.commitsToPartitionToBaseFileInfoStats.get(commitTime).get(partitionPath).get(i).getLeft()));
                fileInfos.add(Pair.of((Object)fileId, (Object)new Integer[]{(Integer)versionAndLength.getLeft(), (Integer)versionAndLength.getRight()}));
            }
            this.commitsToPartitionToLogFileInfoStats.get(commitTime).get(partitionPath).addAll(fileInfos);
            return this;
        }

        Map<String, List<Pair<String, Integer>>> getPartitionToBaseFileInfoMap(String commitTime) {
            return this.commitsToPartitionToBaseFileInfoStats.get(commitTime);
        }

        Map<String, List<Pair<String, Integer[]>>> getPartitionToLogFileInfoMap(String commitTime) {
            return this.commitsToPartitionToLogFileInfoStats.get(commitTime);
        }
    }

    public static class HoodieTestTableException
    extends RuntimeException {
        public HoodieTestTableException(Throwable t) {
            super(t);
        }
    }
}

