/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;

public class HoodieTestUtils {
    public static final String RAW_TRIPS_TEST_NAME = "raw_trips";
    public static final String DEFAULT_WRITE_TOKEN = "1-0-1";
    public static final int DEFAULT_LOG_VERSION = 1;
    public static final String[] DEFAULT_PARTITION_PATHS = new String[]{"2016/03/15", "2015/03/16", "2015/03/17"};

    public static Configuration getDefaultHadoopConf() {
        return new Configuration();
    }

    public static HoodieTableMetaClient init(String basePath) throws IOException {
        return HoodieTestUtils.init(basePath, HoodieTableType.COPY_ON_WRITE);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType) throws IOException {
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultHadoopConf(), basePath, tableType);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, boolean bootstrapIndexEnable) throws IOException {
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key(), bootstrapBasePath);
        props.put(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE.key(), (Object)bootstrapIndexEnable);
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultHadoopConf(), basePath, tableType, props);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieFileFormat baseFileFormat) throws IOException {
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultHadoopConf(), basePath, HoodieTableType.COPY_ON_WRITE, baseFileFormat);
    }

    public static HoodieTableMetaClient init(Configuration hadoopConf, String basePath) throws IOException {
        return HoodieTestUtils.init(hadoopConf, basePath, HoodieTableType.COPY_ON_WRITE);
    }

    public static HoodieTableMetaClient init(Configuration hadoopConf, String basePath, HoodieTableType tableType) throws IOException {
        return HoodieTestUtils.init(hadoopConf, basePath, tableType, new Properties());
    }

    public static HoodieTableMetaClient init(Configuration hadoopConf, String basePath, HoodieTableType tableType, String tableName) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.NAME.key(), tableName);
        return HoodieTestUtils.init(hadoopConf, basePath, tableType, properties);
    }

    public static HoodieTableMetaClient init(Configuration hadoopConf, String basePath, HoodieTableType tableType, HoodieFileFormat baseFileFormat) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.toString());
        return HoodieTestUtils.init(hadoopConf, basePath, tableType, properties);
    }

    public static HoodieTableMetaClient init(Configuration hadoopConf, String basePath, HoodieTableType tableType, Properties properties) throws IOException {
        properties = HoodieTableMetaClient.withPropertyBuilder().setTableName(RAW_TRIPS_TEST_NAME).setTableType(tableType).setPayloadClass(HoodieAvroPayload.class).fromProperties(properties).build();
        return HoodieTableMetaClient.initTableAndGetMetaClient((Configuration)hadoopConf, (String)basePath, (Properties)properties);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, HoodieFileFormat baseFileFormat) throws IOException {
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key(), bootstrapBasePath);
        props.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.name());
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultHadoopConf(), basePath, tableType, props);
    }

    public static <T extends Serializable> T serializeDeserialize(T object, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.register(HoodieTableMetaClient.class, (Serializer)new JavaSerializer());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, object);
        output.close();
        Input input = new Input((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Serializable deserializedObject = (Serializable)kryo.readObject(input, clazz);
        input.close();
        return (T)deserializedObject;
    }

    public static List<HoodieWriteStat> generateFakeHoodieWriteStat(int limit) {
        ArrayList<HoodieWriteStat> writeStatList = new ArrayList<HoodieWriteStat>();
        for (int i = 0; i < limit; ++i) {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setFileId(UUID.randomUUID().toString());
            writeStat.setNumDeletes(0L);
            writeStat.setNumUpdateWrites(100L);
            writeStat.setNumWrites(100L);
            writeStat.setPath("/some/fake/path" + i);
            writeStat.setPartitionPath("/some/fake/partition/path" + i);
            writeStat.setTotalLogFilesCompacted(100L);
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalScanTime(100L);
            runtimeStats.setTotalCreateTime(100L);
            runtimeStats.setTotalUpsertTime(100L);
            writeStat.setRuntimeStats(runtimeStats);
            writeStatList.add(writeStat);
        }
        return writeStatList;
    }
}

