/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;

public class RawTripTestPayload
implements HoodieRecordPayload<RawTripTestPayload> {
    private static final transient ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String partitionPath;
    private String rowKey;
    private byte[] jsonDataCompressed;
    private int dataSize;
    private boolean isDeleted;
    private Comparable orderingVal;

    public RawTripTestPayload(Option<String> jsonData, String rowKey, String partitionPath, String schemaStr, Boolean isDeleted, Comparable orderingVal) throws IOException {
        if (jsonData.isPresent()) {
            this.jsonDataCompressed = this.compressData((String)jsonData.get());
            this.dataSize = ((String)jsonData.get()).length();
        }
        this.rowKey = rowKey;
        this.partitionPath = partitionPath;
        this.isDeleted = isDeleted;
        this.orderingVal = orderingVal;
    }

    public RawTripTestPayload(String jsonData, String rowKey, String partitionPath, String schemaStr) throws IOException {
        this((Option<String>)Option.of((Object)jsonData), rowKey, partitionPath, schemaStr, false, Long.valueOf(0L));
    }

    public RawTripTestPayload(String jsonData) throws IOException {
        this.jsonDataCompressed = this.compressData(jsonData);
        this.dataSize = jsonData.length();
        Map jsonRecordMap = (Map)OBJECT_MAPPER.readValue(jsonData, Map.class);
        this.rowKey = jsonRecordMap.get("_row_key").toString();
        this.partitionPath = jsonRecordMap.get("time").toString().split("T")[0].replace("-", "/");
        this.isDeleted = false;
    }

    public static List<String> recordsToStrings(List<HoodieRecord> records) {
        return records.stream().map(RawTripTestPayload::recordToString).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    public static Option<String> recordToString(HoodieRecord record) {
        try {
            String str = ((RawTripTestPayload)record.getData()).getJsonData();
            str = "{" + str.substring(str.indexOf("\"timestamp\":"));
            str = str.substring(0, str.length() - 1);
            return Option.of((Object)(str + ", \"partition\": \"" + record.getPartitionPath() + "\"}"));
        }
        catch (IOException e) {
            return Option.empty();
        }
    }

    public static List<String> deleteRecordsToStrings(List<HoodieKey> records) {
        return records.stream().map(record -> "{\"_row_key\": \"" + record.getRecordKey() + "\",\"partition\": \"" + record.getPartitionPath() + "\"}").collect(Collectors.toList());
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public RawTripTestPayload preCombine(RawTripTestPayload oldValue) {
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRec, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.isDeleted) {
            return Option.empty();
        }
        MercifulJsonConverter jsonConverter = new MercifulJsonConverter();
        return Option.of((Object)jsonConverter.convert(this.getJsonData(), schema));
    }

    public IndexedRecord getRecordToInsert(Schema schema) throws IOException {
        MercifulJsonConverter jsonConverter = new MercifulJsonConverter();
        return jsonConverter.convert(this.getJsonData(), schema);
    }

    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("InputRecordCount_1506582000", "2");
        return Option.of(metadataMap);
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getJsonData() throws IOException {
        return this.unCompressData(this.jsonDataCompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressData(String jsonData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(9), true);
        try {
            dos.write(jsonData.getBytes());
        }
        finally {
            dos.flush();
            dos.close();
        }
        return baos.toByteArray();
    }

    private String unCompressData(byte[] data) throws IOException {
        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(data));){
            String string = FileIOUtils.readAsUTFString((InputStream)iis, (int)this.dataSize);
            return string;
        }
    }
}

