/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.SampleTestRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public final class SchemaTestUtil {
    private static final String RESOURCE_SAMPLE_DATA = "/sample.data";

    public static Schema getSimpleSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/simple-test.avsc"));
    }

    public static List<IndexedRecord> generateTestRecords(int from, int limit) throws IOException, URISyntaxException {
        return SchemaTestUtil.toRecords(SchemaTestUtil.getSimpleSchema(), SchemaTestUtil.getSimpleSchema(), from, limit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> generateTestJsonRecords(int from, int limit) throws IOException, URISyntaxException {
        Path dataPath = SchemaTestUtil.initializeSampleDataPath();
        try (Stream<String> stream = Files.lines(dataPath);){
            List<String> list = stream.skip(from).limit(limit).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read data from /sample.data", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<IndexedRecord> toRecords(Schema writerSchema, Schema readerSchema, int from, int limit) throws IOException, URISyntaxException {
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        Path dataPath = SchemaTestUtil.initializeSampleDataPath();
        try (Stream<String> stream = Files.lines(dataPath);){
            List<IndexedRecord> list = stream.skip(from).limit(limit).map(s -> {
                try {
                    return (IndexedRecord)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(writerSchema, s));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Could not read data from /sample.data", e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read data from /sample.data", e);
        }
    }

    private static Path initializeSampleDataPath() throws IOException, URISyntaxException {
        URI resource = SchemaTestUtil.class.getResource(RESOURCE_SAMPLE_DATA).toURI();
        if (resource.toString().contains("!")) {
            return SchemaTestUtil.uriToPath(resource);
        }
        return Paths.get(SchemaTestUtil.class.getResource(RESOURCE_SAMPLE_DATA).toURI());
    }

    public static Path uriToPath(URI uri) throws IOException {
        FileSystem fs;
        HashMap env = new HashMap();
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.getFileSystem(URI.create(array[0]));
        }
        catch (FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        return fs.getPath(array[1], new String[0]);
    }

    public static List<IndexedRecord> generateHoodieTestRecords(int from, int limit) throws IOException, URISyntaxException {
        List<IndexedRecord> records = SchemaTestUtil.generateTestRecords(from, limit);
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        Schema hoodieFieldsSchema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        return records.stream().map(s -> HoodieAvroUtils.rewriteRecord((GenericRecord)((GenericRecord)s), (Schema)hoodieFieldsSchema)).map(p -> {
            p.put("_hoodie_record_key", (Object)UUID.randomUUID().toString());
            p.put("_hoodie_partition_path", (Object)"0000/00/00");
            p.put("_hoodie_commit_time", (Object)instantTime);
            return p;
        }).collect(Collectors.toList());
    }

    public static List<HoodieRecord> generateHoodieTestRecords(int from, int limit, Schema schema) throws IOException, URISyntaxException {
        List<IndexedRecord> records = SchemaTestUtil.generateTestRecords(from, limit);
        return records.stream().map(s -> HoodieAvroUtils.rewriteRecord((GenericRecord)((GenericRecord)s), (Schema)schema)).map(p -> SchemaTestUtil.convertToHoodieRecords((IndexedRecord)p, UUID.randomUUID().toString(), "000/00/00")).collect(Collectors.toList());
    }

    private static HoodieRecord convertToHoodieRecords(IndexedRecord iRecord, String key, String partitionPath) {
        return new HoodieRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)iRecord))));
    }

    public static List<IndexedRecord> updateHoodieTestRecords(List<String> oldRecordKeys, List<IndexedRecord> newRecords, String instantTime) {
        return newRecords.stream().map(p -> {
            ((GenericRecord)p).put("_hoodie_record_key", oldRecordKeys.remove(0));
            ((GenericRecord)p).put("_hoodie_partition_path", (Object)"0000/00/00");
            ((GenericRecord)p).put("_hoodie_commit_time", (Object)instantTime);
            return p;
        }).collect(Collectors.toList());
    }

    public static List<HoodieRecord> generateHoodieTestRecordsWithoutHoodieMetadata(int from, int limit) throws IOException, URISyntaxException {
        List<IndexedRecord> iRecords = SchemaTestUtil.generateTestRecords(from, limit);
        return iRecords.stream().map(r -> new HoodieRecord(new HoodieKey(UUID.randomUUID().toString(), "0000/00/00"), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)r))))).collect(Collectors.toList());
    }

    public static List<HoodieRecord> updateHoodieTestRecordsWithoutHoodieMetadata(List<HoodieRecord> oldRecords, Schema schema, String fieldNameToUpdate, String newValue) {
        return oldRecords.stream().map(r -> {
            try {
                GenericRecord rec = (GenericRecord)r.getData().getInsertValue(schema).get();
                rec.put(fieldNameToUpdate, (Object)newValue);
                return new HoodieRecord(r.getKey(), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)rec)));
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to get data from hoodie record", io);
            }
        }).collect(Collectors.toList());
    }

    public static Schema getEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/simple-test-evolved.avsc"));
    }

    public static List<IndexedRecord> generateEvolvedTestRecords(int from, int limit) throws IOException, URISyntaxException {
        return SchemaTestUtil.toRecords(SchemaTestUtil.getSimpleSchema(), SchemaTestUtil.getEvolvedSchema(), from, limit);
    }

    public static Schema getComplexEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/complex-test-evolved.avsc"));
    }

    public static Schema getTimestampEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/timestamp-test-evolved.avsc"));
    }

    public static GenericRecord generateAvroRecordFromJson(Schema schema, int recordNumber, String instantTime, String fileId) throws IOException {
        return SchemaTestUtil.generateAvroRecordFromJson(schema, recordNumber, instantTime, fileId, true);
    }

    public static GenericRecord generateAvroRecordFromJson(Schema schema, int recordNumber, String instantTime, String fileId, boolean populateMetaFields) throws IOException {
        SampleTestRecord record = new SampleTestRecord(instantTime, recordNumber, fileId, populateMetaFields);
        MercifulJsonConverter converter = new MercifulJsonConverter();
        return converter.convert(record.toJsonString(), schema);
    }

    public static Schema getSchemaFromResource(Class<?> clazz, String name, boolean withHoodieMetadata) {
        try {
            Schema schema = new Schema.Parser().parse(clazz.getResourceAsStream(name));
            return withHoodieMetadata ? HoodieAvroUtils.addMetadataFields((Schema)schema) : schema;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to get schema from resource `%s` for class `%s`", name, clazz.getName()));
        }
    }

    public static Schema getSchemaFromResource(Class<?> clazz, String name) {
        return SchemaTestUtil.getSchemaFromResource(clazz, name, false);
    }

    public static List<IndexedRecord> generateTestRecordsForSchema(Schema schema) {
        RandomData generator = new RandomData(schema, 1000);
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
        for (Object o : generator) {
            IndexedRecord record = (IndexedRecord)o;
            records.add(record);
        }
        return records;
    }

    static class RandomData
    implements Iterable<Object> {
        private final Schema root;
        private final long seed;
        private final int count;

        public RandomData(Schema schema, int count) {
            this(schema, count, System.currentTimeMillis());
        }

        public RandomData(Schema schema, int count, long seed) {
            this.root = schema;
            this.seed = seed;
            this.count = count;
        }

        private static Object generate(Schema schema, Random random, int d) {
            switch (schema.getType()) {
                case RECORD: {
                    GenericData.Record record = new GenericData.Record(schema);
                    for (Schema.Field field : schema.getFields()) {
                        record.put(field.name(), RandomData.generate(field.schema(), random, d + 1));
                    }
                    return record;
                }
                case ENUM: {
                    List symbols = schema.getEnumSymbols();
                    return new GenericData.EnumSymbol(schema, (String)symbols.get(random.nextInt(symbols.size())));
                }
                case ARRAY: {
                    int length = random.nextInt(5) + 2 - d;
                    GenericData.Array array = new GenericData.Array(length <= 0 ? 0 : length, schema);
                    for (int i = 0; i < length; ++i) {
                        array.add(RandomData.generate(schema.getElementType(), random, d + 1));
                    }
                    return array;
                }
                case MAP: {
                    int length = random.nextInt(5) + 2 - d;
                    HashMap<Utf8, Object> map = new HashMap<Utf8, Object>(length <= 0 ? 0 : length);
                    for (int i = 0; i < length; ++i) {
                        map.put(RandomData.randomUtf8(random, 40), RandomData.generate(schema.getValueType(), random, d + 1));
                    }
                    return map;
                }
                case UNION: {
                    List types = schema.getTypes();
                    return RandomData.generate((Schema)types.get(random.nextInt(types.size() - 1)), random, d);
                }
                case FIXED: {
                    byte[] bytes = new byte[schema.getFixedSize()];
                    random.nextBytes(bytes);
                    return new GenericData.Fixed(schema, bytes);
                }
                case STRING: {
                    return RandomData.randomUtf8(random, 40);
                }
                case BYTES: {
                    return RandomData.randomBytes(random, 40);
                }
                case INT: {
                    return random.nextInt();
                }
                case LONG: {
                    return random.nextLong();
                }
                case FLOAT: {
                    return Float.valueOf(random.nextFloat());
                }
                case DOUBLE: {
                    return random.nextDouble();
                }
                case BOOLEAN: {
                    return random.nextBoolean();
                }
                case NULL: {
                    return null;
                }
            }
            throw new RuntimeException("Unknown type: " + schema);
        }

        private static Utf8 randomUtf8(Random rand, int maxLength) {
            Utf8 utf8 = new Utf8().setLength(rand.nextInt(maxLength));
            for (int i = 0; i < utf8.getLength(); ++i) {
                utf8.getBytes()[i] = (byte)(97 + rand.nextInt(25));
            }
            return utf8;
        }

        private static ByteBuffer randomBytes(Random rand, int maxLength) {
            ByteBuffer bytes = ByteBuffer.allocate(rand.nextInt(maxLength));
            bytes.limit(bytes.capacity());
            rand.nextBytes(bytes.array());
            return bytes;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private int n;
                private Random random;
                {
                    this.random = new Random(seed);
                }

                @Override
                public boolean hasNext() {
                    return this.n < count;
                }

                @Override
                public Object next() {
                    ++this.n;
                    return RandomData.generate(root, this.random, 0);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

