/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.minicluster;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.NetworkTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HdfsTestService {
    private static final Logger LOG = LogManager.getLogger(HdfsTestService.class);
    private Configuration hadoopConf;
    private final String workDir = Files.createTempDirectory("temp", new FileAttribute[0]).toAbsolutePath().toString();
    private MiniDFSCluster miniDfsCluster;

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public MiniDFSCluster start(boolean format) throws IOException {
        Objects.requireNonNull(this.workDir, "The work dir must be set before starting cluster.");
        this.hadoopConf = HoodieTestUtils.getDefaultHadoopConf();
        String localDFSLocation = HdfsTestService.getDFSLocation(this.workDir);
        if (format) {
            LOG.info((Object)("Cleaning HDFS cluster data at: " + localDFSLocation + " and starting fresh."));
            File file = new File(localDFSLocation);
            FileIOUtils.deleteDirectory((File)file);
        }
        int loop = 0;
        while (true) {
            try {
                int namenodeRpcPort = NetworkTestUtils.nextFreePort();
                int datanodePort = NetworkTestUtils.nextFreePort();
                int datanodeIpcPort = NetworkTestUtils.nextFreePort();
                int datanodeHttpPort = NetworkTestUtils.nextFreePort();
                String bindIP = "127.0.0.1";
                HdfsTestService.configureDFSCluster(this.hadoopConf, localDFSLocation, bindIP, namenodeRpcPort, datanodePort, datanodeIpcPort, datanodeHttpPort);
                this.miniDfsCluster = new MiniDFSCluster.Builder(this.hadoopConf).numDataNodes(1).format(format).checkDataNodeAddrConfig(true).checkDataNodeHostConfig(true).build();
                LOG.info((Object)"HDFS Minicluster service started.");
                return this.miniDfsCluster;
            }
            catch (BindException ex) {
                if (++loop < 5) {
                    this.stop();
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public void stop() {
        LOG.info((Object)"HDFS Minicluster service being shut down.");
        this.miniDfsCluster.shutdown();
        this.miniDfsCluster = null;
        this.hadoopConf = null;
    }

    private static String getDFSLocation(String baseFsLocation) {
        return baseFsLocation + "/" + "dfs";
    }

    private static Configuration configureDFSCluster(Configuration config, String localDFSLocation, String bindIP, int namenodeRpcPort, int datanodePort, int datanodeIpcPort, int datanodeHttpPort) {
        LOG.info((Object)("HDFS force binding to ip: " + bindIP));
        config.set("fs.defaultFS", "hdfs://" + bindIP + ":" + namenodeRpcPort);
        config.set("dfs.datanode.address", bindIP + ":" + datanodePort);
        config.set("dfs.datanode.ipc.address", bindIP + ":" + datanodeIpcPort);
        config.set("dfs.datanode.http.address", bindIP + ":" + datanodeHttpPort);
        config.setBoolean("dfs.namenode.datanode.registration.ip-hostname-check", false);
        config.set("hdfs.minidfs.basedir", localDFSLocation);
        String user = System.getProperty("user.name");
        config.set("hadoop.proxyuser." + user + ".groups", "*");
        config.set("hadoop.proxyuser." + user + ".hosts", "*");
        config.setBoolean("dfs.permissions", false);
        return config;
    }
}

