/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestClusteringUtils
extends HoodieCommonTestHarness {
    private static final String CLUSTERING_STRATEGY_CLASS = "org.apache.hudi.DefaultClusteringStrategy";
    private static final Map<String, String> STRATEGY_PARAMS = new HashMap<String, String>(){
        {
            this.put("sortColumn", "record_key");
        }
    };

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testClusteringPlanMultipleInstants() throws Exception {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        this.createRequestedReplaceInstant(partitionPath1, clusterTime1, fileIds1);
        ArrayList<String> fileIds2 = new ArrayList<String>();
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        fileIds2.add(UUID.randomUUID().toString());
        ArrayList<String> fileIds3 = new ArrayList<String>();
        fileIds3.add(UUID.randomUUID().toString());
        String clusterTime = "2";
        this.createRequestedReplaceInstant(partitionPath1, clusterTime, fileIds2, fileIds3);
        this.createRequestedReplaceInstantNotClustering("3");
        this.metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", "4"));
        this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)4, (int)this.metaClient.getActiveTimeline().filterPendingReplaceTimeline().countInstants());
        Map fileGroupToInstantMap = ClusteringUtils.getAllFileGroupsInPendingClusteringPlans((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((int)(fileIds1.size() + fileIds2.size() + fileIds3.size()), (int)fileGroupToInstantMap.size());
        this.validateClusteringInstant(fileIds1, partitionPath1, clusterTime1, fileGroupToInstantMap);
        this.validateClusteringInstant(fileIds2, partitionPath1, clusterTime, fileGroupToInstantMap);
        this.validateClusteringInstant(fileIds3, partitionPath1, clusterTime, fileGroupToInstantMap);
    }

    @Test
    public void testClusteringPlanInflight() throws Exception {
        String partitionPath1 = "partition1";
        ArrayList<String> fileIds1 = new ArrayList<String>();
        fileIds1.add(UUID.randomUUID().toString());
        fileIds1.add(UUID.randomUUID().toString());
        String clusterTime1 = "1";
        HoodieInstant requestedInstant = this.createRequestedReplaceInstant(partitionPath1, clusterTime1, fileIds1);
        HoodieInstant inflightInstant = this.metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(requestedInstant, Option.empty());
        HoodieClusteringPlan requestedClusteringPlan = (HoodieClusteringPlan)((Pair)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)requestedInstant).get()).getRight();
        HoodieClusteringPlan inflightClusteringPlan = (HoodieClusteringPlan)((Pair)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)inflightInstant).get()).getRight();
        Assertions.assertEquals((Object)requestedClusteringPlan, (Object)inflightClusteringPlan);
    }

    private void validateClusteringInstant(List<String> fileIds, String partitionPath, String expectedInstantTime, Map<HoodieFileGroupId, HoodieInstant> fileGroupToInstantMap) {
        for (String fileId : fileIds) {
            Assertions.assertEquals((Object)expectedInstantTime, (Object)fileGroupToInstantMap.get(new HoodieFileGroupId(partitionPath, fileId)).getTimestamp());
        }
    }

    private HoodieInstant createRequestedReplaceInstantNotClustering(String instantTime) throws IOException {
        HoodieInstant newRequestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", instantTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.UNKNOWN.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingReplaceCommit(newRequestedInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
        return newRequestedInstant;
    }

    private HoodieInstant createRequestedReplaceInstant(String partitionPath1, String clusterTime, List<String> ... fileIds) throws IOException {
        List[] fileSliceGroups = new List[fileIds.length];
        for (int i = 0; i < fileIds.length; ++i) {
            fileSliceGroups[i] = fileIds[i].stream().map(fileId -> this.generateFileSlice(partitionPath1, (String)fileId, "0")).collect(Collectors.toList());
        }
        HoodieClusteringPlan clusteringPlan = ClusteringUtils.createClusteringPlan((String)CLUSTERING_STRATEGY_CLASS, STRATEGY_PARAMS, (List[])fileSliceGroups, Collections.emptyMap());
        HoodieInstant clusteringInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", clusterTime);
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setClusteringPlan(clusteringPlan).setOperationType(WriteOperationType.CLUSTER.name()).build();
        this.metaClient.getActiveTimeline().saveToPendingReplaceCommit(clusteringInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
        return clusteringInstant;
    }

    private FileSlice generateFileSlice(String partitionPath, String fileId, String baseInstant) {
        FileSlice fs = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), baseInstant);
        fs.setBaseFile(new HoodieBaseFile(FSUtils.makeDataFileName((String)baseInstant, (String)"1-0-1", (String)fileId)));
        return fs;
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

