/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.time.format.DateTimeParseException;
import org.apache.hudi.common.util.DateTimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestDateTimeUtils {
    @ParameterizedTest
    @ValueSource(strings={"0", "1612542030000", "2020-01-01T01:01:00Z", "1970-01-01T00:00:00.123456Z"})
    public void testParseStringIntoInstant(String s) {
        Assertions.assertDoesNotThrow(() -> DateTimeUtils.parseDateTime((String)s));
    }

    @ParameterizedTest
    @ValueSource(strings={"#", "0L", ""})
    public void testParseDateTimeThrowsException(String s) {
        Assertions.assertThrows(DateTimeParseException.class, () -> DateTimeUtils.parseDateTime((String)s));
    }

    @Test
    public void testParseDateTimeWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateTimeUtils.parseDateTime(null));
    }
}

