/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import org.apache.hudi.common.util.NumericUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNumericUtils {
    @Test
    public void testHumanReadableByteCount() {
        Assertions.assertEquals((Object)"0.0 B", (Object)NumericUtils.humanReadableByteCount((double)0.0));
        Assertions.assertEquals((Object)"27.0 B", (Object)NumericUtils.humanReadableByteCount((double)27.0));
        Assertions.assertEquals((Object)"1023.0 B", (Object)NumericUtils.humanReadableByteCount((double)1023.0));
        Assertions.assertEquals((Object)"1.0 KB", (Object)NumericUtils.humanReadableByteCount((double)1024.0));
        Assertions.assertEquals((Object)"108.0 KB", (Object)NumericUtils.humanReadableByteCount((double)110592.0));
        Assertions.assertEquals((Object)"27.0 GB", (Object)NumericUtils.humanReadableByteCount((double)2.8991029248E10));
        Assertions.assertEquals((Object)"1.7 TB", (Object)NumericUtils.humanReadableByteCount((double)1.855425871872E12));
        Assertions.assertEquals((Object)"8.0 EB", (Object)NumericUtils.humanReadableByteCount((double)9.223372036854776E18));
    }

    @Test
    public void testGetMessageDigestHash() {
        Assertions.assertEquals((long)6808551913422584641L, (long)NumericUtils.getMessageDigestHash((String)"MD5", (String)"This is a string"));
        Assertions.assertEquals((long)2549749777095932358L, (long)NumericUtils.getMessageDigestHash((String)"MD5", (String)"This is a test string"));
        Assertions.assertNotEquals((long)1L, (long)NumericUtils.getMessageDigestHash((String)"MD5", (String)"This"));
        Assertions.assertNotEquals((long)6808551913422584641L, (long)NumericUtils.getMessageDigestHash((String)"SHA-256", (String)"This is a string"));
    }

    private static byte[] byteArrayWithNum(int size, int num) {
        byte[] bytez = new byte[size];
        Arrays.fill(bytez, (byte)num);
        return bytez;
    }

    @Test
    public void testPadToLong() {
        Assertions.assertEquals((long)0x99999999L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(4, 153)));
        Assertions.assertEquals((long)0x999999999999L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(6, 153)));
        Assertions.assertEquals((long)-7378697629483820647L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(8, 153)));
        Assertions.assertEquals((long)0x1111111111111111L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(8, 17)));
        Assertions.assertEquals((long)0x11111111L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(4, 17)));
        Assertions.assertEquals((long)0x181818181818L, (long)NumericUtils.padToLong((byte[])TestNumericUtils.byteArrayWithNum(6, 24)));
    }
}

