/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestParquetUtils
extends HoodieCommonTestHarness {
    private ParquetUtils parquetUtils;

    public static List<Arguments> bloomFilterTypeCodes() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{BloomFilterTypeCode.SIMPLE.name()}), Arguments.of((Object[])new Object[]{BloomFilterTypeCode.DYNAMIC_V0.name()}));
    }

    @BeforeEach
    public void setup() {
        this.initPath();
        this.parquetUtils = new ParquetUtils();
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testHoodieWriteSupport(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            rowKeys.add(UUID.randomUUID().toString());
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toUri().toString();
        this.writeParquetFile(typeCode, filePath, rowKeys);
        ArrayList rowKeysInFile = new ArrayList(this.parquetUtils.readRowKeys(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath)));
        Collections.sort(rowKeysInFile);
        Collections.sort(rowKeys);
        Assertions.assertEquals(rowKeys, rowKeysInFile, (String)"Did not read back the expected list of keys");
        BloomFilter filterInFile = this.parquetUtils.readBloomFilterFromMetadata(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath));
        for (String rowKey : rowKeys) {
            Assertions.assertTrue((boolean)filterInFile.mightContain(rowKey), (String)"key should be found in bloom filter");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testFilterParquetRowKeys(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        HashSet<String> filter = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            String rowKey = UUID.randomUUID().toString();
            rowKeys.add(rowKey);
            if (i % 100 != 0) continue;
            filter.add(rowKey);
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toUri().toString();
        this.writeParquetFile(typeCode, filePath, rowKeys);
        Set filtered = this.parquetUtils.filterRowKeys(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath), filter);
        Assertions.assertEquals((int)filter.size(), (int)filtered.size(), (String)"Filtered count does not match");
        for (String rowKey : filtered) {
            Assertions.assertTrue((boolean)filter.contains(rowKey), (String)"filtered key must be in the given filter");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testFetchRecordKeyPartitionPathFromParquet(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        ArrayList<HoodieKey> expected = new ArrayList<HoodieKey>();
        String partitionPath = "path1";
        for (int i = 0; i < 1000; ++i) {
            String rowKey = UUID.randomUUID().toString();
            rowKeys.add(rowKey);
            expected.add(new HoodieKey(rowKey, partitionPath));
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toUri().toString();
        Schema schema = HoodieAvroUtils.getRecordKeyPartitionPathSchema();
        this.writeParquetFile(typeCode, filePath, rowKeys, schema, true, partitionPath);
        List fetchedRows = this.parquetUtils.fetchRecordKeyPartitionPath(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath));
        Assertions.assertEquals((int)rowKeys.size(), (int)fetchedRows.size(), (String)"Total count does not match");
        for (HoodieKey entry : fetchedRows) {
            Assertions.assertTrue((boolean)expected.contains(entry), (String)"Record key must be in the given filter");
        }
    }

    @Test
    public void testFetchRecordKeyPartitionPathVirtualKeysFromParquet() throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        ArrayList<HoodieKey> expected = new ArrayList<HoodieKey>();
        String partitionPath = "path1";
        for (int i = 0; i < 1000; ++i) {
            String rowKey = UUID.randomUUID().toString();
            rowKeys.add(rowKey);
            expected.add(new HoodieKey(rowKey, partitionPath));
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toUri().toString();
        Schema schema = TestParquetUtils.getSchemaWithFields(Arrays.asList("abc", "def"));
        this.writeParquetFile(BloomFilterTypeCode.SIMPLE.name(), filePath, rowKeys, schema, true, partitionPath, false, "abc", "def");
        List fetchedRows = this.parquetUtils.fetchRecordKeyPartitionPath(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath), Option.of((Object)((Object)new TestBaseKeyGen("abc", "def"))));
        Assertions.assertEquals((int)rowKeys.size(), (int)fetchedRows.size(), (String)"Total count does not match");
        for (HoodieKey entry : fetchedRows) {
            Assertions.assertTrue((boolean)expected.contains(entry), (String)"Record key must be in the given filter");
        }
    }

    @Test
    public void testReadCounts() throws Exception {
        String filePath = Paths.get(this.basePath, "test.parquet").toUri().toString();
        ArrayList<String> rowKeys = new ArrayList<String>();
        for (int i = 0; i < 123; ++i) {
            rowKeys.add(UUID.randomUUID().toString());
        }
        this.writeParquetFile(BloomFilterTypeCode.SIMPLE.name(), filePath, rowKeys);
        Assertions.assertEquals((long)123L, (long)this.parquetUtils.getRowCount(HoodieTestUtils.getDefaultHadoopConf(), new Path(filePath)));
    }

    private void writeParquetFile(String typeCode, String filePath, List<String> rowKeys) throws Exception {
        this.writeParquetFile(typeCode, filePath, rowKeys, HoodieAvroUtils.getRecordKeySchema(), false, "");
    }

    private void writeParquetFile(String typeCode, String filePath, List<String> rowKeys, Schema schema, boolean addPartitionPathField, String partitionPath) throws Exception {
        this.writeParquetFile(typeCode, filePath, rowKeys, schema, addPartitionPathField, partitionPath, true, null, null);
    }

    private void writeParquetFile(String typeCode, String filePath, List<String> rowKeys, Schema schema, boolean addPartitionPathField, String partitionPathValue, boolean useMetaFields, String recordFieldName, String partitionFieldName) throws Exception {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)10000, (String)typeCode);
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, Option.of((Object)filter));
        ParquetWriter writer = new ParquetWriter(new Path(filePath), (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000);
        for (String rowKey : rowKeys) {
            GenericData.Record rec = new GenericData.Record(schema);
            rec.put(useMetaFields ? "_hoodie_record_key" : recordFieldName, (Object)rowKey);
            if (addPartitionPathField) {
                rec.put(useMetaFields ? "_hoodie_partition_path" : partitionFieldName, (Object)partitionPathValue);
            }
            writer.write((Object)rec);
            writeSupport.add(rowKey);
        }
        writer.close();
    }

    private static Schema getSchemaWithFields(List<String> fields) {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        for (String field : fields) {
            Schema.Field schemaField = new Schema.Field(field, HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
            toBeAddedFields.add(schemaField);
        }
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    class TestBaseKeyGen
    extends BaseKeyGenerator {
        private String recordKeyField;
        private String partitionField;

        public TestBaseKeyGen(String recordKeyField, String partitionField) {
            super(new TypedProperties());
            this.recordKeyField = recordKeyField;
            this.partitionField = partitionField;
        }

        public String getRecordKey(GenericRecord record) {
            return record.get(this.recordKeyField).toString();
        }

        public String getPartitionPath(GenericRecord record) {
            return record.get(this.partitionField).toString();
        }

        public List<String> getRecordKeyFields() {
            return Arrays.asList(this.recordKeyField);
        }

        public List<String> getPartitionPathFields() {
            return Arrays.asList(this.partitionField);
        }
    }
}

