/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringUtils {
    private static final String[] STRINGS = new String[]{"This", "is", "a", "test"};

    @Test
    public void testStringJoinWithDelim() {
        String joinedString = StringUtils.joinUsingDelim((String)"-", (String[])STRINGS);
        Assertions.assertEquals((int)STRINGS.length, (int)joinedString.split("-").length);
    }

    @Test
    public void testStringJoin() {
        Assertions.assertNotEquals(null, (Object)StringUtils.join((String[])new String[]{""}));
        Assertions.assertNotEquals(null, (Object)StringUtils.join((String[])STRINGS));
    }

    @Test
    public void testStringNullToEmpty() {
        String str = "This is a test";
        Assertions.assertEquals((Object)str, (Object)StringUtils.nullToEmpty((String)str));
        Assertions.assertEquals((Object)"", (Object)StringUtils.nullToEmpty(null));
    }

    @Test
    public void testStringEmptyToNull() {
        Assertions.assertNull((Object)StringUtils.emptyToNull((String)""));
        Assertions.assertEquals((Object)"Test String", (Object)StringUtils.emptyToNull((String)"Test String"));
    }

    @Test
    public void testStringNullOrEmpty() {
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty(null));
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty((String)""));
        Assertions.assertNotEquals(null, (Object)StringUtils.isNullOrEmpty((String)"this is not empty"));
        Assertions.assertTrue((boolean)StringUtils.isNullOrEmpty((String)""));
    }
}

