/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class TestExternalSpillableMap
extends HoodieCommonTestHarness {
    private static String failureOutputPath;

    @BeforeEach
    public void setUp() {
        this.initPath();
        failureOutputPath = this.basePath + "/test_fail";
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void simpleInsertTest(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        Iterator itr = records.iterator();
        int cntSize = 0;
        while (itr.hasNext()) {
            HoodieRecord rec = (HoodieRecord)itr.next();
            ++cntSize;
            assert (recordKeys.contains(rec.getRecordKey()));
        }
        Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
        List values = records.valueStream().collect(Collectors.toList());
        cntSize = 0;
        for (HoodieRecord value : values) {
            assert (recordKeys.contains(value.getRecordKey()));
            ++cntSize;
        }
        Assertions.assertEquals((int)recordKeys.size(), (int)cntSize);
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testSimpleUpsert(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        for (HoodieRecord rec : records) {
            assert (recordKeys.contains(rec.getRecordKey()));
        }
        List<IndexedRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecords(recordKeys, SchemaTestUtil.generateHoodieTestRecords(0, 100), HoodieActiveTimeline.createNewInstantTime());
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        Assertions.assertTrue((records.getDiskBasedMapNumEntries() > 0 ? 1 : 0) != 0);
        updatedRecords.forEach(record -> {
            HoodieRecord rec = (HoodieRecord)records.get(((GenericRecord)record).get("_hoodie_record_key"));
            try {
                Assertions.assertEquals((Object)rec.getData().getInsertValue(schema).get(), (Object)record);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testAllMapOperations(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        String payloadClazz = HoodieAvroPayload.class.getName();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        IndexedRecord inMemoryRecord = iRecords.get(0);
        String ikey = ((GenericRecord)inMemoryRecord).get("_hoodie_record_key").toString();
        String iPartitionPath = ((GenericRecord)inMemoryRecord).get("_hoodie_partition_path").toString();
        HoodieRecord inMemoryHoodieRecord = new HoodieRecord(new HoodieKey(ikey, iPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)inMemoryRecord))));
        IndexedRecord onDiskRecord = iRecords.get(99);
        String dkey = ((GenericRecord)onDiskRecord).get("_hoodie_record_key").toString();
        String dPartitionPath = ((GenericRecord)onDiskRecord).get("_hoodie_partition_path").toString();
        HoodieRecord onDiskHoodieRecord = new HoodieRecord(new HoodieKey(dkey, dPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)onDiskRecord))));
        assert (records.size() == 100);
        assert (inMemoryHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)ikey)).getKey()));
        assert (onDiskHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)dkey)).getKey()));
        assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getFileId().equals("DUMMY_FILE_ID"));
        assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getInstantTime().equals("DUMMY_COMMIT_TIME"));
        Assertions.assertTrue((boolean)records.containsKey((Object)ikey));
        Assertions.assertTrue((boolean)records.containsKey((Object)dkey));
        Assertions.assertFalse((boolean)records.isEmpty());
        Assertions.assertTrue((boolean)records.keySet().containsAll(recordKeys));
        HoodieRecord removedRecord = (HoodieRecord)records.remove((Object)ikey);
        Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)records.containsKey((Object)ikey));
        removedRecord = (HoodieRecord)records.remove((Object)dkey);
        Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)records.containsKey((Object)dkey));
        records.clear();
        Assertions.assertTrue((records.size() == 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void simpleTestWithException(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), failureOutputPath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        Iterator itr = records.iterator();
        Assertions.assertThrows(IOException.class, () -> {
            if (itr.hasNext()) {
                throw new IOException("Testing failures...");
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDataCorrectnessWithUpsertsToDataInMapAndOnDisk(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        ArrayList<String> recordKeys = new ArrayList<String>();
        while (records.getDiskBasedMapNumEntries() < 1) {
            List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
            recordKeys.addAll(SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records));
        }
        String key = (String)recordKeys.get(0);
        HoodieRecord record = (HoodieRecord)records.get((Object)key);
        ArrayList<Object> recordsToUpdate = new ArrayList<IndexedRecord>();
        recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
        String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
        ArrayList<String> keysToBeUpdated = new ArrayList<String>();
        keysToBeUpdated.add(key);
        List<IndexedRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, newCommitTime);
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        GenericRecord gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        assert (newCommitTime.contentEquals(gRecord.get("_hoodie_commit_time").toString()));
        key = (String)recordKeys.get(recordKeys.size() - 1);
        record = (HoodieRecord)records.get((Object)key);
        recordsToUpdate = new ArrayList();
        recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
        newCommitTime = HoodieActiveTimeline.createNewInstantTime();
        keysToBeUpdated = new ArrayList();
        keysToBeUpdated.add(key);
        updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, newCommitTime);
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        assert (newCommitTime.contentEquals(gRecord.get("_hoodie_commit_time").toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDataCorrectnessWithoutHoodieMetadata(ExternalSpillableMap.DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException, URISyntaxException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, isCompressionEnabled);
        ArrayList recordKeys = new ArrayList();
        while (records.getDiskBasedMapNumEntries() < 1) {
            List<HoodieRecord> hoodieRecords = SchemaTestUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 100);
            hoodieRecords.stream().forEach(r -> {
                records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r);
                recordKeys.add(r.getRecordKey());
            });
        }
        String key = (String)recordKeys.get(0);
        HoodieRecord record = (HoodieRecord)records.get((Object)key);
        String fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
        String newValue = "update1";
        ArrayList<Object> recordsToUpdate = new ArrayList<HoodieRecord>();
        recordsToUpdate.add(record);
        List<HoodieRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, schema, fieldName, newValue);
        updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r));
        GenericRecord gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
        key = (String)recordKeys.get(recordKeys.size() - 1);
        record = (HoodieRecord)records.get((Object)key);
        fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
        newValue = "update2";
        recordsToUpdate = new ArrayList();
        recordsToUpdate.add(record);
        updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, schema, fieldName, newValue);
        updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r));
        gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
    }

    @Test
    public void testEstimationWithEmptyMap() throws IOException, URISyntaxException {
        ExternalSpillableMap.DiskMapType diskMapType = ExternalSpillableMap.DiskMapType.BITCASK;
        boolean isCompressionEnabled = false;
        Schema schema = SchemaTestUtil.getSimpleSchema();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema), diskMapType, false);
        ArrayList recordKeys = new ArrayList();
        HoodieRecord seedRecord = SchemaTestUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 1).get(0);
        records.put((Serializable)((Object)seedRecord.getRecordKey()), (Serializable)seedRecord);
        records.remove((Object)seedRecord.getRecordKey());
        List<HoodieRecord> hoodieRecords = SchemaTestUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 250);
        hoodieRecords.stream().forEach(hoodieRecord -> {
            Assertions.assertDoesNotThrow(() -> records.put((Serializable)((Object)hoodieRecord.getRecordKey()), (Serializable)hoodieRecord), (String)"ExternalSpillableMap put() should not throw exception!");
            recordKeys.add(hoodieRecord.getRecordKey());
        });
    }

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.BITCASK, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.ROCKS_DB, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.UNKNOWN, false}), Arguments.arguments((Object[])new Object[]{ExternalSpillableMap.DiskMapType.BITCASK, true}));
    }
}

