/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieOrcReader;
import org.apache.hudi.io.storage.HoodieParquetReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieFileReaderFactory {
    @TempDir
    public java.nio.file.Path tempDir;

    @Test
    public void testGetFileReader() throws IOException {
        Configuration hadoopConf = new Configuration();
        Path parquetPath = new Path("/partition/path/f1_1-0-1_000.parquet");
        HoodieFileReader parquetReader = HoodieFileReaderFactory.getFileReader((Configuration)hadoopConf, (Path)parquetPath);
        Assertions.assertTrue((boolean)(parquetReader instanceof HoodieParquetReader));
        Path logPath = new Path("/partition/path/f.b51192a8-574b-4a85-b246-bcfec03ac8bf_100.log.2_1-0-1");
        Throwable thrown = Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            HoodieFileReader logWriter = HoodieFileReaderFactory.getFileReader((Configuration)hadoopConf, (Path)logPath);
        }, (String)"should fail since log storage reader is not supported yet.");
        Assertions.assertTrue((boolean)thrown.getMessage().contains("format not supported yet."));
        Path orcPath = new Path("/partition/path/f1_1-0-1_000.orc");
        HoodieFileReader orcReader = HoodieFileReaderFactory.getFileReader((Configuration)hadoopConf, (Path)orcPath);
        Assertions.assertTrue((boolean)(orcReader instanceof HoodieOrcReader));
    }
}

