/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFileSystemBackedTableMetadata
extends HoodieCommonTestHarness {
    private static final String DEFAULT_PARTITION = "";
    private static final List<String> DATE_PARTITIONS = Arrays.asList("2019/01/01", "2020/01/02", "2021/03/01");
    private static final List<String> ONE_LEVEL_PARTITIONS = Arrays.asList("2019", "2020", "2021");
    private static final List<String> MULTI_LEVEL_PARTITIONS = Arrays.asList("2019/01", "2020/01", "2021/01");
    private static HoodieTestTable hoodieTestTable;

    @BeforeEach
    public void setUp() throws IOException {
        this.initMetaClient();
        hoodieTestTable = HoodieTestTable.of(this.metaClient);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.metaClient.getFs().delete(new Path(this.metaClient.getBasePath()), true);
    }

    @Test
    public void testNonPartitionedTable() throws Exception {
        hoodieTestTable.addCommit("100").withBaseFilesInPartition(DEFAULT_PARTITION, IntStream.range(0, 10).toArray());
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, false);
        Assertions.assertEquals((int)0, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new Path(this.basePath)).length);
        Assertions.assertEquals((int)10, (int)((FileStatus[])fileSystemBackedTableMetadata.getAllFilesInPartitions(Collections.singletonList(this.basePath)).get(this.basePath)).length);
    }

    @Test
    public void testDatePartitionedTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        DATE_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, true);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new Path(this.basePath + "/" + DATE_PARTITIONS.get(0))).length);
        List fullPartitionPaths = DATE_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((FileStatus[])partitionToFilesMap.get(p2)).length);
        }
    }

    @Test
    public void testDatePartitionedTableWithAssumeDateIsFalse() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        DATE_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, false);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        List fullPartitionPaths = DATE_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((FileStatus[])partitionToFilesMap.get(p2)).length);
        }
    }

    @Test
    public void testOneLevelPartitionedTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        ONE_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, false);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new Path(this.basePath + "/" + ONE_LEVEL_PARTITIONS.get(0))).length);
        List fullPartitionPaths = ONE_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((FileStatus[])partitionToFilesMap.get(p2)).length);
        }
    }

    @Test
    public void testMultiLevelPartitionedTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        MULTI_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p).withBaseFilesInPartition((String)p, IntStream.range(0, 10).toArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, false);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)10, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new Path(this.basePath + "/" + MULTI_LEVEL_PARTITIONS.get(0))).length);
        List fullPartitionPaths = MULTI_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)10, (int)((FileStatus[])partitionToFilesMap.get(p2)).length);
        }
    }

    @Test
    public void testMultiLevelEmptyPartitionTable() throws Exception {
        String instant = "100";
        hoodieTestTable = hoodieTestTable.addCommit(instant);
        MULTI_LEVEL_PARTITIONS.stream().forEach(p -> {
            try {
                hoodieTestTable = hoodieTestTable.withPartitionMetaFiles((String)p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieLocalEngineContext localEngineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
        FileSystemBackedTableMetadata fileSystemBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)localEngineContext, new SerializableConfiguration(this.metaClient.getHadoopConf()), this.basePath, false);
        Assertions.assertEquals((int)3, (int)fileSystemBackedTableMetadata.getAllPartitionPaths().size());
        Assertions.assertEquals((int)0, (int)fileSystemBackedTableMetadata.getAllFilesInPartition(new Path(this.basePath + "/" + MULTI_LEVEL_PARTITIONS.get(0))).length);
        List fullPartitionPaths = MULTI_LEVEL_PARTITIONS.stream().map(p -> this.basePath + "/" + p).collect(Collectors.toList());
        Map partitionToFilesMap = fileSystemBackedTableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        for (String p2 : fullPartitionPaths) {
            Assertions.assertEquals((int)0, (int)((FileStatus[])partitionToFilesMap.get(p2)).length);
        }
    }
}

