/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieAvroUtils {
    private static String EVOLVED_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec1\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"new_col1\", \"type\": \"string\", \"default\": \"dummy_val\"},{\"name\": \"new_col2\", \"type\": [\"int\", \"null\"]}]}";
    private static String EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"}]}";
    private static String SCHEMA_WITH_METADATA_FIELD = "{\"type\": \"record\",\"name\": \"testrec2\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"_hoodie_commit_time\", \"type\": [\"null\", \"string\"]},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"nullable_field_wo_default\",\"type\": [\"null\" ,\"string\"]}]}";
    private static String SCHEMA_WITH_NON_NULLABLE_FIELD = "{\"type\": \"record\",\"name\": \"testrec3\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"non_nullable_field_wo_default\",\"type\": \"string\"},{\"name\": \"non_nullable_field_with_default\",\"type\": \"string\", \"default\": \"dummy\"}]}";
    private static String SCHEMA_WITH_NON_NULLABLE_FIELD_WITH_DEFAULT = "{\"type\": \"record\",\"name\": \"testrec4\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"non_nullable_field_with_default\",\"type\": \"string\", \"default\": \"dummy\"}]}";

    @Test
    public void testPropsPresent() {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EXAMPLE_SCHEMA));
        boolean piiPresent = false;
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField((String)field.name())) continue;
            Assertions.assertNotNull((Object)field.name(), (String)"field name is null");
            Map props = field.getObjectProps();
            Assertions.assertNotNull((Object)props, (String)"The property is null");
            if (field.name().equals("pii_col")) {
                piiPresent = true;
                Assertions.assertTrue((boolean)props.containsKey("column_category"), (String)"sensitivity_level is removed in field 'pii_col'");
                continue;
            }
            Assertions.assertEquals((int)0, (int)props.size(), (String)"The property shows up but not set");
        }
        Assertions.assertTrue((boolean)piiPresent, (String)"column pii_col doesn't show up");
    }

    @Test
    public void testDefaultValue() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EVOLVED_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        Schema schemaWithMetadata = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EVOLVED_SCHEMA));
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)schemaWithMetadata);
        Assertions.assertEquals((Object)rec1.get("new_col1"), (Object)"dummy_val");
        Assertions.assertNull((Object)rec1.get("new_col2"));
        Assertions.assertNull((Object)rec1.get("_hoodie_record_key"));
    }

    @Test
    public void testDefaultValueWithSchemaEvolution() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(EVOLVED_SCHEMA));
        Assertions.assertEquals((Object)rec1.get("new_col1"), (Object)"dummy_val");
        Assertions.assertNull((Object)rec1.get("new_col2"));
    }

    @Test
    public void testMetadataField() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_METADATA_FIELD));
        Assertions.assertNull((Object)rec1.get("_hoodie_commit_time"));
        Assertions.assertNull((Object)rec1.get("nullable_field"));
        Assertions.assertNull((Object)rec1.get("nullable_field_wo_default"));
    }

    @Test
    public void testNonNullableFieldWithoutDefault() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        Assertions.assertThrows(SchemaCompatibilityException.class, () -> TestHoodieAvroUtils.lambda$testNonNullableFieldWithoutDefault$0((GenericRecord)rec));
    }

    @Test
    public void testNonNullableFieldWithDefault() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_NON_NULLABLE_FIELD_WITH_DEFAULT));
        Assertions.assertEquals((Object)rec1.get("non_nullable_field_with_default"), (Object)"dummy");
    }

    @Test
    public void testJsonNodeNullWithDefaultValues() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Schema initialSchema = Schema.createRecord((String)"test_record", (String)"test record", (String)"org.test.namespace", (boolean)false);
        Schema.Field field1 = new Schema.Field("key", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field field2 = new Schema.Field("key1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field field3 = new Schema.Field("key2", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        fields.add(field1);
        fields.add(field2);
        fields.add(field3);
        initialSchema.setFields(fields);
        GenericData.Record rec = new GenericData.Record(initialSchema);
        rec.put("key", (Object)"val");
        rec.put("key1", (Object)"val1");
        rec.put("key2", (Object)"val2");
        ArrayList<Schema.Field> evolvedFields = new ArrayList<Schema.Field>();
        Schema evolvedSchema = Schema.createRecord((String)"evolved_record", (String)"evolved record", (String)"org.evolved.namespace", (boolean)false);
        Schema.Field evolvedField1 = new Schema.Field("key", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField2 = new Schema.Field("key1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField3 = new Schema.Field("key2", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField4 = new Schema.Field("evolved_field", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance());
        Schema.Field evolvedField5 = new Schema.Field("evolved_field1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        evolvedFields.add(evolvedField1);
        evolvedFields.add(evolvedField2);
        evolvedFields.add(evolvedField3);
        evolvedFields.add(evolvedField4);
        evolvedFields.add(evolvedField5);
        evolvedSchema.setFields(evolvedFields);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)evolvedSchema);
        Assertions.assertNull((Object)rec1.get("evolved_field"));
        Assertions.assertNull((Object)rec1.get("evolved_field1"));
    }

    private static /* synthetic */ void lambda$testNonNullableFieldWithoutDefault$0(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_NON_NULLABLE_FIELD));
    }
}

