/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieAvroWriteSupport {
    @Test
    public void testAddKey(@TempDir java.nio.file.Path tempDir) throws IOException {
        ArrayList<String> rowKeys = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            rowKeys.add(UUID.randomUUID().toString());
        }
        String filePath = tempDir.resolve("test.parquet").toAbsolutePath().toString();
        Schema schema = HoodieAvroUtils.getRecordKeySchema();
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)10000, (String)BloomFilterTypeCode.SIMPLE.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, filter);
        ParquetWriter writer = new ParquetWriter(new Path(filePath), (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000);
        for (String rowKey : rowKeys) {
            GenericData.Record rec = new GenericData.Record(schema);
            rec.put("_hoodie_record_key", (Object)rowKey);
            writer.write((Object)rec);
            writeSupport.add(rowKey);
        }
        writer.close();
    }
}

