/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hudi.avro.model.HoodieFSPermission;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBootstrapIndex
extends HoodieCommonTestHarness {
    private static final String[] PARTITIONS = new String[]{"2020/03/18", "2020/03/19", "2020/03/20", "2020/03/21"};
    private static final Set<String> PARTITION_SET = Arrays.stream(PARTITIONS).collect(Collectors.toSet());
    private static final String BOOTSTRAP_BASE_PATH = "/tmp/source/parquet_tables/table1";

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testBootstrapIndex() throws IOException {
        this.testBootstrapIndexOneRound(10);
    }

    @Test
    public void testBootstrapIndexRecreateIndex() throws IOException {
        this.testBootstrapIndexOneRound(10);
        HFileBootstrapIndex index = new HFileBootstrapIndex(this.metaClient);
        index.dropIndex();
        this.testBootstrapIndexOneRound(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBootstrapIndexConcurrent() throws Exception {
        Map<String, List<BootstrapFileMapping>> bootstrapMapping = TestBootstrapIndex.generateBootstrapIndex(this.metaClient, BOOTSTRAP_BASE_PATH, PARTITIONS, 100);
        int numThreads = 20;
        int numRequestsPerThread = 50;
        ExecutorService service = Executors.newFixedThreadPool(20);
        try {
            ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
            for (int i = 0; i < 20; ++i) {
                Future<Boolean> future = service.submit(() -> {
                    for (int j = 0; j < 50; ++j) {
                        this.validateBootstrapIndex(bootstrapMapping);
                    }
                    return true;
                });
                futureList.add(future);
            }
            for (Future future : futureList) {
                future.get();
            }
        }
        finally {
            service.shutdownNow();
        }
    }

    private void testBootstrapIndexOneRound(int numEntriesPerPartition) throws IOException {
        Map<String, List<BootstrapFileMapping>> bootstrapMapping = TestBootstrapIndex.generateBootstrapIndex(this.metaClient, BOOTSTRAP_BASE_PATH, PARTITIONS, numEntriesPerPartition);
        this.validateBootstrapIndex(bootstrapMapping);
    }

    public static Map<String, List<BootstrapFileMapping>> generateBootstrapIndex(HoodieTableMetaClient metaClient, String sourceBasePath, String[] partitions, int numEntriesPerPartition) {
        Map<String, List<BootstrapFileMapping>> bootstrapMapping = TestBootstrapIndex.generateBootstrapMapping(sourceBasePath, partitions, numEntriesPerPartition);
        HFileBootstrapIndex index = new HFileBootstrapIndex(metaClient);
        try (BootstrapIndex.IndexWriter writer = index.createWriter(sourceBasePath);){
            writer.begin();
            bootstrapMapping.entrySet().stream().forEach(e -> writer.appendNextPartition((String)e.getKey(), (List)e.getValue()));
            writer.finish();
        }
        return bootstrapMapping;
    }

    private void validateBootstrapIndex(Map<String, List<BootstrapFileMapping>> bootstrapMapping) {
        HFileBootstrapIndex index = new HFileBootstrapIndex(this.metaClient);
        try (BootstrapIndex.IndexReader reader = index.createReader();){
            List indexedPartitions = reader.getIndexedPartitionPaths();
            Assertions.assertEquals((int)bootstrapMapping.size(), (int)indexedPartitions.size());
            indexedPartitions.forEach(partition -> Assertions.assertTrue((boolean)PARTITION_SET.contains(partition)));
            long expNumFileGroupKeys = bootstrapMapping.values().stream().flatMap(Collection::stream).count();
            List fileGroupIds = reader.getIndexedFileGroupIds();
            long gotNumFileGroupKeys = fileGroupIds.size();
            Assertions.assertEquals((long)expNumFileGroupKeys, (long)gotNumFileGroupKeys);
            fileGroupIds.forEach(fgId -> Assertions.assertTrue((boolean)PARTITION_SET.contains(fgId.getPartitionPath())));
            bootstrapMapping.entrySet().stream().forEach(e -> {
                List gotMapping = reader.getSourceFileMappingForPartition((String)e.getKey());
                ArrayList expected = new ArrayList((Collection)e.getValue());
                Collections.sort(gotMapping);
                Collections.sort(expected);
                Assertions.assertEquals(expected, (Object)gotMapping, (String)("Check for bootstrap index entries for partition " + (String)e.getKey()));
                List fileIds = ((List)e.getValue()).stream().map(BootstrapFileMapping::getFileGroupId).collect(Collectors.toList());
                Map lookupResult = reader.getSourceFileMappingForFileIds(fileIds);
                Assertions.assertEquals((int)fileIds.size(), (int)lookupResult.size());
                ((List)e.getValue()).forEach(x -> {
                    BootstrapFileMapping res = (BootstrapFileMapping)lookupResult.get(x.getFileGroupId());
                    Assertions.assertNotNull((Object)res);
                    Assertions.assertEquals((Object)x.getFileId(), (Object)res.getFileId());
                    Assertions.assertEquals((Object)x.getPartitionPath(), (Object)res.getPartitionPath());
                    Assertions.assertEquals((Object)BOOTSTRAP_BASE_PATH, (Object)res.getBootstrapBasePath());
                    Assertions.assertEquals((Object)x.getBootstrapFileStatus(), (Object)res.getBootstrapFileStatus());
                    Assertions.assertEquals((Object)x.getBootstrapPartitionPath(), (Object)res.getBootstrapPartitionPath());
                });
            });
        }
    }

    private static Map<String, List<BootstrapFileMapping>> generateBootstrapMapping(String sourceBasePath, String[] partitions, int numEntriesPerPartition) {
        return Arrays.stream(partitions).map(partition -> Pair.of((Object)partition, IntStream.range(0, numEntriesPerPartition).mapToObj(idx -> {
            String hudiFileId = UUID.randomUUID().toString();
            String sourceFileName = idx + ".parquet";
            HoodieFileStatus sourceFileStatus = HoodieFileStatus.newBuilder().setPath(HoodiePath.newBuilder().setUri(sourceBasePath + "/" + partition + "/" + sourceFileName).build()).setLength(Long.valueOf(0x10000000L)).setAccessTime(Long.valueOf(new Date().getTime())).setModificationTime(Long.valueOf(new Date().getTime() + 99999L)).setBlockReplication(Integer.valueOf(2)).setOwner("hudi").setGroup("hudi").setBlockSize(Long.valueOf(0x8000000L)).setPermission(HoodieFSPermission.newBuilder().setUserAction(FsAction.ALL.name()).setGroupAction(FsAction.READ.name()).setOtherAction(FsAction.NONE.name()).setStickyBit(Boolean.valueOf(true)).build()).build();
            return new BootstrapFileMapping(sourceBasePath, partition, partition, sourceFileStatus, hudiFileId);
        }).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }
}

